/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.optiq.impl.clone;

import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import net.hydromatic.linq4j.Ord;
import net.hydromatic.linq4j.QueryProvider;
import net.hydromatic.linq4j.Queryable;
import net.hydromatic.optiq.SchemaPlus;
import net.hydromatic.optiq.Statistic;
import net.hydromatic.optiq.Statistics;
import net.hydromatic.optiq.impl.clone.ArrayTable$1;
import net.hydromatic.optiq.impl.clone.ArrayTable$2;
import net.hydromatic.optiq.impl.clone.ArrayTable$Column$1;
import net.hydromatic.optiq.impl.clone.ColumnLoader$ValueSet;
import net.hydromatic.optiq.impl.java.AbstractQueryableTable;
import net.hydromatic.optiq.util.BitSets;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.reltype.RelDataTypeFactory;
import org.eigenbase.reltype.RelProtoDataType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ArrayTable
extends AbstractQueryableTable {
    private final RelProtoDataType protoRowType;
    private final Supplier<Content> supplier;

    public ArrayTable(Type elementType, RelProtoDataType protoRowType, Supplier<Content> supplier) {
        super(elementType);
        this.protoRowType = protoRowType;
        this.supplier = supplier;
    }

    @Override
    public RelDataType getRowType(RelDataTypeFactory typeFactory) {
        return (RelDataType)this.protoRowType.apply(typeFactory);
    }

    @Override
    public Statistic getStatistic() {
        ArrayList<BitSet> keys = new ArrayList<BitSet>();
        Content content = this.supplier.get();
        for (Ord ord : Ord.zip(content.columns)) {
            if (((Column)ord.e).cardinality != content.size) continue;
            keys.add(BitSets.of(ord.i));
        }
        return Statistics.of(content.size, keys);
    }

    @Override
    public <T> Queryable<T> asQueryable(QueryProvider queryProvider, SchemaPlus schema, String tableName) {
        return new ArrayTable$1(this, queryProvider, schema, this, tableName);
    }

    private static <E> List<E> permuteList(List<E> list, int[] sources) {
        if (sources == null) {
            return list;
        }
        return new ArrayTable$2(list, sources);
    }

    static /* synthetic */ Supplier access$200(ArrayTable x0) {
        return x0.supplier;
    }

    static /* synthetic */ List access$300(List x0, int[] x1) {
        return ArrayTable.permuteList(x0, x1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Content {
        private final List<Column> columns;
        private final int size;
        private final int sortField;

        public Content(List<? extends Column> columns, int size, int sortField) {
            this.columns = ImmutableList.copyOf(columns);
            this.size = size;
            this.sortField = sortField;
        }
    }

    public static interface Representation {
        public Object freeze(ColumnLoader$ValueSet var1, int[] var2);

        public Object getObject(Object var1, int var2);

        public int getInt(Object var1, int var2);

        public Object permute(Object var1, int[] var2);

        public int size(Object var1);

        public String toString(Object var1);
    }

    public static class Column {
        final Representation representation;
        final Object dataSet;
        final int cardinality;

        Column(Representation representation, Object data, int cardinality) {
            this.representation = representation;
            this.dataSet = data;
            this.cardinality = cardinality;
        }

        public Column permute(int[] sources) {
            return new Column(this.representation, this.representation.permute(this.dataSet, sources), this.cardinality);
        }

        public String toString() {
            return "Column(representation=" + this.representation + ", value=" + this.representation.toString(this.dataSet) + ")";
        }

        public static List asList(Representation representation, Object dataSet) {
            int size = representation.size(dataSet);
            return new ArrayTable$Column$1(representation, dataSet, size);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum RepresentationType {
        CONSTANT,
        OBJECT_ARRAY,
        PRIMITIVE_ARRAY,
        BIT_SLICED_PRIMITIVE_ARRAY,
        PRIMITIVE_DICTIONARY,
        OBJECT_DICTIONARY,
        STRING_DICTIONARY,
        BYTE_STRING_DICTIONARY;

    }
}

