/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.linq4j.expressions;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.hydromatic.linq4j.expressions.BinaryExpression;
import net.hydromatic.linq4j.expressions.BlockStatement;
import net.hydromatic.linq4j.expressions.Blocks;
import net.hydromatic.linq4j.expressions.CatchBlock;
import net.hydromatic.linq4j.expressions.ClassDeclaration;
import net.hydromatic.linq4j.expressions.ConditionalStatement;
import net.hydromatic.linq4j.expressions.ConstantExpression;
import net.hydromatic.linq4j.expressions.ConstantUntypedNull;
import net.hydromatic.linq4j.expressions.ConstructorDeclaration;
import net.hydromatic.linq4j.expressions.DeclarationStatement;
import net.hydromatic.linq4j.expressions.Expression;
import net.hydromatic.linq4j.expressions.ExpressionType;
import net.hydromatic.linq4j.expressions.ExpressionWriter;
import net.hydromatic.linq4j.expressions.FieldDeclaration;
import net.hydromatic.linq4j.expressions.ForStatement;
import net.hydromatic.linq4j.expressions.FunctionExpression;
import net.hydromatic.linq4j.expressions.GotoExpressionKind;
import net.hydromatic.linq4j.expressions.GotoStatement;
import net.hydromatic.linq4j.expressions.IndexExpression;
import net.hydromatic.linq4j.expressions.LabelTarget;
import net.hydromatic.linq4j.expressions.MemberDeclaration;
import net.hydromatic.linq4j.expressions.MemberExpression;
import net.hydromatic.linq4j.expressions.MethodCallExpression;
import net.hydromatic.linq4j.expressions.MethodDeclaration;
import net.hydromatic.linq4j.expressions.NewArrayExpression;
import net.hydromatic.linq4j.expressions.NewExpression;
import net.hydromatic.linq4j.expressions.Node;
import net.hydromatic.linq4j.expressions.ParameterExpression;
import net.hydromatic.linq4j.expressions.Primitive;
import net.hydromatic.linq4j.expressions.PseudoField;
import net.hydromatic.linq4j.expressions.Statement;
import net.hydromatic.linq4j.expressions.TernaryExpression;
import net.hydromatic.linq4j.expressions.ThrowStatement;
import net.hydromatic.linq4j.expressions.TryStatement;
import net.hydromatic.linq4j.expressions.TypeBinaryExpression;
import net.hydromatic.linq4j.expressions.Types;
import net.hydromatic.linq4j.expressions.UnaryExpression;
import net.hydromatic.linq4j.expressions.Visitor;
import net.hydromatic.linq4j.expressions.WhileStatement;
import net.hydromatic.linq4j.function.Function;
import net.hydromatic.linq4j.function.Function0;
import net.hydromatic.linq4j.function.Function1;
import net.hydromatic.linq4j.function.Function2;
import net.hydromatic.linq4j.function.Predicate1;
import net.hydromatic.linq4j.function.Predicate2;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Expressions {
    private Expressions() {
    }

    public static String toString(List<? extends Node> expressions, String sep, boolean generics) {
        ExpressionWriter writer = new ExpressionWriter(generics);
        for (Node node : expressions) {
            writer.write(node);
            writer.append(sep);
        }
        return writer.toString();
    }

    public static String toString(Node expression) {
        return Expressions.toString(Collections.singletonList(expression), "", true);
    }

    public static BinaryExpression add(Expression left, Expression right) {
        return Expressions.makeBinary(ExpressionType.Add, left, right);
    }

    public static BinaryExpression andAlso(Expression left, Expression right) {
        return Expressions.makeBinary(ExpressionType.AndAlso, left, right);
    }

    public static IndexExpression arrayIndex(Expression array, Expression indexExpression) {
        return new IndexExpression(array, Collections.singletonList(indexExpression));
    }

    public static BinaryExpression assign(Expression left, Expression right) {
        return Expressions.makeBinary(ExpressionType.Assign, left, right);
    }

    public static BlockStatement block(Iterable<? extends Statement> statements) {
        return Expressions.block((Type)null, statements);
    }

    public static BlockStatement block(Statement ... statements) {
        return Expressions.block(Expressions.toList(statements));
    }

    public static BlockStatement block(Type type, Iterable<? extends Statement> expressions) {
        List<Statement> list = Expressions.toList(expressions);
        if (type == null) {
            type = list.size() > 0 ? list.get(list.size() - 1).getType() : Void.TYPE;
        }
        return new BlockStatement(list, type);
    }

    public static MethodCallExpression call(Method method, Iterable<? extends Expression> arguments) {
        return new MethodCallExpression(method, null, Expressions.toList(arguments));
    }

    public static MethodCallExpression call(Method method, Expression ... arguments) {
        return new MethodCallExpression(method, null, Expressions.toList(arguments));
    }

    public static MethodCallExpression call(Expression expression, Method method, Iterable<? extends Expression> arguments) {
        return new MethodCallExpression(method, expression, Expressions.toList(arguments));
    }

    public static MethodCallExpression call(Expression expression, Method method, Expression ... arguments) {
        return new MethodCallExpression(method, expression, Expressions.toList(arguments));
    }

    public static MethodCallExpression call(Type returnType, Expression expression, Method method, Iterable<? extends Expression> arguments) {
        return new MethodCallExpression(returnType, method, expression, Expressions.toList(arguments));
    }

    public static MethodCallExpression call(Type returnType, Expression expression, Method method, Expression ... arguments) {
        return new MethodCallExpression(returnType, method, expression, Expressions.toList(arguments));
    }

    public static MethodCallExpression call(Expression target, String methodName, Iterable<? extends Expression> arguments) {
        Method method;
        try {
            method = Types.toClass(target.getType()).getMethod(methodName, Types.toClassArray(arguments));
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("while resolving method '" + methodName + "' in class " + target.getType(), e);
        }
        return Expressions.call(target, method, arguments);
    }

    public static MethodCallExpression call(Expression target, String methodName, Expression ... arguments) {
        return Expressions.call(target, methodName, Expressions.toList(arguments));
    }

    public static MethodCallExpression call(Type type, String methodName, Iterable<? extends Expression> arguments) {
        Method method = Types.lookupMethod(Types.toClass(type), methodName, Types.toClassArray(arguments));
        return new MethodCallExpression(method, null, Expressions.toList(arguments));
    }

    public static MethodCallExpression call(Type type, String methodName, Expression ... arguments) {
        return Expressions.call(type, methodName, Expressions.toList(arguments));
    }

    public static CatchBlock catch_(ParameterExpression parameter, Statement statement) {
        return new CatchBlock(parameter, statement);
    }

    public static Expression condition(Expression test, Expression ifTrue, Expression ifFalse) {
        return Expressions.makeTernary(ExpressionType.Conditional, test, ifTrue, ifFalse);
    }

    private static Type box(Type type) {
        Primitive primitive = Primitive.of(type);
        if (primitive != null) {
            return primitive.boxClass;
        }
        return type;
    }

    public static boolean isConstantNull(Expression e) {
        return e instanceof ConstantExpression && ((ConstantExpression)e).value == null;
    }

    public static ConstantExpression constant(Object value) {
        if (value == null) {
            return ConstantUntypedNull.INSTANCE;
        }
        Class clazz = value.getClass();
        Primitive primitive = Primitive.ofBox(clazz);
        Class type = primitive != null ? primitive.primitiveClass : clazz;
        return new ConstantExpression(type, value);
    }

    public static ConstantExpression constant(Object value, Type type) {
        if (value != null && type instanceof Class) {
            Class clazz = (Class)type;
            Primitive primitive = Primitive.ofBoxOr(clazz);
            if (primitive != null) {
                clazz = primitive.boxClass;
            }
            if (!clazz.isInstance(value)) {
                String stringValue = String.valueOf(value);
                if (type == BigDecimal.class) {
                    value = new BigDecimal(stringValue);
                }
                if (type == BigInteger.class) {
                    value = new BigInteger(stringValue);
                }
                if (primitive != null) {
                    value = primitive.parse(stringValue);
                }
            }
        }
        return new ConstantExpression(type, value);
    }

    public static UnaryExpression convert_(Expression expression, Type type) {
        return new UnaryExpression(ExpressionType.Convert, type, expression);
    }

    public static BinaryExpression divide(Expression left, Expression right) {
        return Expressions.makeBinary(ExpressionType.Divide, left, right);
    }

    public static BinaryExpression equal(Expression left, Expression right) {
        return Expressions.makeBinary(ExpressionType.Equal, left, right);
    }

    public static MemberExpression field(Expression expression, Field field) {
        return Expressions.makeMemberAccess(expression, Types.field(field));
    }

    public static MemberExpression field(Expression expression, PseudoField field) {
        return Expressions.makeMemberAccess(expression, field);
    }

    public static MemberExpression field(Expression expression, String fieldName) {
        PseudoField field = Types.getField(fieldName, expression.getType());
        return Expressions.makeMemberAccess(expression, field);
    }

    public static MemberExpression field(Expression expression, Type type, String fieldName) {
        PseudoField field = Types.getField(fieldName, type);
        return Expressions.makeMemberAccess(expression, field);
    }

    public static BinaryExpression greaterThan(Expression left, Expression right) {
        return Expressions.makeBinary(ExpressionType.GreaterThan, left, right);
    }

    public static BinaryExpression greaterThanOrEqual(Expression left, Expression right) {
        return Expressions.makeBinary(ExpressionType.GreaterThanOrEqual, left, right);
    }

    public static ConditionalStatement ifThen(Expression test, Node ifTrue) {
        return new ConditionalStatement(Arrays.asList(test, ifTrue));
    }

    public static ConditionalStatement ifThenElse(Expression test, Node ifTrue, Node ifFalse) {
        return new ConditionalStatement(Arrays.asList(test, ifTrue, ifFalse));
    }

    public static ConditionalStatement ifThenElse(Iterable<? extends Node> nodes) {
        List<Node> list = Expressions.toList(nodes);
        assert (list.size() >= 2) : "At least one test and one statement is required";
        return new ConditionalStatement(list);
    }

    public static <F extends Function<?>> FunctionExpression<F> lambda(BlockStatement body, Iterable<? extends ParameterExpression> parameters) {
        List<ParameterExpression> parameterList = Expressions.toList(parameters);
        Class type = Expressions.deduceType(parameterList, body.getType());
        return new FunctionExpression(type, body, parameterList);
    }

    public static <F extends Function<?>> FunctionExpression<F> lambda(BlockStatement body, ParameterExpression ... parameters) {
        return Expressions.lambda(body, Expressions.toList(parameters));
    }

    public static <F extends Function<?>> FunctionExpression<F> lambda(Expression body, ParameterExpression ... parameters) {
        return Expressions.lambda(Blocks.toFunctionBlock(body), Expressions.toList(parameters));
    }

    public static <T, F extends Function<? extends T>> FunctionExpression<F> lambda(Class<F> type, BlockStatement body, Iterable<? extends ParameterExpression> parameters) {
        return new FunctionExpression<F>(type, body, Expressions.toList(parameters));
    }

    public static <T, F extends Function<? extends T>> FunctionExpression<F> lambda(Class<F> type, BlockStatement body, ParameterExpression ... parameters) {
        return Expressions.lambda(type, body, Expressions.toList(parameters));
    }

    public static <T, F extends Function<? extends T>> FunctionExpression<F> lambda(Class<F> type, Expression body, Iterable<? extends ParameterExpression> parameters) {
        return Expressions.lambda(type, Blocks.toFunctionBlock(body), Expressions.toList(parameters));
    }

    public static <T, F extends Function<? extends T>> FunctionExpression<F> lambda(Class<F> type, Expression body, ParameterExpression ... parameters) {
        return Expressions.lambda(type, Blocks.toFunctionBlock(body), Expressions.toList(parameters));
    }

    public static BinaryExpression lessThan(Expression left, Expression right) {
        return Expressions.makeBinary(ExpressionType.LessThan, left, right);
    }

    public static BinaryExpression lessThanOrEqual(Expression left, Expression right) {
        return Expressions.makeBinary(ExpressionType.LessThanOrEqual, left, right);
    }

    public static ForStatement for_(Iterable<? extends DeclarationStatement> declarations, Expression condition, Expression post, Statement body) {
        return new ForStatement(Expressions.toList(declarations), condition, post, body);
    }

    public static ForStatement for_(DeclarationStatement declaration, Expression condition, Expression post, Statement body) {
        return new ForStatement(Collections.singletonList(declaration), condition, post, body);
    }

    public static BinaryExpression makeBinary(ExpressionType binaryType, Expression left, Expression right) {
        Type type;
        switch (binaryType) {
            case Equal: 
            case NotEqual: 
            case LessThan: 
            case LessThanOrEqual: 
            case GreaterThan: 
            case GreaterThanOrEqual: 
            case AndAlso: 
            case OrElse: {
                type = Boolean.TYPE;
                break;
            }
            default: {
                type = Expressions.larger(left.type, right.type);
            }
        }
        return new BinaryExpression(binaryType, type, left, right);
    }

    public static Expression box(Expression expression, Primitive primitive) {
        return Expressions.call((Type)primitive.boxClass, "valueOf", expression);
    }

    public static Expression box(Expression expression) {
        Primitive primitive = Primitive.of(expression.getType());
        if (primitive == null) {
            return expression;
        }
        return Expressions.box(expression, primitive);
    }

    public static Expression unbox(Expression expression, Primitive primitive) {
        return Expressions.call(expression, primitive.primitiveName + "Value", new Expression[0]);
    }

    public static Expression unbox(Expression expression) {
        Primitive primitive = Primitive.ofBox(expression.getType());
        if (primitive == null) {
            return expression;
        }
        return Expressions.unbox(expression, primitive);
    }

    private static Type larger(Type type0, Type type1) {
        if (type0 == Double.TYPE || type0 == Double.class || type1 == Double.TYPE || type1 == Double.class) {
            return Double.TYPE;
        }
        if (type0 == Float.TYPE || type0 == Float.class || type1 == Float.TYPE || type1 == Float.class) {
            return Float.TYPE;
        }
        if (type0 == Long.TYPE || type0 == Long.class || type1 == Long.TYPE || type1 == Long.class) {
            return Long.TYPE;
        }
        return Integer.TYPE;
    }

    public static TernaryExpression makeTernary(ExpressionType ternaryType, Expression e0, Expression e1, Expression e2) {
        Type type;
        switch (ternaryType) {
            case Conditional: {
                if (e1 instanceof ConstantUntypedNull) {
                    type = Expressions.box(e2.getType());
                    if (e1.getType() == type) break;
                    e1 = Expressions.constant(null, type);
                    break;
                }
                if (e2 instanceof ConstantUntypedNull) {
                    type = Expressions.box(e1.getType());
                    if (e2.getType() == type) break;
                    e2 = Expressions.constant(null, type);
                    break;
                }
                type = Types.gcd(e1.getType(), e2.getType());
                break;
            }
            default: {
                type = e1.getType();
            }
        }
        return new TernaryExpression(ternaryType, type, e0, e1, e2);
    }

    public static MemberExpression makeMemberAccess(Expression expression, PseudoField member) {
        return new MemberExpression(expression, member);
    }

    public static UnaryExpression makeUnary(ExpressionType expressionType, Expression expression) {
        return new UnaryExpression(expressionType, expression.getType(), expression);
    }

    public static UnaryExpression makeUnary(ExpressionType expressionType, Expression expression, Type type, Method method) {
        assert (type != null);
        return new UnaryExpression(expressionType, type, expression);
    }

    public static MethodDeclaration methodDecl(int modifier, Type resultType, String name, Iterable<? extends ParameterExpression> parameters, BlockStatement body) {
        return new MethodDeclaration(modifier, name, resultType, Expressions.toList(parameters), body);
    }

    public static ConstructorDeclaration constructorDecl(int modifier, Type declaredAgainst, Iterable<? extends ParameterExpression> parameters, BlockStatement body) {
        return new ConstructorDeclaration(modifier, declaredAgainst, Expressions.toList(parameters), body);
    }

    public static FieldDeclaration fieldDecl(int modifier, ParameterExpression parameter, Expression initializer) {
        return new FieldDeclaration(modifier, parameter, initializer);
    }

    public static ClassDeclaration classDecl(int modifier, String name, Type extended, List<Type> implemented, List<MemberDeclaration> memberDeclarations) {
        return new ClassDeclaration(modifier, name, extended, implemented, memberDeclarations);
    }

    public static BinaryExpression multiply(Expression left, Expression right) {
        return Expressions.makeBinary(ExpressionType.Multiply, left, right);
    }

    public static UnaryExpression negate(Expression expression) {
        return Expressions.makeUnary(ExpressionType.Negate, expression);
    }

    public static NewExpression new_(Type type) {
        return Expressions.new_(type, Collections.emptyList());
    }

    public static NewExpression new_(Type type, Iterable<? extends Expression> arguments) {
        return new NewExpression(type, Expressions.toList(arguments), null);
    }

    public static NewExpression new_(Type type, Expression ... arguments) {
        return new NewExpression(type, Expressions.toList(arguments), null);
    }

    public static NewExpression new_(Type type, Iterable<? extends Expression> arguments, Iterable<? extends MemberDeclaration> memberDeclarations) {
        return new NewExpression(type, Expressions.toList(arguments), Expressions.toList(memberDeclarations));
    }

    public static NewExpression new_(Constructor constructor, Iterable<? extends Expression> expressions, Iterable<? extends MemberDeclaration> memberDeclarations) {
        return Expressions.new_(constructor.getDeclaringClass(), Expressions.toList(expressions), Expressions.toList(memberDeclarations));
    }

    public static NewArrayExpression newArrayBounds(Type type, int dimension, Expression bound) {
        return new NewArrayExpression(type, dimension, bound, null);
    }

    public static NewArrayExpression newArrayInit(Type type, Iterable<? extends Expression> expressions) {
        return new NewArrayExpression(type, 1, null, Expressions.toList(expressions));
    }

    public static NewArrayExpression newArrayInit(Type type, int dimension, Iterable<? extends Expression> expressions) {
        return new NewArrayExpression(type, dimension, null, Expressions.toList(expressions));
    }

    public static UnaryExpression not(Expression expression) {
        return Expressions.makeUnary(ExpressionType.Not, expression);
    }

    public static BinaryExpression notEqual(Expression left, Expression right) {
        return Expressions.makeBinary(ExpressionType.NotEqual, left, right);
    }

    public static BinaryExpression orElse(Expression left, Expression right) {
        return Expressions.makeBinary(ExpressionType.OrElse, left, right);
    }

    public static ParameterExpression parameter(Type type, String name) {
        return new ParameterExpression(0, type, name);
    }

    public static ParameterExpression parameter(int modifiers, Type type, String name) {
        return new ParameterExpression(modifiers, type, name);
    }

    public static UnaryExpression postIncrementAssign(Expression expression) {
        return Expressions.makeUnary(ExpressionType.PostIncrementAssign, expression);
    }

    public static UnaryExpression preIncrementAssign(Expression expression) {
        return Expressions.makeUnary(ExpressionType.PreIncrementAssign, expression);
    }

    public static GotoStatement return_(LabelTarget labelTarget, Expression expression) {
        return Expressions.makeGoto(GotoExpressionKind.Return, labelTarget, expression);
    }

    public static GotoStatement makeGoto(GotoExpressionKind kind, LabelTarget labelTarget, Expression expression) {
        return new GotoStatement(kind, labelTarget, expression);
    }

    public static BinaryExpression subtract(Expression left, Expression right) {
        return Expressions.makeBinary(ExpressionType.Subtract, left, right);
    }

    public static ThrowStatement throw_(Expression expression) {
        return new ThrowStatement(expression);
    }

    public static TryStatement tryCatch(Statement body, CatchBlock ... handlers) {
        return new TryStatement(body, Expressions.toList(handlers), null);
    }

    public static TypeBinaryExpression typeIs(Expression expression, Type type) {
        return new TypeBinaryExpression(ExpressionType.TypeIs, expression, type);
    }

    public static WhileStatement while_(Expression condition, Statement body) {
        return new WhileStatement(condition, body);
    }

    public static DeclarationStatement declare(int modifiers, ParameterExpression parameter, Expression initializer) {
        return new DeclarationStatement(modifiers, parameter, initializer);
    }

    public static DeclarationStatement declare(int modifiers, String name, Expression initializer) {
        return Expressions.declare(modifiers, Expressions.parameter(initializer.getType(), name), initializer);
    }

    public static Statement statement(Expression expression) {
        return new GotoStatement(GotoExpressionKind.Sequence, null, expression);
    }

    public static Expression foldAnd(List<Expression> conditions) {
        Expression e = null;
        int nullCount = 0;
        for (Expression condition : conditions) {
            if (condition instanceof ConstantExpression) {
                Boolean value = (Boolean)((ConstantExpression)condition).value;
                if (value == null) {
                    ++nullCount;
                    continue;
                }
                if (value.booleanValue()) continue;
                return Expressions.constant(false);
            }
            if (e == null) {
                e = condition;
                continue;
            }
            e = Expressions.andAlso(e, condition);
        }
        if (nullCount > 0) {
            return Expressions.constant(null);
        }
        if (e == null) {
            return Expressions.constant(true);
        }
        return e;
    }

    public static Expression foldOr(List<Expression> conditions) {
        Expression e = null;
        int nullCount = 0;
        for (Expression condition : conditions) {
            if (condition instanceof ConstantExpression) {
                Boolean value = (Boolean)((ConstantExpression)condition).value;
                if (value == null) {
                    ++nullCount;
                    continue;
                }
                if (!value.booleanValue()) continue;
                return Expressions.constant(true);
            }
            if (e == null) {
                e = condition;
                continue;
            }
            e = Expressions.orElse(e, condition);
        }
        if (e == null) {
            if (nullCount > 0) {
                return Expressions.constant(null);
            }
            return Expressions.constant(false);
        }
        return e;
    }

    public static <T> FluentList<T> list() {
        return new FluentArrayList();
    }

    public static <T> FluentList<T> list(T ... ts) {
        return new FluentArrayList<T>(Arrays.asList(ts));
    }

    public static <T> FluentList<T> list(Iterable<T> ts) {
        return new FluentArrayList<T>(Expressions.toList(ts));
    }

    private static Class deduceType(List<ParameterExpression> parameterList, Type type) {
        switch (parameterList.size()) {
            case 0: {
                return Function0.class;
            }
            case 1: {
                return type == Boolean.TYPE ? Predicate1.class : Function1.class;
            }
            case 2: {
                return type == Boolean.TYPE ? Predicate2.class : Function2.class;
            }
        }
        return Function.class;
    }

    private static <T> List<T> toList(Iterable<? extends T> iterable) {
        if (iterable == null) {
            return null;
        }
        if (iterable instanceof List) {
            return (List)iterable;
        }
        ArrayList<T> list = new ArrayList<T>();
        for (T parameter : iterable) {
            list.add(parameter);
        }
        return list;
    }

    private static <T> List<T> toList(T[] ts) {
        if (ts.length == 0) {
            return Collections.emptyList();
        }
        return Arrays.asList(ts);
    }

    private static <T> Collection<T> toCollection(Iterable<T> iterable) {
        if (iterable instanceof Collection) {
            return (Collection)iterable;
        }
        return Expressions.toList(iterable);
    }

    static <T extends Expression> Expression accept(T node, Visitor visitor) {
        if (node == null) {
            return null;
        }
        return node.accept(visitor);
    }

    static List<Statement> acceptStatements(List<Statement> statements, Visitor visitor) {
        if (statements.isEmpty()) {
            return statements;
        }
        ArrayList<Statement> statements1 = new ArrayList<Statement>();
        for (Statement statement : statements) {
            Statement newStatement = statement.accept(visitor);
            if (newStatement instanceof GotoStatement) {
                GotoStatement goto_ = (GotoStatement)newStatement;
                if (goto_.kind == GotoExpressionKind.Sequence && goto_.expression == null) continue;
            }
            statements1.add(newStatement);
        }
        return statements1;
    }

    static List<Node> acceptNodes(List<Node> nodes, Visitor visitor) {
        if (nodes.isEmpty()) {
            return nodes;
        }
        ArrayList<Node> statements1 = new ArrayList<Node>();
        for (Node node : nodes) {
            statements1.add(node.accept(visitor));
        }
        return statements1;
    }

    static List<DeclarationStatement> acceptDeclarations(List<DeclarationStatement> declarations, Visitor visitor) {
        if (declarations == null || declarations.isEmpty()) {
            return declarations;
        }
        ArrayList<DeclarationStatement> declarations1 = new ArrayList<DeclarationStatement>();
        for (DeclarationStatement declaration : declarations) {
            declarations1.add(declaration.accept(visitor));
        }
        return declarations1;
    }

    static List<MemberDeclaration> acceptMemberDeclarations(List<MemberDeclaration> memberDeclarations, Visitor visitor) {
        if (memberDeclarations == null || memberDeclarations.isEmpty()) {
            return memberDeclarations;
        }
        ArrayList<MemberDeclaration> memberDeclarations1 = new ArrayList<MemberDeclaration>();
        for (MemberDeclaration memberDeclaration : memberDeclarations) {
            memberDeclarations1.add(memberDeclaration.accept(visitor));
        }
        return memberDeclarations1;
    }

    static List<Expression> acceptExpressions(List<Expression> expressions, Visitor visitor) {
        if (expressions.isEmpty()) {
            return expressions;
        }
        ArrayList<Expression> expressions1 = new ArrayList<Expression>();
        for (Expression expression : expressions) {
            expressions1.add(expression.accept(visitor));
        }
        return expressions1;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FluentArrayList<T>
    extends ArrayList<T>
    implements FluentList<T> {
        public FluentArrayList() {
        }

        public FluentArrayList(Collection<? extends T> c) {
            super(c);
        }

        @Override
        public FluentList<T> append(T t) {
            this.add(t);
            return this;
        }

        @Override
        public FluentList<T> appendIf(boolean condition, T t) {
            if (condition) {
                this.add(t);
            }
            return this;
        }

        @Override
        public FluentList<T> appendIfNotNull(T t) {
            if (t != null) {
                this.add(t);
            }
            return this;
        }

        @Override
        public FluentList<T> appendAll(Iterable<T> ts) {
            this.addAll(Expressions.toCollection(ts));
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface FluentList<T>
    extends List<T> {
        public FluentList<T> append(T var1);

        public FluentList<T> appendIf(boolean var1, T var2);

        public FluentList<T> appendIfNotNull(T var1);

        public FluentList<T> appendAll(Iterable<T> var1);
    }
}

