/*
 * Decompiled with CFR 0.152.
 */
package javassist.bytecode;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.Map;
import javassist.bytecode.AttributeInfo;
import javassist.bytecode.ByteArray;
import javassist.bytecode.ConstPool;

public class LineNumberAttribute
extends AttributeInfo {
    LineNumberAttribute(ConstPool cp, int n, DataInputStream in) throws IOException {
        super(cp, n, in);
    }

    private LineNumberAttribute(ConstPool cp, byte[] i) {
        super(cp, "LineNumberTable", i);
    }

    public int tableLength() {
        return ByteArray.readU16bit(this.info, 0);
    }

    public AttributeInfo copy(ConstPool newCp, Map classnames) {
        byte[] src = this.info;
        int num = src.length;
        byte[] dest = new byte[num];
        for (int i = 0; i < num; ++i) {
            dest[i] = src[i];
        }
        LineNumberAttribute attr = new LineNumberAttribute(newCp, dest);
        return attr;
    }

    void shiftPc(int where, int gapLength, boolean exclusive) {
        int n = this.tableLength();
        for (int i = 0; i < n; ++i) {
            int pos = i * 4 + 2;
            int pc = ByteArray.readU16bit(this.info, pos);
            if (pc <= where && (!exclusive || pc != where)) continue;
            ByteArray.write16bit(pc + gapLength, this.info, pos);
        }
    }
}

