/*
 * Decompiled with CFR 0.152.
 */
package javassist;

import javassist.CannotCompileException;
import javassist.CtClass;
import javassist.CtMember;
import javassist.NotFoundException;
import javassist.bytecode.AccessFlag;
import javassist.bytecode.Bytecode;
import javassist.bytecode.ConstPool;
import javassist.bytecode.Descriptor;
import javassist.bytecode.FieldInfo;
import javassist.compiler.Javac;

public class CtField
extends CtMember {
    protected FieldInfo fieldInfo;

    CtField(FieldInfo fi, CtClass clazz) {
        super(clazz);
        this.fieldInfo = fi;
    }

    public String toString() {
        return this.getDeclaringClass().getName() + "." + this.getName() + ":" + this.fieldInfo.getDescriptor();
    }

    protected void extendToString(StringBuffer buffer) {
        buffer.append(' ');
        buffer.append(this.getName());
        buffer.append(' ');
        buffer.append(this.fieldInfo.getDescriptor());
    }

    public FieldInfo getFieldInfo2() {
        return this.fieldInfo;
    }

    public CtClass getDeclaringClass() {
        return super.getDeclaringClass();
    }

    public String getName() {
        return this.fieldInfo.getName();
    }

    public int getModifiers() {
        return AccessFlag.toModifier(this.fieldInfo.getAccessFlags());
    }

    public String getSignature() {
        return this.fieldInfo.getDescriptor();
    }

    public CtClass getType() throws NotFoundException {
        return Descriptor.toCtClass(this.fieldInfo.getDescriptor(), this.declaringClass.getClassPool());
    }

    public Object getConstantValue() {
        int index = this.fieldInfo.getConstantValue();
        if (index == 0) {
            return null;
        }
        ConstPool cp = this.fieldInfo.getConstPool();
        switch (cp.getTag(index)) {
            case 5: {
                return new Long(cp.getLongInfo(index));
            }
            case 4: {
                return new Float(cp.getFloatInfo(index));
            }
            case 6: {
                return new Double(cp.getDoubleInfo(index));
            }
            case 3: {
                int value = cp.getIntegerInfo(index);
                if ("Z".equals(this.fieldInfo.getDescriptor())) {
                    return new Boolean(value != 0);
                }
                return new Integer(value);
            }
            case 8: {
                return cp.getStringInfo(index);
            }
        }
        throw new RuntimeException("bad tag: " + cp.getTag(index) + " at " + index);
    }

    public static abstract class Initializer {
        abstract int compile(CtClass var1, String var2, Bytecode var3, CtClass[] var4, Javac var5) throws CannotCompileException;

        abstract int compileIfStatic(CtClass var1, String var2, Bytecode var3, Javac var4) throws CannotCompileException;
    }
}

