/*
 * Decompiled with CFR 0.152.
 */
package javassist;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtField;
import javassist.CtMethod;
import javassist.CtPrimitiveType;
import javassist.NotFoundException;
import javassist.bytecode.ClassFile;
import javassist.compiler.AccessorMaker;

public abstract class CtClass {
    protected String qualifiedName;
    public static String debugDump = null;
    public static CtClass booleanType;
    public static CtClass charType;
    public static CtClass byteType;
    public static CtClass shortType;
    public static CtClass intType;
    public static CtClass longType;
    public static CtClass floatType;
    public static CtClass doubleType;
    public static CtClass voidType;
    static CtClass[] primitiveTypes;

    protected CtClass(String name) {
        this.qualifiedName = name;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(this.getClass().getName());
        buf.append("@");
        buf.append(Integer.toHexString(this.hashCode()));
        buf.append("[");
        this.extendToString(buf);
        buf.append("]");
        return buf.toString();
    }

    protected void extendToString(StringBuffer buffer) {
        buffer.append(this.getName());
    }

    public ClassPool getClassPool() {
        return null;
    }

    public ClassFile getClassFile() {
        this.checkModify();
        return this.getClassFile2();
    }

    public ClassFile getClassFile2() {
        return null;
    }

    public AccessorMaker getAccessorMaker() {
        return null;
    }

    public boolean isModified() {
        return false;
    }

    public boolean isFrozen() {
        return true;
    }

    void checkModify() throws RuntimeException {
        if (this.isFrozen()) {
            throw new RuntimeException(this.getName() + " class is frozen");
        }
    }

    public boolean isPrimitive() {
        return false;
    }

    public boolean isArray() {
        return false;
    }

    public CtClass getComponentType() throws NotFoundException {
        return null;
    }

    public boolean subtypeOf(CtClass clazz) throws NotFoundException {
        return this == clazz || this.getName().equals(clazz.getName());
    }

    public String getName() {
        return this.qualifiedName;
    }

    public final String getSimpleName() {
        String qname = this.qualifiedName;
        int index = qname.lastIndexOf(46);
        if (index < 0) {
            return qname;
        }
        return qname.substring(index + 1);
    }

    public void setName(String name) {
        this.checkModify();
        if (name != null) {
            this.qualifiedName = name;
        }
    }

    public boolean isInterface() {
        return false;
    }

    public int getModifiers() {
        return 0;
    }

    public void setModifiers(int mod) {
        this.checkModify();
    }

    public CtClass getSuperclass() throws NotFoundException {
        return null;
    }

    public CtClass[] getInterfaces() throws NotFoundException {
        return new CtClass[0];
    }

    public CtClass getDeclaringClass() throws NotFoundException {
        return null;
    }

    public CtField getField(String name) throws NotFoundException {
        return this.getField(name, null);
    }

    public CtField getField(String name, String desc) throws NotFoundException {
        throw new NotFoundException(name);
    }

    CtField getField2(String name, String desc) {
        return null;
    }

    public CtMethod getDeclaredMethod(String name) throws NotFoundException {
        throw new NotFoundException(name);
    }

    public void detach() {
        ClassPool cp = this.getClassPool();
        CtClass obj = cp.removeCached(this.getName());
        if (obj != this) {
            cp.cacheCtClass(this.getName(), obj, false);
        }
    }

    void incGetCounter() {
    }

    public void rebuildClassFile() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] toBytecode() throws IOException, CannotCompileException {
        ByteArrayOutputStream barray = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(barray);
        try {
            this.toBytecode(out);
        }
        finally {
            out.close();
        }
        return barray.toByteArray();
    }

    protected DataOutputStream makeFileOutput(String directoryName) {
        String dir;
        String classname = this.getName();
        String filename = directoryName + File.separatorChar + classname.replace('.', File.separatorChar) + ".class";
        int pos = filename.lastIndexOf(File.separatorChar);
        if (pos > 0 && !(dir = filename.substring(0, pos)).equals(".")) {
            new File(dir).mkdirs();
        }
        return new DataOutputStream(new BufferedOutputStream(new DelayedFileOutputStream(filename)));
    }

    public void toBytecode(DataOutputStream out) throws CannotCompileException, IOException {
        throw new CannotCompileException("not a class");
    }

    void compress() {
    }

    static {
        primitiveTypes = new CtClass[9];
        CtClass.primitiveTypes[0] = booleanType = new CtPrimitiveType("boolean", 'Z', "java.lang.Boolean", "booleanValue", "()Z", 172, 4, 1);
        CtClass.primitiveTypes[1] = charType = new CtPrimitiveType("char", 'C', "java.lang.Character", "charValue", "()C", 172, 5, 1);
        CtClass.primitiveTypes[2] = byteType = new CtPrimitiveType("byte", 'B', "java.lang.Byte", "byteValue", "()B", 172, 8, 1);
        CtClass.primitiveTypes[3] = shortType = new CtPrimitiveType("short", 'S', "java.lang.Short", "shortValue", "()S", 172, 9, 1);
        CtClass.primitiveTypes[4] = intType = new CtPrimitiveType("int", 'I', "java.lang.Integer", "intValue", "()I", 172, 10, 1);
        CtClass.primitiveTypes[5] = longType = new CtPrimitiveType("long", 'J', "java.lang.Long", "longValue", "()J", 173, 11, 2);
        CtClass.primitiveTypes[6] = floatType = new CtPrimitiveType("float", 'F', "java.lang.Float", "floatValue", "()F", 174, 6, 1);
        CtClass.primitiveTypes[7] = doubleType = new CtPrimitiveType("double", 'D', "java.lang.Double", "doubleValue", "()D", 175, 7, 2);
        CtClass.primitiveTypes[8] = voidType = new CtPrimitiveType("void", 'V', "java.lang.Void", null, null, 177, 0, 0);
    }

    static class DelayedFileOutputStream
    extends OutputStream {
        private FileOutputStream file = null;
        private String filename;

        DelayedFileOutputStream(String name) {
            this.filename = name;
        }

        private void init() throws IOException {
            if (this.file == null) {
                this.file = new FileOutputStream(this.filename);
            }
        }

        public void write(int b) throws IOException {
            this.init();
            this.file.write(b);
        }

        public void write(byte[] b) throws IOException {
            this.init();
            this.file.write(b);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.init();
            this.file.write(b, off, len);
        }

        public void flush() throws IOException {
            this.init();
            this.file.flush();
        }

        public void close() throws IOException {
            this.init();
            this.file.close();
        }
    }
}

