/*
 * Decompiled with CFR 0.152.
 */
package javassist;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import javassist.CannotCompileException;
import javassist.ClassClassPath;
import javassist.ClassPath;
import javassist.ClassPathList;
import javassist.NotFoundException;

final class ClassPoolTail {
    protected ClassPathList pathList = null;

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("[class path: ");
        ClassPathList list = this.pathList;
        while (list != null) {
            buf.append(list.path.toString());
            buf.append(File.pathSeparatorChar);
            list = list.next;
        }
        buf.append(']');
        return buf.toString();
    }

    public synchronized ClassPath appendClassPath(ClassPath cp) {
        ClassPathList tail = new ClassPathList(cp, null);
        ClassPathList list = this.pathList;
        if (list == null) {
            this.pathList = tail;
        } else {
            while (list.next != null) {
                list = list.next;
            }
            list.next = tail;
        }
        return cp;
    }

    public ClassPath appendSystemPath() {
        return this.appendClassPath(new ClassClassPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeClassfile(String classname, OutputStream out) throws NotFoundException, IOException, CannotCompileException {
        InputStream fin = this.openClassfile(classname);
        if (fin == null) {
            throw new NotFoundException(classname);
        }
        try {
            ClassPoolTail.copyStream(fin, out);
        }
        finally {
            fin.close();
        }
    }

    InputStream openClassfile(String classname) throws NotFoundException {
        ClassPathList list = this.pathList;
        InputStream ins = null;
        NotFoundException error = null;
        while (list != null) {
            block5: {
                try {
                    ins = list.path.openClassfile(classname);
                }
                catch (NotFoundException e) {
                    if (error != null) break block5;
                    error = e;
                }
            }
            if (ins == null) {
                list = list.next;
                continue;
            }
            return ins;
        }
        if (error != null) {
            throw error;
        }
        return null;
    }

    public URL find(String classname) {
        ClassPathList list = this.pathList;
        URL url = null;
        while (list != null) {
            url = list.path.find(classname);
            if (url == null) {
                list = list.next;
                continue;
            }
            return url;
        }
        return null;
    }

    public static void copyStream(InputStream fin, OutputStream fout) throws IOException {
        int bufsize = 4096;
        byte[] buf = null;
        for (int i = 0; i < 64; ++i) {
            if (i < 8) {
                buf = new byte[bufsize *= 2];
            }
            int size = 0;
            int len = 0;
            do {
                if ((len = fin.read(buf, size, bufsize - size)) >= 0) continue;
                fout.write(buf, 0, size);
                return;
            } while ((size += len) < bufsize);
            fout.write(buf);
        }
        throw new IOException("too much data");
    }
}

