/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.PoolArena;
import io.netty.buffer.PoolThreadCache;
import io.netty.buffer.PooledByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.buffer.PooledUnsafeDirectByteBuf;
import io.netty.buffer.UnsafeDirectLittleEndian;
import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PooledByteBufAllocatorL
extends PooledByteBufAllocator {
    static final Logger logger = LoggerFactory.getLogger(PooledByteBufAllocatorL.class);
    public static final PooledByteBufAllocatorL DEFAULT = new PooledByteBufAllocatorL();

    public PooledByteBufAllocatorL() {
        super(true);
    }

    @Override
    protected ByteBuf newHeapBuffer(int initialCapacity, int maxCapacity) {
        throw new UnsupportedOperationException("Drill doesn't support using heap buffers.");
    }

    @Override
    protected UnsafeDirectLittleEndian newDirectBuffer(int initialCapacity, int maxCapacity) {
        PoolThreadCache cache = (PoolThreadCache)this.threadCache.get();
        PoolArena<ByteBuffer> directArena = cache.directArena;
        if (directArena == null) {
            throw new UnsupportedOperationException("Drill requries that the allocator operates in DirectBuffer mode.");
        }
        PooledByteBuf<ByteBuffer> buf = directArena.allocate(cache, initialCapacity, maxCapacity);
        if (buf instanceof PooledUnsafeDirectByteBuf) {
            return new UnsafeDirectLittleEndian((PooledUnsafeDirectByteBuf)buf);
        }
        throw new UnsupportedOperationException("Drill requries that the JVM used supports access sun.misc.Unsafe.  This platform didn't provide that functionality.");
    }

    @Override
    public UnsafeDirectLittleEndian directBuffer(int initialCapacity, int maxCapacity) {
        if (initialCapacity == 0 && maxCapacity == 0) {
            this.newDirectBuffer(initialCapacity, maxCapacity);
        }
        PooledByteBufAllocatorL.validate(initialCapacity, maxCapacity);
        return this.newDirectBuffer(initialCapacity, maxCapacity);
    }

    @Override
    public ByteBuf heapBuffer(int initialCapacity, int maxCapacity) {
        throw new UnsupportedOperationException("Drill doesn't support using heap buffers.");
    }

    private static void validate(int initialCapacity, int maxCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("initialCapacity: " + initialCapacity + " (expectd: 0+)");
        }
        if (initialCapacity > maxCapacity) {
            throw new IllegalArgumentException(String.format("initialCapacity: %d (expected: not greater than maxCapacity(%d)", initialCapacity, maxCapacity));
        }
    }
}

