/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.WrappedByteBuf;
import io.netty.util.ResourceLeak;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;

final class AdvancedLeakAwareByteBuf
extends WrappedByteBuf {
    private final ResourceLeak leak;

    AdvancedLeakAwareByteBuf(ByteBuf buf, ResourceLeak leak) {
        super(buf);
        this.leak = leak;
    }

    @Override
    public boolean release() {
        boolean deallocated = super.release();
        if (deallocated) {
            this.leak.close();
        } else {
            this.leak.record();
        }
        return deallocated;
    }

    @Override
    public ByteBuf order(ByteOrder endianness) {
        this.leak.record();
        if (this.order() == endianness) {
            return this;
        }
        return new AdvancedLeakAwareByteBuf(super.order(endianness), this.leak);
    }

    @Override
    public ByteBuf slice() {
        this.leak.record();
        return new AdvancedLeakAwareByteBuf(super.slice(), this.leak);
    }

    @Override
    public ByteBuf slice(int index, int length) {
        this.leak.record();
        return new AdvancedLeakAwareByteBuf(super.slice(index, length), this.leak);
    }

    @Override
    public ByteBuf readSlice(int length) {
        this.leak.record();
        return new AdvancedLeakAwareByteBuf(super.readSlice(length), this.leak);
    }

    @Override
    public ByteBuf discardSomeReadBytes() {
        this.leak.record();
        return super.discardSomeReadBytes();
    }

    @Override
    public ByteBuf ensureWritable(int minWritableBytes) {
        this.leak.record();
        return super.ensureWritable(minWritableBytes);
    }

    @Override
    public byte getByte(int index) {
        this.leak.record();
        return super.getByte(index);
    }

    @Override
    public short getUnsignedByte(int index) {
        this.leak.record();
        return super.getUnsignedByte(index);
    }

    @Override
    public short getShort(int index) {
        this.leak.record();
        return super.getShort(index);
    }

    @Override
    public int getMedium(int index) {
        this.leak.record();
        return super.getMedium(index);
    }

    @Override
    public int getUnsignedMedium(int index) {
        this.leak.record();
        return super.getUnsignedMedium(index);
    }

    @Override
    public int getInt(int index) {
        this.leak.record();
        return super.getInt(index);
    }

    @Override
    public long getUnsignedInt(int index) {
        this.leak.record();
        return super.getUnsignedInt(index);
    }

    @Override
    public long getLong(int index) {
        this.leak.record();
        return super.getLong(index);
    }

    @Override
    public ByteBuf getBytes(int index, ByteBuf dst, int dstIndex, int length) {
        this.leak.record();
        return super.getBytes(index, dst, dstIndex, length);
    }

    @Override
    public ByteBuf getBytes(int index, byte[] dst) {
        this.leak.record();
        return super.getBytes(index, dst);
    }

    @Override
    public ByteBuf getBytes(int index, byte[] dst, int dstIndex, int length) {
        this.leak.record();
        return super.getBytes(index, dst, dstIndex, length);
    }

    @Override
    public int getBytes(int index, GatheringByteChannel out, int length) throws IOException {
        this.leak.record();
        return super.getBytes(index, out, length);
    }

    @Override
    public ByteBuf setByte(int index, int value) {
        this.leak.record();
        return super.setByte(index, value);
    }

    @Override
    public ByteBuf setShort(int index, int value) {
        this.leak.record();
        return super.setShort(index, value);
    }

    @Override
    public ByteBuf setInt(int index, int value) {
        this.leak.record();
        return super.setInt(index, value);
    }

    @Override
    public ByteBuf setLong(int index, long value) {
        this.leak.record();
        return super.setLong(index, value);
    }

    @Override
    public ByteBuf setBytes(int index, ByteBuf src, int srcIndex, int length) {
        this.leak.record();
        return super.setBytes(index, src, srcIndex, length);
    }

    @Override
    public ByteBuf setBytes(int index, byte[] src, int srcIndex, int length) {
        this.leak.record();
        return super.setBytes(index, src, srcIndex, length);
    }

    @Override
    public int setBytes(int index, ScatteringByteChannel in, int length) throws IOException {
        this.leak.record();
        return super.setBytes(index, in, length);
    }

    @Override
    public byte readByte() {
        this.leak.record();
        return super.readByte();
    }

    @Override
    public short readUnsignedByte() {
        this.leak.record();
        return super.readUnsignedByte();
    }

    @Override
    public short readShort() {
        this.leak.record();
        return super.readShort();
    }

    @Override
    public int readMedium() {
        this.leak.record();
        return super.readMedium();
    }

    @Override
    public int readUnsignedMedium() {
        this.leak.record();
        return super.readUnsignedMedium();
    }

    @Override
    public int readInt() {
        this.leak.record();
        return super.readInt();
    }

    @Override
    public long readLong() {
        this.leak.record();
        return super.readLong();
    }

    @Override
    public ByteBuf readBytes(int length) {
        this.leak.record();
        return super.readBytes(length);
    }

    @Override
    public ByteBuf readBytes(ByteBuf dst, int length) {
        this.leak.record();
        return super.readBytes(dst, length);
    }

    @Override
    public ByteBuf readBytes(byte[] dst) {
        this.leak.record();
        return super.readBytes(dst);
    }

    @Override
    public ByteBuf readBytes(byte[] dst, int dstIndex, int length) {
        this.leak.record();
        return super.readBytes(dst, dstIndex, length);
    }

    @Override
    public int readBytes(GatheringByteChannel out, int length) throws IOException {
        this.leak.record();
        return super.readBytes(out, length);
    }

    @Override
    public ByteBuf skipBytes(int length) {
        this.leak.record();
        return super.skipBytes(length);
    }

    @Override
    public ByteBuf writeByte(int value) {
        this.leak.record();
        return super.writeByte(value);
    }

    @Override
    public ByteBuf writeShort(int value) {
        this.leak.record();
        return super.writeShort(value);
    }

    @Override
    public ByteBuf writeInt(int value) {
        this.leak.record();
        return super.writeInt(value);
    }

    @Override
    public ByteBuf writeLong(long value) {
        this.leak.record();
        return super.writeLong(value);
    }

    @Override
    public ByteBuf writeBytes(ByteBuf src) {
        this.leak.record();
        return super.writeBytes(src);
    }

    @Override
    public ByteBuf writeBytes(ByteBuf src, int length) {
        this.leak.record();
        return super.writeBytes(src, length);
    }

    @Override
    public ByteBuf writeBytes(ByteBuf src, int srcIndex, int length) {
        this.leak.record();
        return super.writeBytes(src, srcIndex, length);
    }

    @Override
    public ByteBuf writeBytes(byte[] src) {
        this.leak.record();
        return super.writeBytes(src);
    }

    @Override
    public ByteBuf writeBytes(byte[] src, int srcIndex, int length) {
        this.leak.record();
        return super.writeBytes(src, srcIndex, length);
    }

    @Override
    public int writeBytes(ScatteringByteChannel in, int length) throws IOException {
        this.leak.record();
        return super.writeBytes(in, length);
    }

    @Override
    public int nioBufferCount() {
        this.leak.record();
        return super.nioBufferCount();
    }

    @Override
    public ByteBuffer nioBuffer(int index, int length) {
        this.leak.record();
        return super.nioBuffer(index, length);
    }

    @Override
    public ByteBuffer[] nioBuffers() {
        this.leak.record();
        return super.nioBuffers();
    }

    @Override
    public ByteBuffer[] nioBuffers(int index, int length) {
        this.leak.record();
        return super.nioBuffers(index, length);
    }

    @Override
    public ByteBuffer internalNioBuffer(int index, int length) {
        this.leak.record();
        return super.internalNioBuffer(index, length);
    }

    @Override
    public ByteBuf retain() {
        this.leak.record();
        return super.retain();
    }

    @Override
    public ByteBuf retain(int increment) {
        this.leak.record();
        return super.retain(increment);
    }

    @Override
    public ByteBuf capacity(int newCapacity) {
        this.leak.record();
        return super.capacity(newCapacity);
    }
}

