/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.config.impl;

import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigIncludeContext;
import com.typesafe.config.ConfigObject;
import com.typesafe.config.ConfigOrigin;
import com.typesafe.config.ConfigParseOptions;
import com.typesafe.config.ConfigParseable;
import com.typesafe.config.ConfigSyntax;
import com.typesafe.config.ConfigValue;
import com.typesafe.config.impl.AbstractConfigObject;
import com.typesafe.config.impl.AbstractConfigValue;
import com.typesafe.config.impl.ConfigImpl;
import com.typesafe.config.impl.ConfigImplUtil;
import com.typesafe.config.impl.Parser;
import com.typesafe.config.impl.PropertiesParser;
import com.typesafe.config.impl.SimpleConfigObject;
import com.typesafe.config.impl.SimpleConfigOrigin;
import com.typesafe.config.impl.SimpleIncludeContext;
import com.typesafe.config.impl.SimpleIncluder;
import com.typesafe.config.impl.Token;
import com.typesafe.config.impl.Tokenizer;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Properties;

public abstract class Parseable
implements ConfigParseable {
    private ConfigIncludeContext includeContext;
    private ConfigParseOptions initialOptions;
    private ConfigOrigin initialOrigin;
    private static final ThreadLocal<LinkedList<Parseable>> parseStack = new ThreadLocal<LinkedList<Parseable>>(){

        @Override
        protected LinkedList<Parseable> initialValue() {
            return new LinkedList<Parseable>();
        }
    };

    protected Parseable() {
    }

    private ConfigParseOptions fixupOptions(ConfigParseOptions configParseOptions) {
        ConfigSyntax configSyntax = configParseOptions.getSyntax();
        if (configSyntax == null) {
            configSyntax = this.guessSyntax();
        }
        if (configSyntax == null) {
            configSyntax = ConfigSyntax.CONF;
        }
        ConfigParseOptions configParseOptions2 = configParseOptions.setSyntax(configSyntax);
        configParseOptions2 = configParseOptions2.appendIncluder(ConfigImpl.defaultIncluder());
        configParseOptions2 = configParseOptions2.setIncluder(SimpleIncluder.makeFull(configParseOptions2.getIncluder()));
        return configParseOptions2;
    }

    protected void postConstruct(ConfigParseOptions configParseOptions) {
        this.initialOptions = this.fixupOptions(configParseOptions);
        this.includeContext = new SimpleIncludeContext(this);
        this.initialOrigin = this.initialOptions.getOriginDescription() != null ? SimpleConfigOrigin.newSimple(this.initialOptions.getOriginDescription()) : this.createOrigin();
    }

    protected abstract Reader reader() throws IOException;

    protected static void trace(String string) {
        if (ConfigImpl.traceLoadsEnabled()) {
            ConfigImpl.trace(string);
        }
    }

    ConfigSyntax guessSyntax() {
        return null;
    }

    ConfigParseable relativeTo(String string) {
        String string2 = string;
        if (string.startsWith("/")) {
            string2 = string.substring(1);
        }
        return Parseable.newResources(string2, this.options().setOriginDescription(null));
    }

    ConfigIncludeContext includeContext() {
        return this.includeContext;
    }

    static AbstractConfigObject forceParsedToObject(ConfigValue configValue) {
        if (configValue instanceof AbstractConfigObject) {
            return (AbstractConfigObject)configValue;
        }
        throw new ConfigException.WrongType(configValue.origin(), "", "object at file root", configValue.valueType().name());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConfigObject parse(ConfigParseOptions configParseOptions) {
        LinkedList<Parseable> linkedList = parseStack.get();
        if (linkedList.size() >= 50) {
            throw new ConfigException.Parse(this.initialOrigin, "include statements nested more than 50 times, you probably have a cycle in your includes. Trace: " + linkedList);
        }
        linkedList.addFirst(this);
        try {
            AbstractConfigObject abstractConfigObject = Parseable.forceParsedToObject(this.parseValue(configParseOptions));
            return abstractConfigObject;
        }
        finally {
            linkedList.removeFirst();
            if (linkedList.isEmpty()) {
                parseStack.remove();
            }
        }
    }

    final AbstractConfigValue parseValue(ConfigParseOptions configParseOptions) {
        ConfigParseOptions configParseOptions2 = this.fixupOptions(configParseOptions);
        ConfigOrigin configOrigin = configParseOptions2.getOriginDescription() != null ? SimpleConfigOrigin.newSimple(configParseOptions2.getOriginDescription()) : this.initialOrigin;
        return this.parseValue(configOrigin, configParseOptions2);
    }

    private final AbstractConfigValue parseValue(ConfigOrigin configOrigin, ConfigParseOptions configParseOptions) {
        try {
            return this.rawParseValue(configOrigin, configParseOptions);
        }
        catch (IOException iOException) {
            if (configParseOptions.getAllowMissing()) {
                return SimpleConfigObject.emptyMissing(configOrigin);
            }
            throw new ConfigException.IO(configOrigin, iOException.getMessage(), iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AbstractConfigValue rawParseValue(ConfigOrigin configOrigin, ConfigParseOptions configParseOptions) throws IOException {
        Reader reader = this.reader();
        try {
            AbstractConfigValue abstractConfigValue = this.rawParseValue(reader, configOrigin, configParseOptions);
            return abstractConfigValue;
        }
        finally {
            reader.close();
        }
    }

    protected AbstractConfigValue rawParseValue(Reader reader, ConfigOrigin configOrigin, ConfigParseOptions configParseOptions) throws IOException {
        if (configParseOptions.getSyntax() == ConfigSyntax.PROPERTIES) {
            return PropertiesParser.parse(reader, configOrigin);
        }
        Iterator<Token> iterator = Tokenizer.tokenize(configOrigin, reader, configParseOptions.getSyntax());
        return Parser.parse(iterator, configOrigin, configParseOptions, this.includeContext());
    }

    public ConfigObject parse() {
        return Parseable.forceParsedToObject(this.parseValue(this.options()));
    }

    protected abstract ConfigOrigin createOrigin();

    @Override
    public ConfigParseOptions options() {
        return this.initialOptions;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    private static ConfigSyntax syntaxFromExtension(String string) {
        if (string.endsWith(".json")) {
            return ConfigSyntax.JSON;
        }
        if (string.endsWith(".conf")) {
            return ConfigSyntax.CONF;
        }
        if (string.endsWith(".properties")) {
            return ConfigSyntax.PROPERTIES;
        }
        return null;
    }

    private static Reader readerFromStream(InputStream inputStream) {
        try {
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream, "UTF-8");
            return new BufferedReader(inputStreamReader);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new ConfigException.BugOrBroken("Java runtime does not support UTF-8", unsupportedEncodingException);
        }
    }

    static URL relativeTo(URL uRL, String string) {
        if (new File(string).isAbsolute()) {
            return null;
        }
        try {
            URI uRI = uRL.toURI();
            URI uRI2 = new URI(string);
            URL uRL2 = uRI.resolve(uRI2).toURL();
            return uRL2;
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    static File relativeTo(File file, String string) {
        File file2 = new File(string);
        if (file2.isAbsolute()) {
            return null;
        }
        File file3 = file.getParentFile();
        if (file3 == null) {
            return null;
        }
        return new File(file3, string);
    }

    public static Parseable newNotFound(String string, String string2, ConfigParseOptions configParseOptions) {
        return new ParseableNotFound(string, string2, configParseOptions);
    }

    public static Parseable newURL(URL uRL, ConfigParseOptions configParseOptions) {
        if (uRL.getProtocol().equals("file")) {
            return Parseable.newFile(ConfigImplUtil.urlToFile(uRL), configParseOptions);
        }
        return new ParseableURL(uRL, configParseOptions);
    }

    public static Parseable newFile(File file, ConfigParseOptions configParseOptions) {
        return new ParseableFile(file, configParseOptions);
    }

    public static Parseable newResources(String string, ConfigParseOptions configParseOptions) {
        return new ParseableResources(string, configParseOptions);
    }

    public static Parseable newProperties(Properties properties, ConfigParseOptions configParseOptions) {
        return new ParseableProperties(properties, configParseOptions);
    }

    private static final class ParseableProperties
    extends Parseable {
        private final Properties props;

        ParseableProperties(Properties properties, ConfigParseOptions configParseOptions) {
            this.props = properties;
            this.postConstruct(configParseOptions);
        }

        @Override
        protected Reader reader() throws IOException {
            throw new ConfigException.BugOrBroken("reader() should not be called on props");
        }

        @Override
        protected AbstractConfigObject rawParseValue(ConfigOrigin configOrigin, ConfigParseOptions configParseOptions) {
            if (ConfigImpl.traceLoadsEnabled()) {
                ParseableProperties.trace("Loading config from properties " + this.props);
            }
            return PropertiesParser.fromProperties(configOrigin, this.props);
        }

        @Override
        ConfigSyntax guessSyntax() {
            return ConfigSyntax.PROPERTIES;
        }

        @Override
        protected ConfigOrigin createOrigin() {
            return SimpleConfigOrigin.newSimple("properties");
        }

        @Override
        public String toString() {
            return this.getClass().getSimpleName() + "(" + this.props.size() + " props)";
        }
    }

    private static final class ParseableResources
    extends Parseable {
        private final String resource;

        ParseableResources(String string, ConfigParseOptions configParseOptions) {
            this.resource = string;
            this.postConstruct(configParseOptions);
        }

        @Override
        protected Reader reader() throws IOException {
            throw new ConfigException.BugOrBroken("reader() should not be called on resources");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected AbstractConfigObject rawParseValue(ConfigOrigin configOrigin, ConfigParseOptions configParseOptions) throws IOException {
            ClassLoader classLoader = configParseOptions.getClassLoader();
            Enumeration<URL> enumeration = classLoader.getResources(this.resource);
            if (!enumeration.hasMoreElements()) {
                if (ConfigImpl.traceLoadsEnabled()) {
                    ParseableResources.trace("Loading config from class loader " + classLoader + " but there were no resources called " + this.resource);
                }
                throw new IOException("resource not found on classpath: " + this.resource);
            }
            AbstractConfigObject abstractConfigObject = SimpleConfigObject.empty(configOrigin);
            while (enumeration.hasMoreElements()) {
                AbstractConfigValue abstractConfigValue;
                URL uRL = enumeration.nextElement();
                if (ConfigImpl.traceLoadsEnabled()) {
                    ParseableResources.trace("Loading config from URL " + uRL.toExternalForm() + " from class loader " + classLoader);
                }
                SimpleConfigOrigin simpleConfigOrigin = ((SimpleConfigOrigin)configOrigin).addURL(uRL);
                InputStream inputStream = uRL.openStream();
                try {
                    Reader reader = Parseable.readerFromStream(inputStream);
                    inputStream = null;
                    try {
                        abstractConfigValue = this.rawParseValue(reader, simpleConfigOrigin, configParseOptions);
                    }
                    finally {
                        reader.close();
                    }
                }
                finally {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                abstractConfigObject = abstractConfigObject.withFallback(abstractConfigValue);
            }
            return abstractConfigObject;
        }

        @Override
        ConfigSyntax guessSyntax() {
            return Parseable.syntaxFromExtension(this.resource);
        }

        static String parent(String string) {
            int n = string.lastIndexOf(47);
            if (n < 0) {
                return null;
            }
            return string.substring(0, n);
        }

        @Override
        ConfigParseable relativeTo(String string) {
            if (string.startsWith("/")) {
                return ParseableResources.newResources(string.substring(1), this.options().setOriginDescription(null));
            }
            String string2 = ParseableResources.parent(this.resource);
            if (string2 == null) {
                return ParseableResources.newResources(string, this.options().setOriginDescription(null));
            }
            return ParseableResources.newResources(string2 + "/" + string, this.options().setOriginDescription(null));
        }

        @Override
        protected ConfigOrigin createOrigin() {
            return SimpleConfigOrigin.newResource(this.resource);
        }

        @Override
        public String toString() {
            return this.getClass().getSimpleName() + "(" + this.resource + ")";
        }
    }

    private static final class ParseableFile
    extends Parseable {
        private final File input;

        ParseableFile(File file, ConfigParseOptions configParseOptions) {
            this.input = file;
            this.postConstruct(configParseOptions);
        }

        @Override
        protected Reader reader() throws IOException {
            if (ConfigImpl.traceLoadsEnabled()) {
                ParseableFile.trace("Loading config from a file: " + this.input);
            }
            FileInputStream fileInputStream = new FileInputStream(this.input);
            return Parseable.readerFromStream(fileInputStream);
        }

        @Override
        ConfigSyntax guessSyntax() {
            return Parseable.syntaxFromExtension(this.input.getName());
        }

        @Override
        ConfigParseable relativeTo(String string) {
            File file = new File(string).isAbsolute() ? new File(string) : ParseableFile.relativeTo(this.input, string);
            if (file == null) {
                return null;
            }
            if (file.exists()) {
                return ParseableFile.newFile(file, this.options().setOriginDescription(null));
            }
            return super.relativeTo(string);
        }

        @Override
        protected ConfigOrigin createOrigin() {
            return SimpleConfigOrigin.newFile(this.input.getPath());
        }

        @Override
        public String toString() {
            return this.getClass().getSimpleName() + "(" + this.input.getPath() + ")";
        }
    }

    private static final class ParseableURL
    extends Parseable {
        private final URL input;

        ParseableURL(URL uRL, ConfigParseOptions configParseOptions) {
            this.input = uRL;
            this.postConstruct(configParseOptions);
        }

        @Override
        protected Reader reader() throws IOException {
            if (ConfigImpl.traceLoadsEnabled()) {
                ParseableURL.trace("Loading config from a URL: " + this.input.toExternalForm());
            }
            InputStream inputStream = this.input.openStream();
            return Parseable.readerFromStream(inputStream);
        }

        @Override
        ConfigSyntax guessSyntax() {
            return Parseable.syntaxFromExtension(this.input.getPath());
        }

        @Override
        ConfigParseable relativeTo(String string) {
            URL uRL = ParseableURL.relativeTo(this.input, string);
            if (uRL == null) {
                return null;
            }
            return ParseableURL.newURL(uRL, this.options().setOriginDescription(null));
        }

        @Override
        protected ConfigOrigin createOrigin() {
            return SimpleConfigOrigin.newURL(this.input);
        }

        @Override
        public String toString() {
            return this.getClass().getSimpleName() + "(" + this.input.toExternalForm() + ")";
        }
    }

    private static final class ParseableNotFound
    extends Parseable {
        private final String what;
        private final String message;

        ParseableNotFound(String string, String string2, ConfigParseOptions configParseOptions) {
            this.what = string;
            this.message = string2;
            this.postConstruct(configParseOptions);
        }

        @Override
        protected Reader reader() throws IOException {
            throw new FileNotFoundException(this.message);
        }

        @Override
        protected ConfigOrigin createOrigin() {
            return SimpleConfigOrigin.newSimple(this.what);
        }
    }
}

