/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import javax.annotation.Nullable;

public final class Functions {
    public static <E> Function<Object, E> constant(@Nullable E value) {
        return new ConstantFunction<E>(value);
    }

    private static class ConstantFunction<E>
    implements Function<Object, E>,
    Serializable {
        private final E value;

        public ConstantFunction(@Nullable E value) {
            this.value = value;
        }

        @Override
        public E apply(@Nullable Object from) {
            return this.value;
        }

        @Override
        public boolean equals(@Nullable Object obj) {
            if (obj instanceof ConstantFunction) {
                ConstantFunction that = (ConstantFunction)obj;
                return Objects.equal(this.value, that.value);
            }
            return false;
        }

        public int hashCode() {
            return this.value == null ? 0 : this.value.hashCode();
        }

        public String toString() {
            return "constant(" + this.value + ")";
        }
    }

    private static enum IdentityFunction implements Function<Object, Object>
    {
        INSTANCE;


        @Override
        @Nullable
        public Object apply(@Nullable Object o) {
            return o;
        }

        public String toString() {
            return "identity";
        }
    }

    private static enum ToStringFunction implements Function<Object, String>
    {
        INSTANCE;


        @Override
        public String apply(Object o) {
            Preconditions.checkNotNull(o);
            return o.toString();
        }

        public String toString() {
            return "toString";
        }
    }
}

