/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core.format;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public interface InputAccessor {
    public boolean hasMoreBytes() throws IOException;

    public byte nextByte() throws IOException;

    public static class Std
    implements InputAccessor {
        protected final InputStream _in = null;
        protected final byte[] _buffer;
        protected final int _bufferedStart;
        protected int _bufferedEnd;
        protected int _ptr;

        public Std(byte[] inputDocument, int start, int len) {
            this._buffer = inputDocument;
            this._ptr = start;
            this._bufferedStart = start;
            this._bufferedEnd = start + len;
        }

        public boolean hasMoreBytes() throws IOException {
            if (this._ptr < this._bufferedEnd) {
                return true;
            }
            if (this._in == null) {
                return false;
            }
            int amount = this._buffer.length - this._ptr;
            if (amount < 1) {
                return false;
            }
            int count = this._in.read(this._buffer, this._ptr, amount);
            if (count <= 0) {
                return false;
            }
            this._bufferedEnd += count;
            return true;
        }

        public byte nextByte() throws IOException {
            if (this._ptr >= this._bufferedEnd && !this.hasMoreBytes()) {
                throw new EOFException("Failed auto-detect: could not read more than " + this._ptr + " bytes (max buffer size: " + this._buffer.length + ")");
            }
            return this._buffer[this._ptr++];
        }

        public void reset() {
            this._ptr = this._bufferedStart;
        }
    }
}

