/*
 * Decompiled with CFR 0.152.
 */
package com.dyuproject.protostuff;

import com.dyuproject.protostuff.LinkedBuffer;
import com.dyuproject.protostuff.StringSerializer;
import com.dyuproject.protostuff.WriteSession;
import java.io.IOException;
import java.io.OutputStream;

public final class StreamedStringSerializer {
    private StreamedStringSerializer() {
    }

    public static LinkedBuffer writeInt(int value, WriteSession session, OutputStream out, LinkedBuffer lb) throws IOException {
        int size;
        if (value == Integer.MIN_VALUE) {
            int valueLen = StringSerializer.INT_MIN_VALUE.length;
            if (lb.offset + valueLen > lb.buffer.length) {
                out.write(lb.buffer, lb.start, lb.offset - lb.start);
                lb.offset = lb.start;
            }
            System.arraycopy(StringSerializer.INT_MIN_VALUE, 0, lb.buffer, lb.offset, valueLen);
            lb.offset += valueLen;
            session.size += valueLen;
            return lb;
        }
        int n = size = value < 0 ? StringSerializer.stringSize(-value) + 1 : StringSerializer.stringSize(value);
        if (lb.offset + size > lb.buffer.length) {
            out.write(lb.buffer, lb.start, lb.offset - lb.start);
            lb.offset = lb.start;
        }
        StringSerializer.putBytesFromInt(value, lb.offset, size, lb.buffer);
        lb.offset += size;
        session.size += size;
        return lb;
    }

    public static LinkedBuffer writeLong(long value, WriteSession session, OutputStream out, LinkedBuffer lb) throws IOException {
        int size;
        if (value == Long.MIN_VALUE) {
            int valueLen = StringSerializer.LONG_MIN_VALUE.length;
            if (lb.offset + valueLen > lb.buffer.length) {
                out.write(lb.buffer, lb.start, lb.offset - lb.start);
                lb.offset = lb.start;
            }
            System.arraycopy(StringSerializer.LONG_MIN_VALUE, 0, lb.buffer, lb.offset, valueLen);
            lb.offset += valueLen;
            session.size += valueLen;
            return lb;
        }
        int n = size = value < 0L ? StringSerializer.stringSize(-value) + 1 : StringSerializer.stringSize(value);
        if (lb.offset + size > lb.buffer.length) {
            out.write(lb.buffer, lb.start, lb.offset - lb.start);
            lb.offset = lb.start;
        }
        StringSerializer.putBytesFromLong(value, lb.offset, size, lb.buffer);
        lb.offset += size;
        session.size += size;
        return lb;
    }

    public static LinkedBuffer writeFloat(float value, WriteSession session, OutputStream out, LinkedBuffer lb) throws IOException {
        return StreamedStringSerializer.writeAscii(Float.toString(value), session, out, lb);
    }

    public static LinkedBuffer writeDouble(double value, WriteSession session, OutputStream out, LinkedBuffer lb) throws IOException {
        return StreamedStringSerializer.writeAscii(Double.toString(value), session, out, lb);
    }

    public static LinkedBuffer writeUTF8(String str, WriteSession session, OutputStream out, LinkedBuffer lb) throws IOException {
        int len = str.length();
        if (len == 0) {
            return lb;
        }
        byte[] buffer = lb.buffer;
        int limit = buffer.length;
        int offset = lb.offset;
        int i = 0;
        do {
            char c;
            if ((c = str.charAt(i++)) < '\u0080') {
                if (offset == limit) {
                    out.write(buffer, lb.start, offset - lb.start);
                    session.size += offset - lb.offset;
                    lb.offset = offset = lb.start;
                }
                buffer[offset++] = (byte)c;
                continue;
            }
            if (c < '\u0800') {
                if (offset + 2 > limit) {
                    out.write(buffer, lb.start, offset - lb.start);
                    session.size += offset - lb.offset;
                    lb.offset = offset = lb.start;
                }
                buffer[offset++] = (byte)(0xC0 | c >> 6 & 0x1F);
                buffer[offset++] = (byte)(0x80 | c >> 0 & 0x3F);
                continue;
            }
            if (offset + 3 > limit) {
                out.write(buffer, lb.start, offset - lb.start);
                session.size += offset - lb.offset;
                lb.offset = offset = lb.start;
            }
            buffer[offset++] = (byte)(0xE0 | c >> 12 & 0xF);
            buffer[offset++] = (byte)(0x80 | c >> 6 & 0x3F);
            buffer[offset++] = (byte)(0x80 | c >> 0 & 0x3F);
        } while (i < len);
        session.size += offset - lb.offset;
        lb.offset = offset;
        return lb;
    }

    public static LinkedBuffer writeAscii(String str, WriteSession session, OutputStream out, LinkedBuffer lb) throws IOException {
        int len = str.length();
        if (len == 0) {
            return lb;
        }
        int offset = lb.offset;
        int limit = lb.buffer.length;
        byte[] buffer = lb.buffer;
        session.size += len;
        if (offset + len > limit) {
            int index = 0;
            int start = lb.start;
            int bufSize = limit - start;
            int available = limit - offset;
            int remaining = len - available;
            int loops = remaining / bufSize;
            int extra = remaining % bufSize;
            while (available-- > 0) {
                buffer[offset++] = (byte)str.charAt(index++);
            }
            out.write(buffer, start, bufSize);
            offset = start;
            while (loops-- > 0) {
                for (int i = 0; i < bufSize; ++i) {
                    buffer[offset++] = (byte)str.charAt(index++);
                }
                out.write(buffer, start, bufSize);
                offset = start;
            }
            while (extra-- > 0) {
                buffer[offset++] = (byte)str.charAt(index++);
            }
        } else {
            for (int i = 0; i < len; ++i) {
                buffer[offset++] = (byte)str.charAt(i);
            }
        }
        lb.offset = offset;
        return lb;
    }

    private static void flushAndReset(LinkedBuffer node, OutputStream out) throws IOException {
        do {
            int len;
            if ((len = node.offset - node.start) <= 0) continue;
            out.write(node.buffer, node.start, len);
            node.offset = node.start;
        } while ((node = node.next) != null);
    }

    public static LinkedBuffer writeUTF8FixedDelimited(String str, boolean littleEndian, WriteSession session, OutputStream out, LinkedBuffer lb) throws IOException {
        int lastSize = session.size;
        int withIntOffset = lb.offset + 2;
        int len = str.length();
        if (withIntOffset + len > lb.buffer.length) {
            out.write(lb.buffer, lb.start, lb.offset - lb.start);
            lb.offset = lb.start;
            withIntOffset = lb.offset + 2;
            if (len == 0) {
                StringSerializer.writeFixed2ByteInt(0, lb.buffer, withIntOffset - 2, littleEndian);
                lb.offset = withIntOffset;
                session.size += 2;
                return lb;
            }
            if (withIntOffset + len > lb.buffer.length) {
                lb.offset = withIntOffset;
                LinkedBuffer rb = StringSerializer.writeUTF8(str, 0, len, lb.buffer, withIntOffset, lb.buffer.length, session, lb);
                StringSerializer.writeFixed2ByteInt(session.size - lastSize, lb.buffer, withIntOffset - 2, littleEndian);
                session.size += 2;
                assert (rb != lb);
                StreamedStringSerializer.flushAndReset(lb, out);
                return lb;
            }
        } else if (len == 0) {
            StringSerializer.writeFixed2ByteInt(0, lb.buffer, withIntOffset - 2, littleEndian);
            lb.offset = withIntOffset;
            session.size += 2;
            return lb;
        }
        lb.offset = withIntOffset;
        LinkedBuffer rb = StringSerializer.writeUTF8(str, 0, len, session, lb);
        StringSerializer.writeFixed2ByteInt(session.size - lastSize, lb.buffer, withIntOffset - 2, littleEndian);
        session.size += 2;
        if (rb != lb) {
            StreamedStringSerializer.flushAndReset(lb, out);
        }
        return lb;
    }

    private static LinkedBuffer writeUTF8OneByteDelimited(String str, int index, int len, WriteSession session, OutputStream out, LinkedBuffer lb) throws IOException {
        int lastSize = session.size;
        int withIntOffset = lb.offset + 1;
        if (withIntOffset + len > lb.buffer.length) {
            out.write(lb.buffer, lb.start, lb.offset - lb.start);
            lb.offset = lb.start;
            withIntOffset = lb.offset + 1;
        }
        lb.offset = withIntOffset;
        LinkedBuffer rb = StringSerializer.writeUTF8(str, index, len, session, lb);
        lb.buffer[withIntOffset - 1] = (byte)(session.size - lastSize);
        ++session.size;
        if (rb != lb) {
            StreamedStringSerializer.flushAndReset(lb, out);
        }
        return lb;
    }

    private static LinkedBuffer writeUTF8VarDelimited(String str, int index, int len, int lowerLimit, int expectedSize, WriteSession session, OutputStream out, LinkedBuffer lb) throws IOException {
        int lastSize = session.size;
        int offset = lb.offset;
        int withIntOffset = offset + expectedSize;
        if (withIntOffset + len > lb.buffer.length) {
            out.write(lb.buffer, lb.start, lb.offset - lb.start);
            offset = lb.start;
            withIntOffset = offset + expectedSize;
            if (withIntOffset + len > lb.buffer.length) {
                lb.offset = withIntOffset;
                LinkedBuffer rb = StringSerializer.writeUTF8(str, index, len, lb.buffer, withIntOffset, lb.buffer.length, session, lb);
                int size = session.size - lastSize;
                if (size < lowerLimit) {
                    session.size += --expectedSize;
                    withIntOffset = ++offset;
                    while (--expectedSize > 0) {
                        lb.buffer[offset++] = (byte)(size & 0x7F | 0x80);
                        size >>>= 7;
                    }
                    lb.buffer[offset] = (byte)size;
                    out.write(lb.buffer, withIntOffset, lb.offset - withIntOffset);
                    lb.offset = lb.start;
                    assert (rb != lb);
                    StreamedStringSerializer.flushAndReset(lb.next, out);
                    return lb;
                }
                session.size += expectedSize;
                while (--expectedSize > 0) {
                    lb.buffer[offset++] = (byte)(size & 0x7F | 0x80);
                    size >>>= 7;
                }
                lb.buffer[offset] = (byte)size;
                assert (rb != lb);
                StreamedStringSerializer.flushAndReset(lb, out);
                return lb;
            }
        }
        lb.offset = withIntOffset;
        LinkedBuffer rb = StringSerializer.writeUTF8(str, index, len, session, lb);
        int size = session.size - lastSize;
        if (size < lowerLimit) {
            if (rb != lb || expectedSize != 2) {
                session.size += --expectedSize;
                if (offset != lb.start) {
                    out.write(lb.buffer, lb.start, offset - lb.start);
                }
                withIntOffset = ++offset;
                while (--expectedSize > 0) {
                    lb.buffer[offset++] = (byte)(size & 0x7F | 0x80);
                    size >>>= 7;
                }
                lb.buffer[offset] = (byte)size;
                out.write(lb.buffer, withIntOffset, lb.offset - withIntOffset);
                lb.offset = lb.start;
                if (rb != lb) {
                    StreamedStringSerializer.flushAndReset(lb.next, out);
                }
                return lb;
            }
            System.arraycopy(lb.buffer, withIntOffset, lb.buffer, withIntOffset - 1, lb.offset - withIntOffset);
            --expectedSize;
            --lb.offset;
        }
        session.size += expectedSize;
        while (--expectedSize > 0) {
            lb.buffer[offset++] = (byte)(size & 0x7F | 0x80);
            size >>>= 7;
        }
        lb.buffer[offset] = (byte)size;
        if (rb != lb) {
            StreamedStringSerializer.flushAndReset(lb, out);
        }
        return lb;
    }

    public static LinkedBuffer writeUTF8VarDelimited(String str, WriteSession session, OutputStream out, LinkedBuffer lb) throws IOException {
        int len = str.length();
        if (len == 0) {
            if (lb.offset == lb.buffer.length) {
                out.write(lb.buffer, lb.start, lb.offset - lb.start);
                lb.offset = lb.start;
            }
            lb.buffer[lb.offset++] = 0;
            ++session.size;
            return lb;
        }
        if (len < 43) {
            return StreamedStringSerializer.writeUTF8OneByteDelimited(str, 0, len, session, out, lb);
        }
        if (len < 5462) {
            return StreamedStringSerializer.writeUTF8VarDelimited(str, 0, len, 128, 2, session, out, lb);
        }
        if (len < 699051) {
            return StreamedStringSerializer.writeUTF8VarDelimited(str, 0, len, 16384, 3, session, out, lb);
        }
        if (len < 0x5555556) {
            return StreamedStringSerializer.writeUTF8VarDelimited(str, 0, len, 0x200000, 4, session, out, lb);
        }
        return StreamedStringSerializer.writeUTF8VarDelimited(str, 0, len, 0x10000000, 5, session, out, lb);
    }
}

