/*
 * Decompiled with CFR 0.152.
 */
package com.dyuproject.protostuff;

import com.dyuproject.protostuff.JsonInput;
import com.dyuproject.protostuff.JsonInputException;
import com.dyuproject.protostuff.JsonOutput;
import com.dyuproject.protostuff.Schema;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.codehaus.jackson.JsonEncoding;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;
import org.codehaus.jackson.impl.Utf8Generator;
import org.codehaus.jackson.impl.Utf8StreamParser;
import org.codehaus.jackson.io.IOContext;
import org.codehaus.jackson.sym.BytesToNameCanonicalizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JsonIOUtil {
    public static final Factory DEFAULT_JSON_FACTORY = new Factory();

    static Utf8StreamParser newJsonParser(InputStream in, byte[] buf, int offset, int limit, boolean bufferRecyclable, IOContext context) throws IOException {
        return new Utf8StreamParser(context, DEFAULT_JSON_FACTORY.getParserFeatures(), in, DEFAULT_JSON_FACTORY.getCodec(), DEFAULT_JSON_FACTORY.getRootByteSymbols().makeChild(true, true), buf, offset, limit, bufferRecyclable);
    }

    static Utf8Generator newJsonGenerator(OutputStream out, byte[] buf, int offset, boolean bufferRecyclable, IOContext context) {
        context.setEncoding(JsonEncoding.UTF8);
        return new Utf8Generator(context, DEFAULT_JSON_FACTORY.getGeneratorFeatures(), DEFAULT_JSON_FACTORY.getCodec(), out, buf, offset, bufferRecyclable);
    }

    public static <T> void mergeFrom(byte[] data, T message, Schema<T> schema, boolean numeric) throws IOException {
        JsonIOUtil.mergeFrom(data, 0, data.length, message, schema, numeric);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> void mergeFrom(byte[] data, int offset, int length, T message, Schema<T> schema, boolean numeric) throws IOException {
        IOContext context = new IOContext(DEFAULT_JSON_FACTORY._getBufferRecycler(), data, false);
        Utf8StreamParser parser = JsonIOUtil.newJsonParser(null, data, offset, offset + length, false, context);
        try {
            JsonIOUtil.mergeFrom(parser, message, schema, numeric);
        }
        finally {
            ((JsonParser)parser).close();
        }
    }

    public static <T> void mergeFrom(JsonParser parser, T message, Schema<T> schema, boolean numeric) throws IOException {
        if (parser.nextToken() != JsonToken.START_OBJECT) {
            throw new JsonInputException("Expected token: { but was " + (Object)((Object)parser.getCurrentToken()) + " on message " + schema.messageFullName());
        }
        schema.mergeFrom(new JsonInput(parser, numeric), message);
        if (parser.getCurrentToken() != JsonToken.END_OBJECT) {
            throw new JsonInputException("Expected token: } but was " + (Object)((Object)parser.getCurrentToken()) + " on message " + schema.messageFullName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> void writeTo(OutputStream out, T message, Schema<T> schema, boolean numeric) throws IOException {
        IOContext context = new IOContext(DEFAULT_JSON_FACTORY._getBufferRecycler(), out, false);
        Utf8Generator generator = JsonIOUtil.newJsonGenerator(out, context.allocWriteEncodingBuffer(), 0, true, context);
        try {
            JsonIOUtil.writeTo(generator, message, schema, numeric);
        }
        finally {
            ((JsonGenerator)generator).close();
        }
    }

    public static <T> void writeTo(JsonGenerator generator, T message, Schema<T> schema, boolean numeric) throws IOException {
        generator.writeStartObject();
        JsonOutput output = new JsonOutput(generator, numeric, schema);
        schema.writeTo(output, message);
        if (output.isLastRepeated()) {
            generator.writeEndArray();
        }
        generator.writeEndObject();
    }

    static {
        DEFAULT_JSON_FACTORY.disable(JsonParser.Feature.AUTO_CLOSE_SOURCE);
        DEFAULT_JSON_FACTORY.disable(JsonGenerator.Feature.AUTO_CLOSE_TARGET);
    }

    public static final class Factory
    extends JsonFactory {
        public BytesToNameCanonicalizer getRootByteSymbols() {
            return this._rootByteSymbols;
        }

        public int getParserFeatures() {
            return this._parserFeatures;
        }

        public int getGeneratorFeatures() {
            return this._generatorFeatures;
        }
    }
}

