/*
 * Decompiled with CFR 0.152.
 */
package com.dyuproject.protostuff;

import com.dyuproject.protostuff.LinkedBuffer;
import com.dyuproject.protostuff.WriteSession;
import java.io.IOException;
import java.io.OutputStream;

public final class B64Code {
    static final byte[] nibble2code = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};
    static final byte[] code2nibble = new byte[256];

    private B64Code() {
    }

    private static void encode(byte[] input, int inOffset, int inLen, byte[] output, int outOffset) {
        byte b1;
        byte b0;
        int remaining = inLen % 3;
        int stop = inOffset + (inLen - remaining);
        while (inOffset < stop) {
            b0 = input[inOffset++];
            b1 = input[inOffset++];
            byte b2 = input[inOffset++];
            output[outOffset++] = nibble2code[b0 >>> 2 & 0x3F];
            output[outOffset++] = nibble2code[b0 << 4 & 0x3F | b1 >>> 4 & 0xF];
            output[outOffset++] = nibble2code[b1 << 2 & 0x3F | b2 >>> 6 & 3];
            output[outOffset++] = nibble2code[b2 & 0x3F];
        }
        switch (remaining) {
            case 0: {
                break;
            }
            case 1: {
                b0 = input[inOffset++];
                output[outOffset++] = nibble2code[b0 >>> 2 & 0x3F];
                output[outOffset++] = nibble2code[b0 << 4 & 0x3F];
                output[outOffset++] = 61;
                output[outOffset++] = 61;
                break;
            }
            case 2: {
                b0 = input[inOffset++];
                b1 = input[inOffset++];
                output[outOffset++] = nibble2code[b0 >>> 2 & 0x3F];
                output[outOffset++] = nibble2code[b0 << 4 & 0x3F | b1 >>> 4 & 0xF];
                output[outOffset++] = nibble2code[b1 << 2 & 0x3F];
                output[outOffset++] = 61;
                break;
            }
            default: {
                throw new IllegalStateException("should not happen");
            }
        }
    }

    private static int encodeExplicit(byte[] input, int inOffset, int inLen, byte[] output, int outOffset, int loops) {
        while (loops-- > 0) {
            byte b0 = input[inOffset++];
            byte b1 = input[inOffset++];
            byte b2 = input[inOffset++];
            output[outOffset++] = nibble2code[b0 >>> 2 & 0x3F];
            output[outOffset++] = nibble2code[b0 << 4 & 0x3F | b1 >>> 4 & 0xF];
            output[outOffset++] = nibble2code[b1 << 2 & 0x3F | b2 >>> 6 & 3];
            output[outOffset++] = nibble2code[b2 & 0x3F];
        }
        return inOffset;
    }

    public static LinkedBuffer encode(byte[] input, int inOffset, int inLen, WriteSession session, LinkedBuffer lb) throws IOException {
        int outputSize = (inLen + 2) / 3 * 4;
        session.size += outputSize;
        int available = lb.buffer.length - lb.offset;
        if (outputSize > available) {
            int chunks = available / 4;
            if (chunks == 0) {
                if (outputSize > session.nextBufferSize) {
                    byte[] encoded = new byte[outputSize];
                    B64Code.encode(input, inOffset, inLen, encoded, 0);
                    return new LinkedBuffer(session.nextBufferSize, new LinkedBuffer(encoded, 0, outputSize, lb));
                }
                byte[] encoded = new byte[session.nextBufferSize];
                B64Code.encode(input, inOffset, inLen, encoded, 0);
                return new LinkedBuffer(encoded, 0, outputSize, lb);
            }
            int inBefore = inOffset;
            byte[] buffer = lb.buffer;
            int offset = lb.offset;
            while (chunks-- > 0) {
                byte b0 = input[inOffset++];
                byte b1 = input[inOffset++];
                byte b2 = input[inOffset++];
                buffer[offset++] = nibble2code[b0 >>> 2 & 0x3F];
                buffer[offset++] = nibble2code[b0 << 4 & 0x3F | b1 >>> 4 & 0xF];
                buffer[offset++] = nibble2code[b1 << 2 & 0x3F | b2 >>> 6 & 3];
                buffer[offset++] = nibble2code[b2 & 0x3F];
            }
            inLen -= inOffset - inBefore;
            lb.offset = offset;
            if ((outputSize -= offset - lb.offset) > session.nextBufferSize) {
                byte[] encoded = new byte[outputSize];
                B64Code.encode(input, inOffset, inLen, encoded, 0);
                return new LinkedBuffer(session.nextBufferSize, new LinkedBuffer(encoded, 0, outputSize, lb));
            }
            byte[] encoded = new byte[session.nextBufferSize];
            B64Code.encode(input, inOffset, inLen, encoded, 0);
            return new LinkedBuffer(encoded, 0, outputSize, lb);
        }
        B64Code.encode(input, inOffset, inLen, lb.buffer, lb.offset);
        lb.offset += outputSize;
        return lb;
    }

    public static LinkedBuffer encode(byte[] input, int inOffset, int inLen, WriteSession session, OutputStream out, LinkedBuffer lb) throws IOException {
        int outputSize = (inLen + 2) / 3 * 4;
        session.size += outputSize;
        int available = lb.buffer.length - lb.offset;
        if (outputSize > available) {
            int bufSize = lb.buffer.length - lb.start;
            if (outputSize > bufSize) {
                int chunks = available / 4;
                if (chunks == 0) {
                    out.write(lb.buffer, lb.start, lb.offset - lb.start);
                    lb.offset = lb.start;
                    int loops = bufSize / 4;
                    int inProcessLen = loops * 3;
                    int outProcessLen = loops * 4;
                    do {
                        inOffset = B64Code.encodeExplicit(input, inOffset, 0, lb.buffer, lb.offset, loops);
                        out.write(lb.buffer, lb.offset, outProcessLen);
                        outputSize -= outProcessLen;
                    } while ((inLen -= inProcessLen) > inProcessLen);
                    B64Code.encode(input, inOffset, inLen, lb.buffer, lb.offset);
                    lb.offset += outputSize;
                    return lb;
                }
                int inBefore = inOffset;
                byte[] buffer = lb.buffer;
                int offset = lb.offset;
                while (chunks-- > 0) {
                    byte b0 = input[inOffset++];
                    byte b1 = input[inOffset++];
                    byte b2 = input[inOffset++];
                    buffer[offset++] = nibble2code[b0 >>> 2 & 0x3F];
                    buffer[offset++] = nibble2code[b0 << 4 & 0x3F | b1 >>> 4 & 0xF];
                    buffer[offset++] = nibble2code[b1 << 2 & 0x3F | b2 >>> 6 & 3];
                    buffer[offset++] = nibble2code[b2 & 0x3F];
                }
                inLen -= inOffset - inBefore;
                out.write(buffer, lb.start, offset - lb.start);
                lb.offset = lb.start;
                if ((outputSize -= offset - lb.offset) > bufSize) {
                    int loops = bufSize / 4;
                    int inProcessLen = loops * 3;
                    int outProcessLen = loops * 4;
                    do {
                        inOffset = B64Code.encodeExplicit(input, inOffset, 0, lb.buffer, lb.offset, loops);
                        out.write(lb.buffer, lb.offset, outProcessLen);
                        outputSize -= outProcessLen;
                    } while ((inLen -= inProcessLen) > inProcessLen);
                    B64Code.encode(input, inOffset, inLen, lb.buffer, lb.offset);
                    lb.offset += outputSize;
                    return lb;
                }
                B64Code.encode(input, inOffset, inLen, lb.buffer, lb.offset);
                lb.offset += outputSize;
                return lb;
            }
            out.write(lb.buffer, lb.start, lb.offset - lb.start);
            lb.offset = lb.start;
        }
        B64Code.encode(input, inOffset, inLen, lb.buffer, lb.offset);
        lb.offset += outputSize;
        return lb;
    }

    static {
        for (int i = 0; i < 256; ++i) {
            B64Code.code2nibble[i] = -1;
        }
        for (int b = 0; b < 64; b = (int)((byte)(b + 1))) {
            B64Code.code2nibble[B64Code.nibble2code[b]] = b;
        }
        B64Code.code2nibble[61] = 0;
    }
}

