/*
 * Decompiled with CFR 0.152.
 */
package com.codahale.metrics.jvm;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.MetricSet;
import com.codahale.metrics.jvm.ThreadDeadlockDetector;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ThreadStatesGaugeSet
implements MetricSet {
    private final ThreadMXBean threads;
    private final ThreadDeadlockDetector deadlockDetector;

    public ThreadStatesGaugeSet() {
        this(ManagementFactory.getThreadMXBean(), new ThreadDeadlockDetector());
    }

    public ThreadStatesGaugeSet(ThreadMXBean threads, ThreadDeadlockDetector deadlockDetector) {
        this.threads = threads;
        this.deadlockDetector = deadlockDetector;
    }

    @Override
    public Map<String, Metric> getMetrics() {
        HashMap<String, Gauge<Object>> gauges = new HashMap<String, Gauge<Object>>();
        for (final Thread.State state : Thread.State.values()) {
            gauges.put(MetricRegistry.name(state.toString().toLowerCase(), "count"), new Gauge<Object>(){});
        }
        gauges.put("count", new Gauge<Integer>(){});
        gauges.put("daemon.count", new Gauge<Integer>(){});
        gauges.put("deadlocks", new Gauge<Set<String>>(){});
        return Collections.unmodifiableMap(gauges);
    }
}

