/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.AbstractIterator;
import com.carrotsearch.hppc.BitUtil;
import com.carrotsearch.hppc.Internals;
import com.carrotsearch.hppc.LongObjectMap;
import com.carrotsearch.hppc.cursors.LongObjectCursor;
import java.util.Iterator;

public class LongObjectOpenHashMap<VType>
implements LongObjectMap<VType>,
Cloneable {
    public long[] keys;
    public VType[] values;
    public boolean[] allocated;
    public int assigned;
    public final float loadFactor;
    private int resizeThreshold;
    private int lastSlot;

    public LongObjectOpenHashMap() {
        this(16);
    }

    public LongObjectOpenHashMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public LongObjectOpenHashMap(int initialCapacity, float loadFactor) {
        initialCapacity = Math.max(initialCapacity, 4);
        assert (initialCapacity > 0) : "Initial capacity must be between (0, 2147483647].";
        assert (loadFactor > 0.0f && loadFactor <= 1.0f) : "Load factor must be between (0, 1].";
        this.loadFactor = loadFactor;
        this.allocateBuffers(this.roundCapacity(initialCapacity));
    }

    private void allocateBuffers(int capacity) {
        this.keys = new long[capacity];
        this.values = (Object[])Internals.newArray(capacity);
        this.allocated = new boolean[capacity];
        this.resizeThreshold = (int)((float)capacity * this.loadFactor);
    }

    @Override
    public VType get(long key) {
        int mask = this.allocated.length - 1;
        int slot = Internals.rehash(key) & mask;
        while (this.allocated[slot]) {
            if (key == this.keys[slot]) {
                return this.values[slot];
            }
            slot = slot + 1 & mask;
        }
        return null;
    }

    @Override
    public boolean containsKey(long key) {
        int mask = this.allocated.length - 1;
        int slot = Internals.rehash(key) & mask;
        while (this.allocated[slot]) {
            if (key == this.keys[slot]) {
                this.lastSlot = slot;
                return true;
            }
            slot = slot + 1 & mask;
        }
        this.lastSlot = -1;
        return false;
    }

    protected int roundCapacity(int requestedCapacity) {
        if (requestedCapacity > 0x40000000) {
            return 0x40000000;
        }
        return Math.max(4, BitUtil.nextHighestPowerOfTwo(requestedCapacity));
    }

    @Override
    public int size() {
        return this.assigned;
    }

    public int hashCode() {
        int h = 0;
        for (LongObjectCursor<VType> c : this) {
            h += Internals.rehash(c.key) + Internals.rehash(c.value);
        }
        return h;
    }

    public boolean equals(Object obj) {
        if (obj != null) {
            LongObjectMap other;
            if (obj == this) {
                return true;
            }
            if (obj instanceof LongObjectMap && (other = (LongObjectMap)obj).size() == this.size()) {
                for (LongObjectCursor<VType> c : this) {
                    if (other.containsKey(c.key)) {
                        Object v = other.get(c.key);
                        if (c.value == null ? v == null : c.value.equals(v)) continue;
                    }
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public Iterator<LongObjectCursor<VType>> iterator() {
        return new EntryIterator();
    }

    public LongObjectOpenHashMap<VType> clone() {
        try {
            LongObjectOpenHashMap cloned = (LongObjectOpenHashMap)super.clone();
            cloned.keys = (long[])this.keys.clone();
            cloned.values = (Object[])this.values.clone();
            cloned.allocated = (boolean[])this.allocated.clone();
            return cloned;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("[");
        boolean first = true;
        for (LongObjectCursor<VType> cursor : this) {
            if (!first) {
                buffer.append(", ");
            }
            buffer.append(cursor.key);
            buffer.append("=>");
            buffer.append(cursor.value);
            first = false;
        }
        buffer.append("]");
        return buffer.toString();
    }

    private final class EntryIterator
    extends AbstractIterator<LongObjectCursor<VType>> {
        private final LongObjectCursor<VType> cursor = new LongObjectCursor();

        public EntryIterator() {
            this.cursor.index = -1;
        }

        @Override
        protected LongObjectCursor<VType> fetch() {
            int i;
            int max = LongObjectOpenHashMap.this.keys.length;
            for (i = this.cursor.index + 1; i < max && !LongObjectOpenHashMap.this.allocated[i]; ++i) {
            }
            if (i == max) {
                return (LongObjectCursor)this.done();
            }
            this.cursor.index = i;
            this.cursor.key = LongObjectOpenHashMap.this.keys[i];
            this.cursor.value = LongObjectOpenHashMap.this.values[i];
            return this.cursor;
        }
    }
}

