/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.AbstractIterator;
import com.carrotsearch.hppc.BitUtil;
import com.carrotsearch.hppc.IntDoubleMap;
import com.carrotsearch.hppc.Internals;
import com.carrotsearch.hppc.cursors.IntDoubleCursor;
import java.util.Iterator;

public class IntDoubleOpenHashMap
implements IntDoubleMap,
Cloneable {
    public int[] keys;
    public double[] values;
    public boolean[] allocated;
    public int assigned;
    public final float loadFactor;
    private int resizeThreshold;
    private int lastSlot;

    public IntDoubleOpenHashMap() {
        this(16);
    }

    public IntDoubleOpenHashMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public IntDoubleOpenHashMap(int initialCapacity, float loadFactor) {
        initialCapacity = Math.max(initialCapacity, 4);
        assert (initialCapacity > 0) : "Initial capacity must be between (0, 2147483647].";
        assert (loadFactor > 0.0f && loadFactor <= 1.0f) : "Load factor must be between (0, 1].";
        this.loadFactor = loadFactor;
        this.allocateBuffers(this.roundCapacity(initialCapacity));
    }

    private void allocateBuffers(int capacity) {
        this.keys = new int[capacity];
        this.values = new double[capacity];
        this.allocated = new boolean[capacity];
        this.resizeThreshold = (int)((float)capacity * this.loadFactor);
    }

    @Override
    public double get(int key) {
        int mask = this.allocated.length - 1;
        int slot = Internals.rehash(key) & mask;
        while (this.allocated[slot]) {
            if (key == this.keys[slot]) {
                return this.values[slot];
            }
            slot = slot + 1 & mask;
        }
        return 0.0;
    }

    @Override
    public boolean containsKey(int key) {
        int mask = this.allocated.length - 1;
        int slot = Internals.rehash(key) & mask;
        while (this.allocated[slot]) {
            if (key == this.keys[slot]) {
                this.lastSlot = slot;
                return true;
            }
            slot = slot + 1 & mask;
        }
        this.lastSlot = -1;
        return false;
    }

    protected int roundCapacity(int requestedCapacity) {
        if (requestedCapacity > 0x40000000) {
            return 0x40000000;
        }
        return Math.max(4, BitUtil.nextHighestPowerOfTwo(requestedCapacity));
    }

    @Override
    public int size() {
        return this.assigned;
    }

    public int hashCode() {
        int h = 0;
        for (IntDoubleCursor c : this) {
            h += Internals.rehash(c.key) + Internals.rehash(c.value);
        }
        return h;
    }

    public boolean equals(Object obj) {
        if (obj != null) {
            IntDoubleMap other;
            if (obj == this) {
                return true;
            }
            if (obj instanceof IntDoubleMap && (other = (IntDoubleMap)obj).size() == this.size()) {
                for (IntDoubleCursor c : this) {
                    double v;
                    if (other.containsKey(c.key) && c.value == (v = other.get(c.key))) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public Iterator<IntDoubleCursor> iterator() {
        return new EntryIterator();
    }

    public IntDoubleOpenHashMap clone() {
        try {
            IntDoubleOpenHashMap cloned = (IntDoubleOpenHashMap)super.clone();
            cloned.keys = (int[])this.keys.clone();
            cloned.values = (double[])this.values.clone();
            cloned.allocated = (boolean[])this.allocated.clone();
            return cloned;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("[");
        boolean first = true;
        for (IntDoubleCursor cursor : this) {
            if (!first) {
                buffer.append(", ");
            }
            buffer.append(cursor.key);
            buffer.append("=>");
            buffer.append(cursor.value);
            first = false;
        }
        buffer.append("]");
        return buffer.toString();
    }

    private final class EntryIterator
    extends AbstractIterator<IntDoubleCursor> {
        private final IntDoubleCursor cursor = new IntDoubleCursor();

        public EntryIterator() {
            this.cursor.index = -1;
        }

        @Override
        protected IntDoubleCursor fetch() {
            int i;
            int max = IntDoubleOpenHashMap.this.keys.length;
            for (i = this.cursor.index + 1; i < max && !IntDoubleOpenHashMap.this.allocated[i]; ++i) {
            }
            if (i == max) {
                return (IntDoubleCursor)this.done();
            }
            this.cursor.index = i;
            this.cursor.key = IntDoubleOpenHashMap.this.keys[i];
            this.cursor.value = IntDoubleOpenHashMap.this.values[i];
            return this.cursor;
        }
    }
}

