/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.AbstractIntCollection;
import com.carrotsearch.hppc.AbstractIterator;
import com.carrotsearch.hppc.ArraySizingStrategy;
import com.carrotsearch.hppc.BoundedProportionalArraySizingStrategy;
import com.carrotsearch.hppc.IntIndexedContainer;
import com.carrotsearch.hppc.Internals;
import com.carrotsearch.hppc.cursors.IntCursor;
import java.util.Arrays;
import java.util.Iterator;

public class IntArrayList
extends AbstractIntCollection
implements IntIndexedContainer,
Cloneable {
    private static final Object EMPTY = new int[0];
    public int[] buffer;
    public int elementsCount;
    protected final ArraySizingStrategy resizer;

    public IntArrayList() {
        this(5);
    }

    public IntArrayList(int initialCapacity) {
        this(initialCapacity, new BoundedProportionalArraySizingStrategy());
    }

    public IntArrayList(int initialCapacity, ArraySizingStrategy resizer) {
        assert (initialCapacity >= 0) : "initialCapacity must be >= 0: " + initialCapacity;
        assert (resizer != null);
        this.resizer = resizer;
        this.ensureBufferSpace(resizer.round(initialCapacity));
    }

    public void add(int e1) {
        this.ensureBufferSpace(1);
        this.buffer[this.elementsCount++] = e1;
    }

    @Override
    public final int get(int index) {
        assert (index >= 0 && index < this.size()) : "Index " + index + " out of bounds [" + 0 + ", " + this.size() + ").";
        return this.buffer[index];
    }

    @Override
    public final boolean contains(int e1) {
        return this.indexOf(e1) >= 0;
    }

    public final int indexOf(int e1) {
        for (int i = 0; i < this.elementsCount; ++i) {
            if (e1 != this.buffer[i]) continue;
            return i;
        }
        return -1;
    }

    protected final void ensureBufferSpace(int expectedAdditions) {
        int bufferLen;
        int n = bufferLen = this.buffer == null ? 0 : this.buffer.length;
        if (this.elementsCount + expectedAdditions >= bufferLen) {
            int newSize = this.resizer.grow(bufferLen, this.elementsCount, expectedAdditions);
            assert (newSize >= this.elementsCount + expectedAdditions) : "Resizer failed to return sensible new size: " + newSize + " <= " + (this.elementsCount + expectedAdditions);
            int[] newBuffer = new int[newSize];
            if (bufferLen > 0) {
                System.arraycopy(this.buffer, 0, newBuffer, 0, this.buffer.length);
            }
            this.buffer = newBuffer;
        }
    }

    @Override
    public final int size() {
        return this.elementsCount;
    }

    @Override
    public final int[] toArray() {
        return Arrays.copyOf(this.buffer, this.elementsCount);
    }

    public IntArrayList clone() {
        try {
            IntArrayList cloned = (IntArrayList)super.clone();
            cloned.buffer = (int[])this.buffer.clone();
            return cloned;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public int hashCode() {
        int h = 1;
        int max = this.elementsCount;
        for (int i = 0; i < max; ++i) {
            h = 31 * h + Internals.rehash(this.buffer[i]);
        }
        return h;
    }

    public boolean equals(Object obj) {
        if (obj != null) {
            if (obj instanceof IntArrayList) {
                IntArrayList other = (IntArrayList)obj;
                return other.size() == this.size() && this.rangeEquals(other.buffer, this.buffer, this.size());
            }
            if (obj instanceof IntIndexedContainer) {
                IntIndexedContainer other = (IntIndexedContainer)obj;
                return other.size() == this.size() && this.allIndexesEqual(this, other, this.size());
            }
        }
        return false;
    }

    private boolean rangeEquals(int[] b1, int[] b2, int length) {
        for (int i = 0; i < length; ++i) {
            if (b1[i] == b2[i]) continue;
            return false;
        }
        return true;
    }

    private boolean allIndexesEqual(IntIndexedContainer b1, IntIndexedContainer b2, int length) {
        for (int i = 0; i < length; ++i) {
            int o2;
            int o1 = b1.get(i);
            if (o1 == (o2 = b2.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public Iterator<IntCursor> iterator() {
        return new ValueIterator(this.buffer, this.size());
    }

    static final class ValueIterator
    extends AbstractIterator<IntCursor> {
        private final IntCursor cursor = new IntCursor();
        private final int[] buffer;
        private final int size;

        public ValueIterator(int[] buffer, int size) {
            this.cursor.index = -1;
            this.size = size;
            this.buffer = buffer;
        }

        @Override
        protected IntCursor fetch() {
            if (this.cursor.index + 1 == this.size) {
                return (IntCursor)this.done();
            }
            this.cursor.value = this.buffer[++this.cursor.index];
            return this.cursor;
        }
    }
}

