/*
 * Decompiled with CFR 0.152.
 */
package parquet.schema;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import parquet.io.InvalidRecordException;
import parquet.schema.IncompatibleSchemaModificationException;
import parquet.schema.OriginalType;
import parquet.schema.Type;
import parquet.schema.TypeConverter;
import parquet.schema.TypeVisitor;

public class GroupType
extends Type {
    private final List<Type> fields;
    private final Map<String, Integer> indexByName;

    public GroupType(Type.Repetition repetition, String name, List<Type> fields) {
        this(repetition, name, null, fields);
    }

    public GroupType(Type.Repetition repetition, String name, Type ... fields) {
        this(repetition, name, (OriginalType)null, fields);
    }

    public GroupType(Type.Repetition repetition, String name, OriginalType originalType, Type ... fields) {
        this(repetition, name, originalType, Arrays.asList(fields));
    }

    public GroupType(Type.Repetition repetition, String name, OriginalType originalType, List<Type> fields) {
        super(name, repetition, originalType);
        this.fields = fields;
        this.indexByName = new HashMap<String, Integer>();
        int i = 0;
        while (i < fields.size()) {
            this.indexByName.put(fields.get(i).getName(), i);
            ++i;
        }
    }

    public String getFieldName(int index) {
        return this.fields.get(index).getName();
    }

    public boolean containsField(String name) {
        return this.indexByName.containsKey(name);
    }

    public int getFieldIndex(String name) {
        if (!this.indexByName.containsKey(name)) {
            throw new InvalidRecordException(String.valueOf(name) + " not found in " + this);
        }
        return this.indexByName.get(name);
    }

    public List<Type> getFields() {
        return this.fields;
    }

    public int getFieldCount() {
        return this.fields.size();
    }

    @Override
    public boolean isPrimitive() {
        return false;
    }

    public Type getType(String fieldName) {
        return this.getType(this.getFieldIndex(fieldName));
    }

    public Type getType(int index) {
        return this.fields.get(index);
    }

    void membersDisplayString(StringBuilder sb, String indent) {
        for (Type field : this.fields) {
            field.writeToStringBuilder(sb, indent);
            if (field.isPrimitive()) {
                sb.append(";");
            }
            sb.append("\n");
        }
    }

    @Override
    public void writeToStringBuilder(StringBuilder sb, String indent) {
        sb.append(indent).append(this.getRepetition().name().toLowerCase()).append(" group ").append(this.getName()).append(this.getOriginalType() == null ? "" : " (" + (Object)((Object)this.getOriginalType()) + ")").append(" {\n");
        this.membersDisplayString(sb, String.valueOf(indent) + "  ");
        sb.append(indent).append("}");
    }

    @Override
    public void accept(TypeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    protected int typeHashCode() {
        int c = 17;
        c += 31 * this.getRepetition().hashCode();
        c += 31 * this.getName().hashCode();
        return c += 31 * this.getFields().hashCode();
    }

    @Override
    protected boolean typeEquals(Type other) {
        Type otherType = other;
        if (otherType.isPrimitive()) {
            return false;
        }
        GroupType groupType = otherType.asGroupType();
        return this.getRepetition() == groupType.getRepetition() && this.getName().equals(groupType.getName()) && this.getFields().equals(groupType.getFields());
    }

    @Override
    protected int getMaxRepetitionLevel(String[] path, int depth) {
        int myVal;
        int n = myVal = this.isRepetition(Type.Repetition.REPEATED) ? 1 : 0;
        if (depth == path.length) {
            return myVal;
        }
        return myVal + this.getType(path[depth]).getMaxRepetitionLevel(path, depth + 1);
    }

    @Override
    protected int getMaxDefinitionLevel(String[] path, int depth) {
        int myVal;
        int n = myVal = !this.isRepetition(Type.Repetition.REQUIRED) ? 1 : 0;
        if (depth == path.length) {
            return myVal;
        }
        return myVal + this.getType(path[depth]).getMaxDefinitionLevel(path, depth + 1);
    }

    @Override
    protected Type getType(String[] path, int depth) {
        if (depth == path.length) {
            return this;
        }
        return this.getType(path[depth]).getType(path, depth + 1);
    }

    @Override
    protected boolean containsPath(String[] path, int depth) {
        if (depth == path.length) {
            return false;
        }
        return this.containsField(path[depth]) && this.getType(path[depth]).containsPath(path, depth + 1);
    }

    @Override
    protected List<String[]> getPaths(int depth) {
        ArrayList<String[]> result = new ArrayList<String[]>();
        for (Type field : this.fields) {
            List<String[]> paths = field.getPaths(depth + 1);
            for (String[] path : paths) {
                path[depth] = field.getName();
                result.add(path);
            }
        }
        return result;
    }

    @Override
    void checkContains(Type subType) {
        super.checkContains(subType);
        this.checkGroupContains(subType);
    }

    void checkGroupContains(Type subType) {
        if (subType.isPrimitive()) {
            throw new InvalidRecordException(subType + " found: expected " + this);
        }
        List<Type> fields = subType.asGroupType().getFields();
        for (Type otherType : fields) {
            Type thisType = this.getType(otherType.getName());
            thisType.checkContains(otherType);
        }
    }

    @Override
    <T> T convert(List<GroupType> path, TypeConverter<T> converter) {
        ArrayList<GroupType> childrenPath = new ArrayList<GroupType>(path);
        childrenPath.add(this);
        List<T> children = this.convertChildren(childrenPath, converter);
        return converter.convertGroupType(path, this, children);
    }

    protected <T> List<T> convertChildren(List<GroupType> path, TypeConverter<T> converter) {
        ArrayList<T> children = new ArrayList<T>(this.fields.size());
        for (Type field : this.fields) {
            children.add(field.convert(path, converter));
        }
        return children;
    }

    @Override
    protected Type union(Type toMerge) {
        if (toMerge.isPrimitive()) {
            throw new IncompatibleSchemaModificationException("can not merge primitive type " + toMerge + " into group type " + this);
        }
        return new GroupType(toMerge.getRepetition(), this.getName(), this.mergeFields(toMerge.asGroupType()));
    }

    List<Type> mergeFields(GroupType toMerge) {
        ArrayList<Type> newFields = new ArrayList<Type>();
        for (Type type : this.getFields()) {
            Type merged;
            if (toMerge.containsField(type.getName())) {
                Type fieldToMerge = toMerge.getType(type.getName());
                if (fieldToMerge.getRepetition().isMoreRestrictiveThan(type.getRepetition())) {
                    throw new IncompatibleSchemaModificationException("repetition constraint is more restrictive: can not merge type " + fieldToMerge + " into " + type);
                }
                merged = type.union(fieldToMerge);
            } else {
                merged = type;
            }
            newFields.add(merged);
        }
        for (Type type : toMerge.getFields()) {
            if (this.containsField(type.getName())) continue;
            newFields.add(type);
        }
        return newFields;
    }
}

