/*
 * Decompiled with CFR 0.152.
 */
package parquet.column.values.plain;

import java.io.IOException;
import java.io.OutputStream;
import parquet.Log;
import parquet.bytes.ByteBufferAllocator;
import parquet.bytes.BytesInput;
import parquet.bytes.CapacityByteArrayOutputStream;
import parquet.bytes.LittleEndianDataOutputStream;
import parquet.column.Encoding;
import parquet.column.values.ValuesWriter;
import parquet.column.values.plain.PlainValuesWriter;
import parquet.io.ParquetEncodingException;
import parquet.io.api.Binary;

public class FixedLenByteArrayPlainValuesWriter
extends ValuesWriter {
    private static final Log LOG = Log.getLog(PlainValuesWriter.class);
    private CapacityByteArrayOutputStream arrayOut;
    private LittleEndianDataOutputStream out;
    private int length;
    private ByteBufferAllocator allocator;

    public FixedLenByteArrayPlainValuesWriter(int length, int initialSize, ByteBufferAllocator allocator) {
        this.length = length;
        this.allocator = allocator;
        this.arrayOut = new CapacityByteArrayOutputStream(initialSize, this.allocator);
        this.out = new LittleEndianDataOutputStream((OutputStream)this.arrayOut);
    }

    @Override
    public final void writeBytes(Binary v) {
        if (v.length() != this.length) {
            throw new IllegalArgumentException("Fixed Binary size " + v.length() + " does not match field type length " + this.length);
        }
        try {
            v.writeTo((OutputStream)this.out);
        }
        catch (IOException e) {
            throw new ParquetEncodingException("could not write fixed bytes", e);
        }
    }

    @Override
    public long getBufferedSize() {
        return this.arrayOut.size();
    }

    @Override
    public BytesInput getBytes() {
        try {
            this.out.flush();
        }
        catch (IOException e) {
            throw new ParquetEncodingException("could not write page", e);
        }
        if (Log.DEBUG) {
            LOG.debug((Object)("writing a buffer of size " + this.arrayOut.size()));
        }
        return BytesInput.from((CapacityByteArrayOutputStream)this.arrayOut);
    }

    @Override
    public void reset() {
        this.arrayOut.reset();
    }

    @Override
    public void close() {
        this.arrayOut.close();
    }

    @Override
    public long getAllocatedSize() {
        return this.arrayOut.getCapacity();
    }

    @Override
    public Encoding getEncoding() {
        return Encoding.PLAIN;
    }

    @Override
    public String memUsageString(String prefix) {
        return this.arrayOut.memUsageString(String.valueOf(prefix) + " PLAIN");
    }
}

