/*
 * Decompiled with CFR 0.152.
 */
package parquet.column.values.plain;

import java.io.IOException;
import java.nio.ByteBuffer;
import parquet.Log;
import parquet.column.values.ValuesReader;
import parquet.io.ParquetDecodingException;
import parquet.io.api.Binary;

public class FixedLenByteArrayPlainValuesReader
extends ValuesReader {
    private static final Log LOG = Log.getLog(FixedLenByteArrayPlainValuesReader.class);
    private ByteBuffer in;
    private int offset;
    private int length;

    public FixedLenByteArrayPlainValuesReader(int length) {
        this.length = length;
    }

    @Override
    public Binary readBytes() {
        try {
            int start = this.offset;
            this.offset = start + this.length;
            return Binary.fromByteBuffer(this.in, start, this.length);
        }
        catch (RuntimeException e) {
            throw new ParquetDecodingException("could not read bytes at offset " + this.offset, e);
        }
    }

    @Override
    public void skip() {
        this.offset += this.length;
    }

    @Override
    public void initFromPage(int valueCount, ByteBuffer in, int offset) throws IOException {
        if (Log.DEBUG) {
            LOG.debug((Object)("init from page at offset " + offset + " for length " + (in.limit() - offset)));
        }
        this.in = in;
        this.offset = offset;
    }
}

