/*
 * Decompiled with CFR 0.152.
 */
package parquet.column.values.deltastrings;

import parquet.bytes.ByteBufferAllocator;
import parquet.bytes.BytesInput;
import parquet.column.Encoding;
import parquet.column.values.ValuesWriter;
import parquet.column.values.delta.DeltaBinaryPackingValuesWriter;
import parquet.column.values.deltalengthbytearray.DeltaLengthByteArrayValuesWriter;
import parquet.io.api.Binary;

public class DeltaByteArrayWriter
extends ValuesWriter {
    private ValuesWriter prefixLengthWriter;
    private ValuesWriter suffixWriter;
    private byte[] previous;
    private ByteBufferAllocator allocator;

    public DeltaByteArrayWriter(int initialCapacity, ByteBufferAllocator allocator) {
        this.allocator = allocator;
        this.prefixLengthWriter = new DeltaBinaryPackingValuesWriter(128, 4, initialCapacity, this.allocator);
        this.suffixWriter = new DeltaLengthByteArrayValuesWriter(initialCapacity, this.allocator);
        this.previous = new byte[0];
    }

    @Override
    public long getBufferedSize() {
        return this.prefixLengthWriter.getBufferedSize() + this.suffixWriter.getBufferedSize();
    }

    @Override
    public BytesInput getBytes() {
        return BytesInput.concat((BytesInput[])new BytesInput[]{this.prefixLengthWriter.getBytes(), this.suffixWriter.getBytes()});
    }

    @Override
    public Encoding getEncoding() {
        return Encoding.DELTA_BYTE_ARRAY;
    }

    @Override
    public void reset() {
        this.prefixLengthWriter.reset();
        this.suffixWriter.reset();
    }

    @Override
    public void close() {
        this.prefixLengthWriter.close();
        this.suffixWriter.close();
    }

    @Override
    public long getAllocatedSize() {
        return this.prefixLengthWriter.getAllocatedSize() + this.suffixWriter.getAllocatedSize();
    }

    @Override
    public String memUsageString(String prefix) {
        prefix = this.prefixLengthWriter.memUsageString(prefix);
        return this.suffixWriter.memUsageString(String.valueOf(prefix) + "  DELTA_STRINGS");
    }

    @Override
    public void writeBytes(Binary v) {
        int i = 0;
        byte[] vb = v.getBytes();
        int length = this.previous.length < vb.length ? this.previous.length : vb.length;
        i = 0;
        while (i < length && this.previous[i] == vb[i]) {
            ++i;
        }
        this.prefixLengthWriter.writeInteger(i);
        this.suffixWriter.writeBytes(Binary.fromByteArray(vb, i, vb.length - i));
        this.previous = vb;
    }
}

