/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.config.impl;

import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigResolveOptions;
import com.typesafe.config.impl.AbstractConfigObject;
import com.typesafe.config.impl.AbstractConfigValue;
import com.typesafe.config.impl.MemoKey;
import com.typesafe.config.impl.Path;
import com.typesafe.config.impl.ResolveMemos;
import com.typesafe.config.impl.ResolveSource;
import com.typesafe.config.impl.ResolveStatus;
import com.typesafe.config.impl.SubstitutionExpression;
import java.util.ArrayList;
import java.util.List;

final class ResolveContext {
    private final ResolveSource source;
    private final ResolveMemos memos;
    private final ConfigResolveOptions options;
    private final Path restrictToChild;
    private final List<SubstitutionExpression> expressionTrace;

    ResolveContext(ResolveSource resolveSource, ResolveMemos resolveMemos, ConfigResolveOptions configResolveOptions, Path path, List<SubstitutionExpression> list) {
        this.source = resolveSource;
        this.memos = resolveMemos;
        this.options = configResolveOptions;
        this.restrictToChild = path;
        this.expressionTrace = list;
    }

    ResolveContext(AbstractConfigObject abstractConfigObject, ConfigResolveOptions configResolveOptions, Path path) {
        this(new ResolveSource(abstractConfigObject), new ResolveMemos(), configResolveOptions, path, new ArrayList<SubstitutionExpression>());
    }

    ResolveSource source() {
        return this.source;
    }

    ConfigResolveOptions options() {
        return this.options;
    }

    boolean isRestrictedToChild() {
        return this.restrictToChild != null;
    }

    Path restrictToChild() {
        return this.restrictToChild;
    }

    ResolveContext restrict(Path path) {
        if (path == this.restrictToChild) {
            return this;
        }
        return new ResolveContext(this.source, this.memos, this.options, path, this.expressionTrace);
    }

    ResolveContext unrestricted() {
        return this.restrict(null);
    }

    void trace(SubstitutionExpression substitutionExpression) {
        this.expressionTrace.add(substitutionExpression);
    }

    void untrace() {
        this.expressionTrace.remove(this.expressionTrace.size() - 1);
    }

    String traceString() {
        String string = ", ";
        StringBuilder stringBuilder = new StringBuilder();
        for (SubstitutionExpression substitutionExpression : this.expressionTrace) {
            stringBuilder.append(substitutionExpression.toString());
            stringBuilder.append(string);
        }
        if (stringBuilder.length() > 0) {
            stringBuilder.setLength(stringBuilder.length() - string.length());
        }
        return stringBuilder.toString();
    }

    AbstractConfigValue resolve(AbstractConfigValue abstractConfigValue) throws AbstractConfigValue.NotPossibleToResolve {
        MemoKey memoKey = new MemoKey(abstractConfigValue, null);
        MemoKey memoKey2 = null;
        AbstractConfigValue abstractConfigValue2 = this.memos.get(memoKey);
        if (abstractConfigValue2 == null && this.isRestrictedToChild()) {
            memoKey2 = new MemoKey(abstractConfigValue, this.restrictToChild());
            abstractConfigValue2 = this.memos.get(memoKey2);
        }
        if (abstractConfigValue2 != null) {
            return abstractConfigValue2;
        }
        AbstractConfigValue abstractConfigValue3 = this.source.resolveCheckingReplacement(this, abstractConfigValue);
        if (abstractConfigValue3 == null || abstractConfigValue3.resolveStatus() == ResolveStatus.RESOLVED) {
            this.memos.put(memoKey, abstractConfigValue3);
        } else if (this.isRestrictedToChild()) {
            if (memoKey2 == null) {
                throw new ConfigException.BugOrBroken("restrictedKey should not be null here");
            }
            this.memos.put(memoKey2, abstractConfigValue3);
        } else {
            throw new ConfigException.BugOrBroken("resolveSubstitutions() did not give us a resolved object");
        }
        return abstractConfigValue3;
    }

    static AbstractConfigValue resolve(AbstractConfigValue abstractConfigValue, AbstractConfigObject abstractConfigObject, ConfigResolveOptions configResolveOptions, Path path) {
        ResolveContext resolveContext = new ResolveContext(abstractConfigObject, configResolveOptions, null);
        try {
            return resolveContext.resolve(abstractConfigValue);
        }
        catch (AbstractConfigValue.NotPossibleToResolve notPossibleToResolve) {
            throw new ConfigException.BugOrBroken("NotPossibleToResolve was thrown from an outermost resolve", notPossibleToResolve);
        }
    }

    static AbstractConfigValue resolve(AbstractConfigValue abstractConfigValue, AbstractConfigObject abstractConfigObject, ConfigResolveOptions configResolveOptions) {
        return ResolveContext.resolve(abstractConfigValue, abstractConfigObject, configResolveOptions, null);
    }
}

