/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.common.types;

import 250.com.google.protobuf.MessageOrBuilder;
import 250.com.google.protobuf.TextFormat;
import org.apache.drill.common.types.TypeProtos;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Types {
    static final Logger logger = LoggerFactory.getLogger(Types.class);
    public static final TypeProtos.MajorType NULL = Types.required(TypeProtos.MinorType.NULL);
    public static final TypeProtos.MajorType LATE_BIND_TYPE = Types.optional(TypeProtos.MinorType.LATE);
    public static final TypeProtos.MajorType REQUIRED_BIT = Types.required(TypeProtos.MinorType.BIT);
    public static final TypeProtos.MajorType OPTIONAL_BIT = Types.optional(TypeProtos.MinorType.BIT);

    public static boolean isComplex(TypeProtos.MajorType type) {
        switch (type.getMinorType()) {
            case LIST: 
            case MAP: {
                return true;
            }
        }
        return false;
    }

    public static boolean isRepeated(TypeProtos.MajorType type) {
        return type.getMode() == TypeProtos.DataMode.REPEATED;
    }

    public static boolean isNumericType(TypeProtos.MajorType type) {
        if (type.getMode() == TypeProtos.DataMode.REPEATED) {
            return false;
        }
        switch (type.getMinorType()) {
            case BIGINT: 
            case DECIMAL38SPARSE: 
            case DECIMAL38DENSE: 
            case DECIMAL28SPARSE: 
            case DECIMAL28DENSE: 
            case DECIMAL18: 
            case DECIMAL9: 
            case FLOAT4: 
            case FLOAT8: 
            case INT: 
            case MONEY: 
            case SMALLINT: 
            case TINYINT: 
            case UINT1: 
            case UINT2: 
            case UINT4: 
            case UINT8: {
                return true;
            }
        }
        return false;
    }

    public static int getSqlType(TypeProtos.MajorType type) {
        if (type.getMode() == TypeProtos.DataMode.REPEATED) {
            return 2003;
        }
        switch (type.getMinorType()) {
            case BIGINT: {
                return -5;
            }
            case BIT: {
                return 16;
            }
            case DATE: {
                return 91;
            }
            case DECIMAL38SPARSE: 
            case DECIMAL38DENSE: 
            case DECIMAL28SPARSE: 
            case DECIMAL28DENSE: 
            case DECIMAL18: 
            case DECIMAL9: {
                return 3;
            }
            case FIXED16CHAR: {
                return -15;
            }
            case FIXEDBINARY: {
                return -2;
            }
            case FIXEDCHAR: {
                return -15;
            }
            case FLOAT4: {
                return 6;
            }
            case FLOAT8: {
                return 8;
            }
            case INT: {
                return 4;
            }
            case MAP: {
                return 2002;
            }
            case MONEY: {
                return 3;
            }
            case SMALLINT: 
            case NULL: 
            case INTERVAL: 
            case INTERVALYEAR: 
            case INTERVALDAY: 
            case LATE: {
                return 5;
            }
            case TIME: {
                return 92;
            }
            case TIMESTAMPTZ: 
            case TIMESTAMP: {
                return 93;
            }
            case TIMETZ: {
                return 91;
            }
            case TINYINT: {
                return -6;
            }
            case UINT1: {
                return -6;
            }
            case UINT2: {
                return 5;
            }
            case UINT4: {
                return 4;
            }
            case UINT8: {
                return -5;
            }
            case VAR16CHAR: {
                return -9;
            }
            case VARBINARY: {
                return -3;
            }
            case VARCHAR: {
                return -9;
            }
        }
        throw new UnsupportedOperationException();
    }

    public static boolean isUnSigned(TypeProtos.MajorType type) {
        switch (type.getMinorType()) {
            case UINT1: 
            case UINT2: 
            case UINT4: 
            case UINT8: {
                return true;
            }
        }
        return false;
    }

    public static boolean usesHolderForGet(TypeProtos.MajorType type) {
        if (type.getMode() == TypeProtos.DataMode.REPEATED) {
            return true;
        }
        switch (type.getMinorType()) {
            case BIGINT: 
            case FLOAT4: 
            case FLOAT8: 
            case INT: 
            case MONEY: 
            case SMALLINT: 
            case TINYINT: 
            case UINT1: 
            case UINT2: 
            case UINT4: 
            case UINT8: 
            case DATE: 
            case INTERVALYEAR: 
            case TIME: 
            case TIMESTAMP: {
                return false;
            }
        }
        return true;
    }

    public static boolean isFixedWidthType(TypeProtos.MajorType type) {
        switch (type.getMinorType()) {
            case VAR16CHAR: 
            case VARBINARY: 
            case VARCHAR: {
                return false;
            }
        }
        return true;
    }

    public static boolean isStringScalarType(TypeProtos.MajorType type) {
        if (type.getMode() == TypeProtos.DataMode.REPEATED) {
            return false;
        }
        switch (type.getMinorType()) {
            case FIXED16CHAR: 
            case FIXEDCHAR: 
            case VAR16CHAR: 
            case VARCHAR: {
                return true;
            }
        }
        return false;
    }

    public static boolean isBytesScalarType(TypeProtos.MajorType type) {
        if (type.getMode() == TypeProtos.DataMode.REPEATED) {
            return false;
        }
        switch (type.getMinorType()) {
            case FIXEDBINARY: 
            case VARBINARY: {
                return true;
            }
        }
        return false;
    }

    public static Comparability getComparability(TypeProtos.MajorType type) {
        if (type.getMode() == TypeProtos.DataMode.REPEATED) {
            return Comparability.NONE;
        }
        if (type.getMinorType() == TypeProtos.MinorType.LATE) {
            return Comparability.UNKNOWN;
        }
        switch (type.getMinorType()) {
            case LATE: {
                return Comparability.UNKNOWN;
            }
            case MAP: {
                return Comparability.NONE;
            }
            case BIT: {
                return Comparability.EQUAL;
            }
        }
        return Comparability.ORDERED;
    }

    public static boolean softEquals(TypeProtos.MajorType a, TypeProtos.MajorType b, boolean allowNullSwap) {
        if (!(a.getMinorType() == b.getMinorType() || a.getMinorType() == TypeProtos.MinorType.VARBINARY && b.getMinorType() == TypeProtos.MinorType.VARCHAR || b.getMinorType() == TypeProtos.MinorType.VARBINARY && a.getMinorType() == TypeProtos.MinorType.VARCHAR)) {
            return false;
        }
        if (allowNullSwap) {
            switch (a.getMode()) {
                case OPTIONAL: 
                case REQUIRED: {
                    switch (b.getMode()) {
                        case OPTIONAL: 
                        case REQUIRED: {
                            return true;
                        }
                    }
                }
            }
        }
        return a.getMode() == b.getMode();
    }

    public static boolean isLateBind(TypeProtos.MajorType type) {
        return type.getMinorType() == TypeProtos.MinorType.LATE;
    }

    public static TypeProtos.MajorType withMode(TypeProtos.MinorType type, TypeProtos.DataMode mode) {
        return TypeProtos.MajorType.newBuilder().setMode(mode).setMinorType(type).build();
    }

    public static TypeProtos.MajorType withScaleAndPrecision(TypeProtos.MinorType type, TypeProtos.DataMode mode, int scale, int precision) {
        return TypeProtos.MajorType.newBuilder().setMinorType(type).setMode(mode).setScale(scale).setPrecision(precision).build();
    }

    public static TypeProtos.MajorType required(TypeProtos.MinorType type) {
        return TypeProtos.MajorType.newBuilder().setMode(TypeProtos.DataMode.REQUIRED).setMinorType(type).build();
    }

    public static TypeProtos.MajorType repeated(TypeProtos.MinorType type) {
        return TypeProtos.MajorType.newBuilder().setMode(TypeProtos.DataMode.REPEATED).setMinorType(type).build();
    }

    public static TypeProtos.MajorType optional(TypeProtos.MinorType type) {
        return TypeProtos.MajorType.newBuilder().setMode(TypeProtos.DataMode.OPTIONAL).setMinorType(type).build();
    }

    public static TypeProtos.MajorType overrideMinorType(TypeProtos.MajorType originalMajorType, TypeProtos.MinorType overrideMinorType) {
        switch (originalMajorType.getMode()) {
            case REPEATED: {
                return Types.repeated(overrideMinorType);
            }
            case OPTIONAL: {
                return Types.optional(overrideMinorType);
            }
            case REQUIRED: {
                return Types.required(overrideMinorType);
            }
        }
        throw new UnsupportedOperationException();
    }

    public static TypeProtos.MajorType overrideMode(TypeProtos.MajorType originalMajorType, TypeProtos.DataMode overrideMode) {
        return Types.withScaleAndPrecision(originalMajorType.getMinorType(), overrideMode, originalMajorType.getScale(), originalMajorType.getPrecision());
    }

    public static TypeProtos.MajorType getMajorTypeFromName(String typeName) {
        return Types.getMajorTypeFromName(typeName, TypeProtos.DataMode.REQUIRED);
    }

    public static TypeProtos.MajorType getMajorTypeFromName(String typeName, TypeProtos.DataMode mode) {
        switch (typeName) {
            case "bool": 
            case "boolean": {
                return Types.withMode(TypeProtos.MinorType.BIT, mode);
            }
            case "tinyint": {
                return Types.withMode(TypeProtos.MinorType.TINYINT, mode);
            }
            case "uint1": {
                return Types.withMode(TypeProtos.MinorType.UINT1, mode);
            }
            case "smallint": {
                return Types.withMode(TypeProtos.MinorType.SMALLINT, mode);
            }
            case "uint2": {
                return Types.withMode(TypeProtos.MinorType.UINT2, mode);
            }
            case "int": {
                return Types.withMode(TypeProtos.MinorType.INT, mode);
            }
            case "uint4": {
                return Types.withMode(TypeProtos.MinorType.UINT4, mode);
            }
            case "bigint": {
                return Types.withMode(TypeProtos.MinorType.BIGINT, mode);
            }
            case "uint8": {
                return Types.withMode(TypeProtos.MinorType.UINT8, mode);
            }
            case "float": {
                return Types.withMode(TypeProtos.MinorType.FLOAT4, mode);
            }
            case "double": {
                return Types.withMode(TypeProtos.MinorType.FLOAT8, mode);
            }
            case "decimal": {
                return Types.withMode(TypeProtos.MinorType.DECIMAL38SPARSE, mode);
            }
            case "utf8": 
            case "varchar": {
                return Types.withMode(TypeProtos.MinorType.VARCHAR, mode);
            }
            case "utf16": 
            case "string": 
            case "var16char": {
                return Types.withMode(TypeProtos.MinorType.VAR16CHAR, mode);
            }
            case "date": {
                return Types.withMode(TypeProtos.MinorType.DATE, mode);
            }
            case "time": {
                return Types.withMode(TypeProtos.MinorType.TIME, mode);
            }
            case "binary": {
                return Types.withMode(TypeProtos.MinorType.VARBINARY, mode);
            }
            case "json": {
                return Types.withMode(TypeProtos.MinorType.LATE, mode);
            }
        }
        throw new UnsupportedOperationException("Could not determine type: " + typeName);
    }

    public static String toString(TypeProtos.MajorType type) {
        return type != null ? "MajorType[" + TextFormat.shortDebugString((MessageOrBuilder)type) + "]" : "null";
    }

    public static enum Comparability {
        UNKNOWN,
        NONE,
        EQUAL,
        ORDERED;

    }
}

