/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.common.logical.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.collect.Iterators;
import java.util.Iterator;
import org.apache.drill.common.expression.FieldReference;
import org.apache.drill.common.logical.data.LogicalOperator;
import org.apache.drill.common.logical.data.SingleInputOperator;
import org.apache.drill.common.logical.data.visitors.LogicalVisitor;

@JsonTypeName(value="windowframe")
public class WindowFrame
extends SingleInputOperator {
    private final FieldReference within;
    private final FrameRef frame;
    private final long start;
    private final long end;

    @JsonCreator
    public WindowFrame(@JsonProperty(value="within") FieldReference within, @JsonProperty(value="ref") FrameRef frame, @JsonProperty(value="start") Long start, @JsonProperty(value="end") Long end) {
        this.within = within;
        this.frame = frame;
        this.start = start == null ? Long.MIN_VALUE : start;
        this.end = end == null ? Long.MIN_VALUE : end;
    }

    @JsonProperty(value="ref")
    public FrameRef getFrame() {
        return this.frame;
    }

    public FieldReference getWithin() {
        return this.within;
    }

    public long getStart() {
        return this.start;
    }

    public long getEnd() {
        return this.end;
    }

    @Override
    public <T, X, E extends Throwable> T accept(LogicalVisitor<T, X, E> logicalVisitor, X value) throws E {
        return logicalVisitor.visitWindowFrame(this, value);
    }

    @Override
    public Iterator<LogicalOperator> iterator() {
        return Iterators.singletonIterator((Object)this.getInput());
    }

    public static class FrameRef {
        private final FieldReference segment;
        private final FieldReference position;

        @JsonCreator
        public FrameRef(@JsonProperty(value="segment") FieldReference segment, @JsonProperty(value="position") FieldReference position) {
            this.segment = segment;
            this.position = position;
        }

        public FieldReference getSegment() {
            return this.segment;
        }

        public FieldReference getPosition() {
            return this.position;
        }
    }
}

