/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.common.expression;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.apache.drill.common.config.DrillConfig;
import org.apache.drill.common.expression.ExpressionPosition;
import org.apache.drill.common.expression.ExpressionStringBuilder;
import org.apache.drill.common.expression.LogicalExpression;
import org.apache.drill.common.expression.LogicalExpressionBase;
import org.apache.drill.common.expression.PathSegment;
import org.apache.drill.common.expression.parser.ExprLexer;
import org.apache.drill.common.expression.parser.ExprParser;
import org.apache.drill.common.expression.visitors.ExprVisitor;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.common.types.Types;
import org.apache.drill.exec.proto.UserBitShared;

public class SchemaPath
extends LogicalExpressionBase {
    private final PathSegment.NameSegment rootSegment;

    public static SchemaPath getSimplePath(String name) {
        return SchemaPath.getCompoundPath(name);
    }

    public static SchemaPath getCompoundPath(String ... strings) {
        List<String> paths = Arrays.asList(strings);
        Collections.reverse(paths);
        PathSegment.NameSegment s = null;
        for (String p : paths) {
            s = new PathSegment.NameSegment(p, s);
        }
        return new SchemaPath(s);
    }

    public PathSegment getLastSegment() {
        PathSegment s = this.rootSegment;
        while (s.getChild() != null) {
            s = s.getChild();
        }
        return s;
    }

    @Deprecated
    public SchemaPath(String simpleName, ExpressionPosition pos) {
        super(pos);
        this.rootSegment = new PathSegment.NameSegment(simpleName);
        if (simpleName.contains(".")) {
            throw new IllegalStateException("This is deprecated and only supports simpe paths.");
        }
    }

    public UserBitShared.NamePart getAsNamePart() {
        return SchemaPath.getNamePart(this.rootSegment);
    }

    private static UserBitShared.NamePart getNamePart(PathSegment s) {
        if (s == null) {
            return null;
        }
        UserBitShared.NamePart.Builder b = UserBitShared.NamePart.newBuilder();
        if (s.getChild() != null) {
            b.setChild(SchemaPath.getNamePart(s.getChild()));
        }
        if (s.isArray()) {
            if (s.getArraySegment().hasIndex()) {
                throw new IllegalStateException("You cannot convert a indexed schema path to a NamePart.  NameParts can only reference Vectors, not individual records or values.");
            }
            b.setType(UserBitShared.NamePart.Type.ARRAY);
        } else {
            b.setType(UserBitShared.NamePart.Type.NAME);
            b.setName(s.getNameSegment().getPath());
        }
        return b.build();
    }

    private static PathSegment getPathSegment(UserBitShared.NamePart n) {
        PathSegment child;
        PathSegment pathSegment = child = n.hasChild() ? SchemaPath.getPathSegment(n.getChild()) : null;
        if (n.getType() == UserBitShared.NamePart.Type.ARRAY) {
            return new PathSegment.ArraySegment(child);
        }
        return new PathSegment.NameSegment(n.getName(), child);
    }

    public static SchemaPath create(UserBitShared.NamePart namePart) {
        Preconditions.checkArgument((namePart.getType() == UserBitShared.NamePart.Type.NAME ? 1 : 0) != 0);
        return new SchemaPath((PathSegment.NameSegment)SchemaPath.getPathSegment(namePart));
    }

    public boolean isSimplePath() {
        for (PathSegment seg = this.rootSegment; seg != null; seg = seg.getChild()) {
            if (!((PathSegment)seg).isArray() || seg.isLastPath()) continue;
            return false;
        }
        return true;
    }

    public SchemaPath(SchemaPath path) {
        super(path.getPosition());
        this.rootSegment = path.rootSegment;
    }

    public SchemaPath(PathSegment.NameSegment rootSegment) {
        super(ExpressionPosition.UNKNOWN);
        this.rootSegment = rootSegment;
    }

    public SchemaPath(PathSegment.NameSegment rootSegment, ExpressionPosition pos) {
        super(pos);
        this.rootSegment = rootSegment;
    }

    @Override
    public <T, V, E extends Exception> T accept(ExprVisitor<T, V, E> visitor, V value) throws E {
        return visitor.visitSchemaPath(this, value);
    }

    public SchemaPath getChild(String childPath) {
        PathSegment.NameSegment newRoot = this.rootSegment.cloneWithNewChild(new PathSegment.NameSegment(childPath));
        return new SchemaPath(newRoot);
    }

    public SchemaPath getUnindexedArrayChild() {
        PathSegment.NameSegment newRoot = this.rootSegment.cloneWithNewChild(new PathSegment.ArraySegment(null));
        return new SchemaPath(newRoot);
    }

    public SchemaPath getChild(int index) {
        PathSegment.NameSegment newRoot = this.rootSegment.cloneWithNewChild(new PathSegment.ArraySegment(index));
        return new SchemaPath(newRoot);
    }

    public PathSegment.NameSegment getRootSegment() {
        return this.rootSegment;
    }

    @Override
    public TypeProtos.MajorType getMajorType() {
        return Types.LATE_BIND_TYPE;
    }

    public int hashCode() {
        return this.rootSegment == null ? 0 : this.rootSegment.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SchemaPath)) {
            return false;
        }
        SchemaPath other = (SchemaPath)obj;
        if (this.rootSegment == null) {
            return other.rootSegment == null;
        }
        return this.rootSegment.equals(other.rootSegment);
    }

    public boolean contains(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SchemaPath)) {
            return false;
        }
        SchemaPath other = (SchemaPath)obj;
        if (this.rootSegment == null) {
            return true;
        }
        return this.rootSegment.contains(other.rootSegment);
    }

    @Override
    public Iterator<LogicalExpression> iterator() {
        return Iterators.emptyIterator();
    }

    public String toString() {
        String expr = ExpressionStringBuilder.toString(this);
        return "SchemaPath [" + expr + "]";
    }

    public String toExpr() {
        return ExpressionStringBuilder.toString(this);
    }

    public String getAsUnescapedPath() {
        StringBuilder sb = new StringBuilder();
        PathSegment seg = this.getRootSegment();
        if (seg.isArray()) {
            throw new IllegalStateException("Drill doesn't currently support top level arrays");
        }
        sb.append(seg.getNameSegment().getPath());
        while ((seg = seg.getChild()) != null) {
            if (seg.isNamed()) {
                sb.append('.');
                sb.append(seg.getNameSegment().getPath());
                continue;
            }
            sb.append('[');
            sb.append(seg.getArraySegment().getIndex());
            sb.append(']');
        }
        return sb.toString();
    }

    public static class De
    extends StdDeserializer<SchemaPath> {
        DrillConfig config;

        public De(DrillConfig config) {
            super(LogicalExpression.class);
            this.config = config;
        }

        public SchemaPath deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            String expr = jp.getText();
            if (expr == null || expr.isEmpty()) {
                return null;
            }
            try {
                ExprLexer lexer = new ExprLexer((CharStream)new ANTLRStringStream(expr));
                CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
                ExprParser parser = new ExprParser((TokenStream)tokens);
                ExprParser.parse_return ret = parser.parse();
                if (ret.e instanceof SchemaPath) {
                    return (SchemaPath)ret.e;
                }
                throw new IllegalStateException("Schema path is not a valid format.");
            }
            catch (RecognitionException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

