/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.common;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.apache.drill.common.config.DrillConfig;
import org.apache.drill.common.exceptions.LogicalPlanParsingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonSerialize(using=Se.class)
@JsonDeserialize(using=De.class)
public class JSONOptions {
    static final Logger logger = LoggerFactory.getLogger(JSONOptions.class);
    private JsonNode root;
    private JsonLocation location;
    private Object opaque;

    public JSONOptions(Object opaque) {
        this.opaque = opaque;
    }

    public JSONOptions(JsonNode n, JsonLocation location) {
        this.root = n;
        this.location = location;
    }

    public <T> T getWith(DrillConfig config, Class<T> c) {
        try {
            if (this.opaque != null) {
                if (this.opaque.getClass().equals(c)) {
                    return (T)this.opaque;
                }
                throw new IllegalArgumentException(String.format("Attmpted to retrieve a option with type of %s.  However, the JSON options carried an opaque value of type %s.", c.getName(), this.opaque.getClass().getName()));
            }
            return (T)config.getMapper().treeToValue((TreeNode)this.root, c);
        }
        catch (JsonProcessingException e) {
            throw new LogicalPlanParsingException(String.format("Failure while trying to convert late bound json options to type of %s. Reference was originally located at line %d, column %d.", c.getCanonicalName(), this.location.getLineNr(), this.location.getColumnNr()), e);
        }
    }

    public <T> T getListWith(DrillConfig config, TypeReference<T> t) throws IOException {
        return this.getListWith(config.getMapper(), t);
    }

    public <T> T getListWith(ObjectMapper mapper, TypeReference<T> t) throws IOException {
        if (this.opaque != null) {
            Type c = t.getType();
            if (c instanceof ParameterizedType) {
                c = ((ParameterizedType)c).getRawType();
            }
            if (c.equals(this.opaque.getClass())) {
                return (T)this.opaque;
            }
            throw new IOException(String.format("Attmpted to retrieve a list with type of %s.  However, the JSON options carried an opaque value of type %s.", t.getType(), this.opaque.getClass().getName()));
        }
        if (this.root == null) {
            return null;
        }
        return (T)mapper.treeAsTokens((TreeNode)this.root).readValueAs(t);
    }

    public JsonNode path(String name) {
        return this.root.path(name);
    }

    public JsonNode getRoot() {
        return this.root;
    }

    public static class Se
    extends StdSerializer<JSONOptions> {
        public Se() {
            super(JSONOptions.class);
        }

        public void serialize(JSONOptions value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
            if (value.opaque != null) {
                jgen.writeObject(value.opaque);
            } else {
                jgen.writeTree((TreeNode)value.root);
            }
        }
    }

    public static class De
    extends StdDeserializer<JSONOptions> {
        public De() {
            super(JSONOptions.class);
            logger.debug("Creating Deserializer.");
        }

        public JSONOptions deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            JsonLocation l = jp.getTokenLocation();
            TreeNode n = jp.readValueAsTree();
            if (n instanceof JsonNode) {
                return new JSONOptions((JsonNode)n, l);
            }
            throw new IllegalArgumentException(String.format("Received something other than a JsonNode %s", n));
        }
    }
}

