/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.hbase;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hive.hbase.LazyHBaseRow;
import org.apache.hadoop.hive.serde2.AbstractSerDe;
import org.apache.hadoop.hive.serde2.ByteStream;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.SerDeStats;
import org.apache.hadoop.hive.serde2.SerDeUtils;
import org.apache.hadoop.hive.serde2.lazy.LazyFactory;
import org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe;
import org.apache.hadoop.hive.serde2.lazy.LazyUtils;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.LazySimpleStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.MapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.typeinfo.MapTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;

public class HBaseSerDe
extends AbstractSerDe {
    public static final String HBASE_COLUMNS_MAPPING = "hbase.columns.mapping";
    public static final String HBASE_TABLE_NAME = "hbase.table.name";
    public static final String HBASE_TABLE_DEFAULT_STORAGE_TYPE = "hbase.table.default.storage.type";
    public static final String HBASE_KEY_COL = ":key";
    public static final String HBASE_PUT_TIMESTAMP = "hbase.put.timestamp";
    public static final String HBASE_SCAN_CACHE = "hbase.scan.cache";
    public static final String HBASE_SCAN_CACHEBLOCKS = "hbase.scan.cacheblock";
    public static final String HBASE_SCAN_BATCH = "hbase.scan.batch";
    public static final String HBASE_COLUMNS_REGEX_MATCHING = "hbase.columns.mapping.regex.matching";
    public static final Log LOG = LogFactory.getLog(HBaseSerDe.class);
    private ObjectInspector cachedObjectInspector;
    private String hbaseColumnsMapping;
    private boolean doColumnRegexMatching;
    private List<ColumnMapping> columnsMapping;
    private LazySimpleSerDe.SerDeParameters serdeParams;
    private boolean useJSONSerialize;
    private LazyHBaseRow cachedHBaseRow;
    private final ByteStream.Output serializeStream = new ByteStream.Output();
    private int iKey;
    private long putTimestamp;
    private byte[] separators;
    private boolean escaped;
    private byte escapeChar;
    private boolean[] needsEscape;

    public String toString() {
        return ((Object)((Object)this)).getClass().toString() + "[" + this.hbaseColumnsMapping + ":" + ((StructTypeInfo)this.serdeParams.getRowTypeInfo()).getAllStructFieldNames() + ":" + ((StructTypeInfo)this.serdeParams.getRowTypeInfo()).getAllStructFieldTypeInfos() + "]";
    }

    public void initialize(Configuration conf, Properties tbl) throws SerDeException {
        this.initHBaseSerDeParameters(conf, tbl, ((Object)((Object)this)).getClass().getName());
        this.cachedObjectInspector = LazyFactory.createLazyStructInspector((List)this.serdeParams.getColumnNames(), (List)this.serdeParams.getColumnTypes(), (byte[])this.serdeParams.getSeparators(), (Text)this.serdeParams.getNullSequence(), (boolean)this.serdeParams.isLastColumnTakesRest(), (boolean)this.serdeParams.isEscaped(), (byte)this.serdeParams.getEscapeChar());
        this.cachedHBaseRow = new LazyHBaseRow((LazySimpleStructObjectInspector)this.cachedObjectInspector);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("HBaseSerDe initialized with : columnNames = " + this.serdeParams.getColumnNames() + " columnTypes = " + this.serdeParams.getColumnTypes() + " hbaseColumnMapping = " + this.hbaseColumnsMapping));
        }
    }

    public static List<ColumnMapping> parseColumnsMapping(String columnsMappingSpec) throws SerDeException {
        return HBaseSerDe.parseColumnsMapping(columnsMappingSpec, true);
    }

    public static List<ColumnMapping> parseColumnsMapping(String columnsMappingSpec, boolean doColumnRegexMatching) throws SerDeException {
        if (columnsMappingSpec == null) {
            throw new SerDeException("Error: hbase.columns.mapping missing for this HBase table.");
        }
        if (columnsMappingSpec.equals("") || columnsMappingSpec.equals(HBASE_KEY_COL)) {
            throw new SerDeException("Error: hbase.columns.mapping specifies only the HBase table row key. A valid Hive-HBase table must specify at least one additional column.");
        }
        int rowKeyIndex = -1;
        ArrayList<ColumnMapping> columnsMapping = new ArrayList<ColumnMapping>();
        String[] columnSpecs = columnsMappingSpec.split(",");
        ColumnMapping columnMapping = null;
        for (int i = 0; i < columnSpecs.length; ++i) {
            String mappingSpec = columnSpecs[i].trim();
            String[] mapInfo = mappingSpec.split("#");
            String colInfo = mapInfo[0];
            int idxFirst = colInfo.indexOf(":");
            int idxLast = colInfo.lastIndexOf(":");
            if (idxFirst < 0 || idxFirst != idxLast) {
                throw new SerDeException("Error: the HBase columns mapping contains a badly formed column family, column qualifier specification.");
            }
            columnMapping = new ColumnMapping();
            if (colInfo.equals(HBASE_KEY_COL)) {
                rowKeyIndex = i;
                columnMapping.familyName = colInfo;
                columnMapping.familyNameBytes = Bytes.toBytes((String)colInfo);
                columnMapping.qualifierName = null;
                columnMapping.qualifierNameBytes = null;
                columnMapping.hbaseRowKey = true;
            } else {
                String[] parts = colInfo.split(":");
                assert (parts.length > 0 && parts.length <= 2);
                columnMapping.familyName = parts[0];
                columnMapping.familyNameBytes = Bytes.toBytes((String)parts[0]);
                columnMapping.hbaseRowKey = false;
                if (parts.length == 2) {
                    if (doColumnRegexMatching && parts[1].endsWith(".*")) {
                        columnMapping.qualifierPrefix = parts[1].substring(0, parts[1].length() - 2);
                        columnMapping.qualifierPrefixBytes = Bytes.toBytes((String)columnMapping.qualifierPrefix);
                        columnMapping.qualifierName = null;
                        columnMapping.qualifierNameBytes = null;
                    } else {
                        columnMapping.qualifierName = parts[1];
                        columnMapping.qualifierNameBytes = Bytes.toBytes((String)parts[1]);
                    }
                } else {
                    columnMapping.qualifierName = null;
                    columnMapping.qualifierNameBytes = null;
                }
            }
            columnMapping.mappingSpec = mappingSpec;
            columnsMapping.add(columnMapping);
        }
        if (rowKeyIndex == -1) {
            columnMapping = new ColumnMapping();
            columnMapping.familyName = HBASE_KEY_COL;
            columnMapping.familyNameBytes = Bytes.toBytes((String)HBASE_KEY_COL);
            columnMapping.qualifierName = null;
            columnMapping.qualifierNameBytes = null;
            columnMapping.hbaseRowKey = true;
            columnMapping.mappingSpec = HBASE_KEY_COL;
            columnsMapping.add(0, columnMapping);
        }
        return columnsMapping;
    }

    private void parseColumnStorageTypes(String hbaseTableDefaultStorageType) throws SerDeException {
        boolean tableBinaryStorage = false;
        if (hbaseTableDefaultStorageType != null && !"".equals(hbaseTableDefaultStorageType)) {
            if (hbaseTableDefaultStorageType.equals("binary")) {
                tableBinaryStorage = true;
            } else if (!hbaseTableDefaultStorageType.equals("string")) {
                throw new SerDeException("Error: hbase.table.default.storage.type parameter must be specified as 'string' or 'binary'; '" + hbaseTableDefaultStorageType + "' is not a valid specification for this table/serde property.");
            }
        }
        List columnTypes = this.serdeParams.getColumnTypes();
        for (int i = 0; i < this.columnsMapping.size(); ++i) {
            ColumnMapping colMap = this.columnsMapping.get(i);
            TypeInfo colType = (TypeInfo)columnTypes.get(i);
            String mappingSpec = colMap.mappingSpec;
            String[] mapInfo = mappingSpec.split("#");
            String[] storageInfo = null;
            if (mapInfo.length == 2) {
                storageInfo = mapInfo[1].split(":");
            }
            if (storageInfo == null) {
                if (colType.getCategory() == ObjectInspector.Category.PRIMITIVE) {
                    if (!colType.getTypeName().equals("string")) {
                        colMap.binaryStorage.add(tableBinaryStorage);
                        continue;
                    }
                    colMap.binaryStorage.add(false);
                    continue;
                }
                if (colType.getCategory() == ObjectInspector.Category.MAP) {
                    TypeInfo keyTypeInfo = ((MapTypeInfo)colType).getMapKeyTypeInfo();
                    TypeInfo valueTypeInfo = ((MapTypeInfo)colType).getMapValueTypeInfo();
                    if (keyTypeInfo.getCategory() == ObjectInspector.Category.PRIMITIVE && !keyTypeInfo.getTypeName().equals("string")) {
                        colMap.binaryStorage.add(tableBinaryStorage);
                    } else {
                        colMap.binaryStorage.add(false);
                    }
                    if (valueTypeInfo.getCategory() == ObjectInspector.Category.PRIMITIVE && !valueTypeInfo.getTypeName().equals("string")) {
                        colMap.binaryStorage.add(tableBinaryStorage);
                        continue;
                    }
                    colMap.binaryStorage.add(false);
                    continue;
                }
                colMap.binaryStorage.add(false);
                continue;
            }
            if (storageInfo.length == 1) {
                String storageOption = storageInfo[0];
                if (colType.getCategory() == ObjectInspector.Category.MAP || !storageOption.equals("-") && !"string".startsWith(storageOption) && !"binary".startsWith(storageOption)) {
                    throw new SerDeException("Error: A column storage specification is one of the following: '-', a prefix of 'string', or a prefix of 'binary'. " + storageOption + " is not a valid storage option specification for " + (String)this.serdeParams.getColumnNames().get(i));
                }
                if (colType.getCategory() == ObjectInspector.Category.PRIMITIVE && !colType.getTypeName().equals("string")) {
                    if ("-".equals(storageOption)) {
                        colMap.binaryStorage.add(tableBinaryStorage);
                        continue;
                    }
                    if ("binary".startsWith(storageOption)) {
                        colMap.binaryStorage.add(true);
                        continue;
                    }
                    colMap.binaryStorage.add(false);
                    continue;
                }
                colMap.binaryStorage.add(false);
                continue;
            }
            if (storageInfo.length == 2) {
                String keyStorage = storageInfo[0];
                String valStorage = storageInfo[1];
                if (colType.getCategory() != ObjectInspector.Category.MAP || !keyStorage.equals("-") && !"string".startsWith(keyStorage) && !"binary".startsWith(keyStorage) || !valStorage.equals("-") && !"string".startsWith(valStorage) && !"binary".startsWith(valStorage)) {
                    throw new SerDeException("Error: To specify a valid column storage type for a Map column, use any two specifiers from '-', a prefix of 'string',  and a prefix of 'binary' separated by a ':'. Valid examples are '-:-', 's:b', etc. They specify the storage type for the key and value parts of the Map<?,?> respectively. Invalid storage specification for column " + (String)this.serdeParams.getColumnNames().get(i) + "; " + storageInfo[0] + ":" + storageInfo[1]);
                }
                TypeInfo keyTypeInfo = ((MapTypeInfo)colType).getMapKeyTypeInfo();
                TypeInfo valueTypeInfo = ((MapTypeInfo)colType).getMapValueTypeInfo();
                if (keyTypeInfo.getCategory() == ObjectInspector.Category.PRIMITIVE && !keyTypeInfo.getTypeName().equals("string")) {
                    if (keyStorage.equals("-")) {
                        colMap.binaryStorage.add(tableBinaryStorage);
                    } else if ("binary".startsWith(keyStorage)) {
                        colMap.binaryStorage.add(true);
                    } else {
                        colMap.binaryStorage.add(false);
                    }
                } else {
                    colMap.binaryStorage.add(false);
                }
                if (valueTypeInfo.getCategory() == ObjectInspector.Category.PRIMITIVE && !valueTypeInfo.getTypeName().equals("string")) {
                    if (valStorage.equals("-")) {
                        colMap.binaryStorage.add(tableBinaryStorage);
                    } else if ("binary".startsWith(valStorage)) {
                        colMap.binaryStorage.add(true);
                    } else {
                        colMap.binaryStorage.add(false);
                    }
                } else {
                    colMap.binaryStorage.add(false);
                }
                if (colMap.binaryStorage.size() == 2) continue;
                throw new SerDeException("Error: In parsing the storage specification for column " + (String)this.serdeParams.getColumnNames().get(i));
            }
            throw new SerDeException("Error: hbase.columns.mapping storage specification " + mappingSpec + " is not valid for column: " + (String)this.serdeParams.getColumnNames().get(i));
        }
    }

    public static boolean isRowKeyColumn(String hbaseColumnName) {
        return hbaseColumnName.equals(HBASE_KEY_COL);
    }

    private void initHBaseSerDeParameters(Configuration job, Properties tbl, String serdeName) throws SerDeException {
        this.hbaseColumnsMapping = tbl.getProperty(HBASE_COLUMNS_MAPPING);
        String columnTypeProperty = tbl.getProperty("columns.types");
        this.putTimestamp = Long.valueOf(tbl.getProperty(HBASE_PUT_TIMESTAMP, "-1"));
        this.doColumnRegexMatching = Boolean.valueOf(tbl.getProperty(HBASE_COLUMNS_REGEX_MATCHING, "true"));
        this.columnsMapping = HBaseSerDe.parseColumnsMapping(this.hbaseColumnsMapping, this.doColumnRegexMatching);
        if (columnTypeProperty == null) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.columnsMapping.size(); ++i) {
                if (sb.length() > 0) {
                    sb.append(":");
                }
                ColumnMapping colMap = this.columnsMapping.get(i);
                if (colMap.hbaseRowKey) {
                    sb.append("string");
                    continue;
                }
                if (colMap.qualifierName == null) {
                    sb.append("map<string,string>");
                    continue;
                }
                sb.append("string");
            }
            tbl.setProperty("columns.types", sb.toString());
        }
        this.serdeParams = LazySimpleSerDe.initSerdeParams((Configuration)job, (Properties)tbl, (String)serdeName);
        if (this.columnsMapping.size() != this.serdeParams.getColumnNames().size()) {
            throw new SerDeException(serdeName + ": columns has " + this.serdeParams.getColumnNames().size() + " elements while hbase.columns.mapping has " + this.columnsMapping.size() + " elements" + " (counting the key if implicit)");
        }
        this.separators = this.serdeParams.getSeparators();
        this.escaped = this.serdeParams.isEscaped();
        this.escapeChar = this.serdeParams.getEscapeChar();
        this.needsEscape = this.serdeParams.getNeedsEscape();
        for (int i = 0; i < this.columnsMapping.size(); ++i) {
            TypeInfo typeInfo;
            ColumnMapping colMap = this.columnsMapping.get(i);
            if (colMap.qualifierName != null || colMap.hbaseRowKey || (typeInfo = (TypeInfo)this.serdeParams.getColumnTypes().get(i)).getCategory() == ObjectInspector.Category.MAP && ((MapTypeInfo)typeInfo).getMapKeyTypeInfo().getCategory() == ObjectInspector.Category.PRIMITIVE) continue;
            throw new SerDeException(serdeName + ": hbase column family '" + colMap.familyName + "' should be mapped to Map<? extends LazyPrimitive<?, ?>,?>, that is " + "the Key for the map should be of primitive type, but is mapped to " + typeInfo.getTypeName());
        }
        String hbaseTableStorageType = tbl.getProperty(HBASE_TABLE_DEFAULT_STORAGE_TYPE);
        this.parseColumnStorageTypes(hbaseTableStorageType);
        this.setKeyColumnOffset();
    }

    public Object deserialize(Writable result) throws SerDeException {
        if (!(result instanceof Result)) {
            throw new SerDeException(((Object)((Object)this)).getClass().getName() + ": expects Result!");
        }
        this.cachedHBaseRow.init((Result)result, this.columnsMapping);
        return this.cachedHBaseRow;
    }

    public ObjectInspector getObjectInspector() throws SerDeException {
        return this.cachedObjectInspector;
    }

    public Class<? extends Writable> getSerializedClass() {
        return Put.class;
    }

    public Writable serialize(Object obj, ObjectInspector objInspector) throws SerDeException {
        if (objInspector.getCategory() != ObjectInspector.Category.STRUCT) {
            throw new SerDeException(((Object)((Object)this)).getClass().toString() + " can only serialize struct types, but we got: " + objInspector.getTypeName());
        }
        StructObjectInspector soi = (StructObjectInspector)objInspector;
        List fields = soi.getAllStructFieldRefs();
        List list = soi.getStructFieldsDataAsList(obj);
        List declaredFields = this.serdeParams.getRowTypeInfo() != null && ((StructTypeInfo)this.serdeParams.getRowTypeInfo()).getAllStructFieldNames().size() > 0 ? ((StructObjectInspector)this.getObjectInspector()).getAllStructFieldRefs() : null;
        Put put = null;
        try {
            byte[] key = this.serializeField(this.iKey, null, fields, list, declaredFields);
            if (key == null) {
                throw new SerDeException("HBase row key cannot be NULL");
            }
            put = this.putTimestamp >= 0L ? new Put(key, this.putTimestamp) : new Put(key);
            for (int i = 0; i < fields.size(); ++i) {
                if (i == this.iKey) continue;
                this.serializeField(i, put, fields, list, declaredFields);
            }
        }
        catch (IOException e) {
            throw new SerDeException((Throwable)e);
        }
        return put;
    }

    private byte[] serializeField(int i, Put put, List<? extends StructField> fields, List<Object> list, List<? extends StructField> declaredFields) throws IOException {
        Object f;
        ColumnMapping colMap = this.columnsMapping.get(i);
        ObjectInspector foi = fields.get(i).getFieldObjectInspector();
        Object object = f = list == null ? null : list.get(i);
        if (f == null) {
            return null;
        }
        if (colMap.qualifierName == null && !colMap.hbaseRowKey) {
            MapObjectInspector moi = (MapObjectInspector)foi;
            ObjectInspector koi = moi.getMapKeyObjectInspector();
            ObjectInspector voi = moi.getMapValueObjectInspector();
            Map map = moi.getMap(f);
            if (map == null) {
                return null;
            }
            for (Map.Entry entry : map.entrySet()) {
                this.serializeStream.reset();
                boolean isNotNull = this.serialize(entry.getKey(), koi, 3, colMap.binaryStorage.get(0));
                if (!isNotNull) continue;
                byte[] columnQualifierBytes = new byte[this.serializeStream.getCount()];
                System.arraycopy(this.serializeStream.getData(), 0, columnQualifierBytes, 0, this.serializeStream.getCount());
                this.serializeStream.reset();
                isNotNull = this.serialize(entry.getValue(), voi, 3, colMap.binaryStorage.get(1));
                if (!isNotNull) continue;
                byte[] value = new byte[this.serializeStream.getCount()];
                System.arraycopy(this.serializeStream.getData(), 0, value, 0, this.serializeStream.getCount());
                put.add(colMap.familyNameBytes, columnQualifierBytes, value);
            }
        } else {
            this.serializeStream.reset();
            boolean isNotNull = !foi.getCategory().equals((Object)ObjectInspector.Category.PRIMITIVE) && (declaredFields == null || declaredFields.get(i).getFieldObjectInspector().getCategory().equals((Object)ObjectInspector.Category.PRIMITIVE) || this.useJSONSerialize) ? this.serialize(SerDeUtils.getJSONString((Object)f, (ObjectInspector)foi), (ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector, 1, false) : this.serialize(f, foi, 1, colMap.binaryStorage.get(0));
            if (!isNotNull) {
                return null;
            }
            byte[] key = new byte[this.serializeStream.getCount()];
            System.arraycopy(this.serializeStream.getData(), 0, key, 0, this.serializeStream.getCount());
            if (i == this.iKey) {
                return key;
            }
            put.add(colMap.familyNameBytes, colMap.qualifierNameBytes, key);
        }
        return null;
    }

    private boolean serialize(Object obj, ObjectInspector objInspector, int level, boolean writeBinary) throws IOException {
        if (objInspector.getCategory() == ObjectInspector.Category.PRIMITIVE && writeBinary) {
            LazyUtils.writePrimitive((OutputStream)this.serializeStream, (Object)obj, (PrimitiveObjectInspector)((PrimitiveObjectInspector)objInspector));
            return true;
        }
        return this.serialize(obj, objInspector, level);
    }

    private boolean serialize(Object obj, ObjectInspector objInspector, int level) throws IOException {
        switch (objInspector.getCategory()) {
            case PRIMITIVE: {
                LazyUtils.writePrimitiveUTF8((OutputStream)this.serializeStream, (Object)obj, (PrimitiveObjectInspector)((PrimitiveObjectInspector)objInspector), (boolean)this.escaped, (byte)this.escapeChar, (boolean[])this.needsEscape);
                return true;
            }
            case LIST: {
                char separator = (char)this.separators[level];
                ListObjectInspector loi = (ListObjectInspector)objInspector;
                List list = loi.getList(obj);
                ObjectInspector eoi = loi.getListElementObjectInspector();
                if (list == null) {
                    return false;
                }
                for (int i = 0; i < list.size(); ++i) {
                    if (i > 0) {
                        this.serializeStream.write((int)separator);
                    }
                    this.serialize(list.get(i), eoi, level + 1);
                }
                return true;
            }
            case MAP: {
                char separator = (char)this.separators[level];
                char keyValueSeparator = (char)this.separators[level + 1];
                MapObjectInspector moi = (MapObjectInspector)objInspector;
                ObjectInspector koi = moi.getMapKeyObjectInspector();
                ObjectInspector voi = moi.getMapValueObjectInspector();
                Map map = moi.getMap(obj);
                if (map == null) {
                    return false;
                }
                boolean first = true;
                for (Map.Entry entry : map.entrySet()) {
                    if (first) {
                        first = false;
                    } else {
                        this.serializeStream.write((int)separator);
                    }
                    this.serialize(entry.getKey(), koi, level + 2);
                    this.serializeStream.write((int)keyValueSeparator);
                    this.serialize(entry.getValue(), voi, level + 2);
                }
                return true;
            }
            case STRUCT: {
                char separator = (char)this.separators[level];
                StructObjectInspector soi = (StructObjectInspector)objInspector;
                List fields = soi.getAllStructFieldRefs();
                List list = soi.getStructFieldsDataAsList(obj);
                if (list == null) {
                    return false;
                }
                for (int i = 0; i < list.size(); ++i) {
                    if (i > 0) {
                        this.serializeStream.write((int)separator);
                    }
                    this.serialize(list.get(i), ((StructField)fields.get(i)).getFieldObjectInspector(), level + 1);
                }
                return true;
            }
        }
        throw new RuntimeException("Unknown category type: " + objInspector.getCategory());
    }

    public boolean isUseJSONSerialize() {
        return this.useJSONSerialize;
    }

    public void setUseJSONSerialize(boolean useJSONSerialize) {
        this.useJSONSerialize = useJSONSerialize;
    }

    int getKeyColumnOffset() {
        return this.iKey;
    }

    List<Boolean> getStorageFormatOfCol(int colPos) {
        return this.columnsMapping.get((int)colPos).binaryStorage;
    }

    public SerDeStats getSerDeStats() {
        return null;
    }

    void setKeyColumnOffset() throws SerDeException {
        this.iKey = HBaseSerDe.getRowKeyColumnOffset(this.columnsMapping);
    }

    public static int getRowKeyColumnOffset(List<ColumnMapping> columnsMapping) throws SerDeException {
        for (int i = 0; i < columnsMapping.size(); ++i) {
            ColumnMapping colMap = columnsMapping.get(i);
            if (!colMap.hbaseRowKey || !colMap.familyName.equals(HBASE_KEY_COL)) continue;
            return i;
        }
        throw new SerDeException("HBaseSerDe Error: columns mapping list does not contain row key column.");
    }

    static class ColumnMapping {
        String familyName;
        String qualifierName;
        byte[] familyNameBytes;
        byte[] qualifierNameBytes;
        List<Boolean> binaryStorage = new ArrayList<Boolean>(2);
        boolean hbaseRowKey;
        String mappingSpec;
        String qualifierPrefix;
        byte[] qualifierPrefixBytes;

        ColumnMapping() {
        }
    }
}

