/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.cache;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.cache.Cache;
import javax.cache.CacheException;
import javax.cache.CacheManager;
import javax.cache.Caching;
import javax.cache.Configuration;
import javax.cache.MutableConfiguration;
import org.datanucleus.NucleusContext;
import org.datanucleus.PersistenceConfiguration;
import org.datanucleus.cache.AbstractLevel2Cache;
import org.datanucleus.cache.CachedPC;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.identity.OID;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.util.NucleusLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaxCacheLevel2Cache
extends AbstractLevel2Cache {
    private final Cache cache;

    public JavaxCacheLevel2Cache(NucleusContext nucleusCtx) {
        super(nucleusCtx);
        try {
            CacheManager cacheManager = Caching.getCacheManager();
            Cache tmpcache = cacheManager.getCache(this.cacheName);
            if (tmpcache == null) {
                MutableConfiguration cacheConfig = new MutableConfiguration();
                PersistenceConfiguration conf = nucleusCtx.getPersistenceConfiguration();
                if (conf.hasProperty("datanucleus.cache.level2.readThrough")) {
                    cacheConfig.setReadThrough(conf.getBooleanProperty("datanucleus.cache.level2.readThrough"));
                }
                if (conf.hasProperty("datanucleus.cache.level2.writeThrough")) {
                    cacheConfig.setWriteThrough(conf.getBooleanProperty("datanucleus.cache.level2.writeThrough"));
                }
                if (conf.hasProperty("datanucleus.cache.level2.statisticsEnabled")) {
                    cacheConfig.setStatisticsEnabled(conf.getBooleanProperty("datanucleus.cache.level2.statisticsEnabled"));
                }
                if (conf.hasProperty("datanucleus.cache.level2.storeByValue")) {
                    cacheConfig.setStoreByValue(conf.getBooleanProperty("datanucleus.cache.level2.storeByValue"));
                }
                if (this.timeout > 0L) {
                    // empty if block
                }
                tmpcache = cacheManager.configureCache(this.cacheName, (Configuration)cacheConfig);
            }
            this.cache = tmpcache;
        }
        catch (CacheException e) {
            throw new NucleusException("Error creating cache", e);
        }
    }

    @Override
    public void close() {
        if (this.clearAtClose) {
            this.evictAll();
        }
    }

    @Override
    public boolean containsOid(Object oid) {
        return this.get(oid) != null;
    }

    @Override
    public CachedPC get(Object oid) {
        return (CachedPC)this.cache.get(oid);
    }

    @Override
    public Map<Object, CachedPC> getAll(Collection oids) {
        if (oids instanceof Set) {
            return this.cache.getAll((Set)oids);
        }
        return this.cache.getAll(new HashSet(oids));
    }

    @Override
    public int getSize() {
        throw new UnsupportedOperationException("size() method not supported by this plugin");
    }

    @Override
    public boolean isEmpty() {
        return this.getSize() == 0;
    }

    @Override
    public synchronized CachedPC put(Object oid, CachedPC pc) {
        if (oid == null || pc == null) {
            return null;
        }
        if (this.maxSize >= 0 && this.getSize() == this.maxSize) {
            return null;
        }
        try {
            this.cache.put(oid, (Object)pc);
        }
        catch (RuntimeException re) {
            NucleusLogger.CACHE.info("Object with id " + oid + " not cached due to : " + re.getMessage());
        }
        return pc;
    }

    @Override
    public void putAll(Map<Object, CachedPC> objs) {
        if (objs == null) {
            return;
        }
        try {
            this.cache.putAll(objs);
        }
        catch (RuntimeException re) {
            NucleusLogger.CACHE.info("Objects not cached due to : " + re.getMessage());
        }
    }

    @Override
    public synchronized void evict(Object oid) {
        this.cache.remove(oid);
    }

    @Override
    public synchronized void evictAll() {
        this.cache.removeAll();
    }

    @Override
    public synchronized void evictAll(Collection oids) {
        if (oids == null) {
            return;
        }
        if (oids instanceof Set) {
            this.cache.removeAll((Set)oids);
        } else {
            this.cache.removeAll(new HashSet(oids));
        }
    }

    @Override
    public synchronized void evictAll(Object[] oids) {
        if (oids == null) {
            return;
        }
        HashSet<Object> oidSet = new HashSet<Object>(Arrays.asList(oids));
        this.cache.removeAll(oidSet);
    }

    @Override
    public synchronized void evictAll(Class pcClass, boolean subclasses) {
        String[] subclassNames;
        if (!this.nucleusCtx.getApiAdapter().isPersistable(pcClass)) {
            return;
        }
        this.evictAllOfClass(pcClass.getName());
        if (subclasses && (subclassNames = this.nucleusCtx.getMetaDataManager().getSubclassesForClass(pcClass.getName(), true)) != null) {
            for (int i = 0; i < subclassNames.length; ++i) {
                this.evictAllOfClass(subclassNames[i]);
            }
        }
    }

    void evictAllOfClass(String className) {
        AbstractClassMetaData cmd = this.nucleusCtx.getMetaDataManager().getMetaDataForClass(className, this.nucleusCtx.getClassLoaderResolver(null));
        Iterator entryIter = this.cache.iterator();
        while (entryIter.hasNext()) {
            OID oid;
            Cache.Entry entry = (Cache.Entry)entryIter.next();
            Object key = entry.getKey();
            if (cmd.getIdentityType() == IdentityType.APPLICATION) {
                String targetClassName = this.nucleusCtx.getApiAdapter().getTargetClassNameForSingleFieldIdentity(key);
                if (!className.equals(targetClassName)) continue;
                entryIter.remove();
                continue;
            }
            if (cmd.getIdentityType() != IdentityType.DATASTORE || !(key instanceof OID) || !className.equals((oid = (OID)key).getPcClass())) continue;
            entryIter.remove();
        }
    }
}

