/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.hive.schema;

import com.google.common.collect.Lists;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.apache.drill.exec.planner.logical.DrillTable;
import org.apache.drill.exec.store.StoragePlugin;
import org.apache.drill.exec.store.hive.HiveReadEntry;
import org.apache.drill.exec.store.hive.HiveStoragePlugin;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.serde2.typeinfo.ListTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.MapTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.reltype.RelDataTypeFactory;
import org.eigenbase.sql.SqlCollation;
import org.eigenbase.sql.type.SqlTypeName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DrillHiveTable
extends DrillTable {
    static final Logger logger = LoggerFactory.getLogger(DrillHiveTable.class);
    protected final Table hiveTable;

    public DrillHiveTable(String storageEngineName, HiveStoragePlugin plugin, HiveReadEntry readEntry) {
        super(storageEngineName, (StoragePlugin)plugin, (Object)readEntry);
        this.hiveTable = new Table(readEntry.getTable());
    }

    public RelDataType getRowType(RelDataTypeFactory typeFactory) {
        ArrayList typeList = Lists.newArrayList();
        ArrayList fieldNameList = Lists.newArrayList();
        List hiveFields = this.hiveTable.getCols();
        for (FieldSchema hiveField : hiveFields) {
            fieldNameList.add(hiveField.getName());
            typeList.add(this.getNullableRelDataTypeFromHiveType(typeFactory, TypeInfoUtils.getTypeInfoFromTypeString((String)hiveField.getType())));
        }
        for (FieldSchema field : this.hiveTable.getPartitionKeys()) {
            fieldNameList.add(field.getName());
            typeList.add(this.getNullableRelDataTypeFromHiveType(typeFactory, TypeInfoUtils.getTypeInfoFromTypeString((String)field.getType())));
        }
        return typeFactory.createStructType((List)typeList, (List)fieldNameList);
    }

    private RelDataType getNullableRelDataTypeFromHiveType(RelDataTypeFactory typeFactory, TypeInfo typeInfo) {
        RelDataType relDataType = this.getRelDataTypeFromHiveType(typeFactory, typeInfo);
        return typeFactory.createTypeWithNullability(relDataType, true);
    }

    private RelDataType getRelDataTypeFromHivePrimitiveType(RelDataTypeFactory typeFactory, PrimitiveTypeInfo pTypeInfo) {
        switch (pTypeInfo.getPrimitiveCategory()) {
            case BOOLEAN: {
                return typeFactory.createSqlType(SqlTypeName.BOOLEAN);
            }
            case BYTE: {
                return typeFactory.createSqlType(SqlTypeName.TINYINT);
            }
            case SHORT: {
                return typeFactory.createSqlType(SqlTypeName.SMALLINT);
            }
            case INT: {
                return typeFactory.createSqlType(SqlTypeName.INTEGER);
            }
            case LONG: {
                return typeFactory.createSqlType(SqlTypeName.BIGINT);
            }
            case FLOAT: {
                return typeFactory.createSqlType(SqlTypeName.FLOAT);
            }
            case DOUBLE: {
                return typeFactory.createSqlType(SqlTypeName.DOUBLE);
            }
            case DATE: {
                return typeFactory.createSqlType(SqlTypeName.DATE);
            }
            case TIMESTAMP: {
                return typeFactory.createSqlType(SqlTypeName.TIMESTAMP);
            }
            case BINARY: {
                return typeFactory.createSqlType(SqlTypeName.BINARY);
            }
            case DECIMAL: {
                int precision = 38;
                return typeFactory.createSqlType(SqlTypeName.DECIMAL, 38);
            }
            case STRING: 
            case VARCHAR: {
                int maxLen = TypeInfoUtils.getCharacterLengthForType((PrimitiveTypeInfo)pTypeInfo);
                return typeFactory.createTypeWithCharsetAndCollation(typeFactory.createSqlType(SqlTypeName.VARCHAR, maxLen), Charset.forName("ISO-8859-1"), SqlCollation.IMPLICIT);
            }
        }
        this.throwUnsupportedHiveDataTypeError(pTypeInfo.getPrimitiveCategory().toString());
        return null;
    }

    private RelDataType getRelDataTypeFromHiveType(RelDataTypeFactory typeFactory, TypeInfo typeInfo) {
        switch (typeInfo.getCategory()) {
            case PRIMITIVE: {
                return this.getRelDataTypeFromHivePrimitiveType(typeFactory, (PrimitiveTypeInfo)typeInfo);
            }
            case LIST: {
                ListTypeInfo listTypeInfo = (ListTypeInfo)typeInfo;
                RelDataType listElemTypeInfo = this.getRelDataTypeFromHiveType(typeFactory, listTypeInfo.getListElementTypeInfo());
                return typeFactory.createArrayType(listElemTypeInfo, -1L);
            }
            case MAP: {
                MapTypeInfo mapTypeInfo = (MapTypeInfo)typeInfo;
                RelDataType keyType = this.getRelDataTypeFromHiveType(typeFactory, mapTypeInfo.getMapKeyTypeInfo());
                RelDataType valueType = this.getRelDataTypeFromHiveType(typeFactory, mapTypeInfo.getMapValueTypeInfo());
                return typeFactory.createMapType(keyType, valueType);
            }
            case STRUCT: {
                StructTypeInfo structTypeInfo = (StructTypeInfo)typeInfo;
                ArrayList fieldNames = structTypeInfo.getAllStructFieldNames();
                ArrayList fieldHiveTypeInfoList = structTypeInfo.getAllStructFieldTypeInfos();
                ArrayList fieldRelDataTypeList = Lists.newArrayList();
                for (TypeInfo fieldHiveType : fieldHiveTypeInfoList) {
                    fieldRelDataTypeList.add(this.getRelDataTypeFromHiveType(typeFactory, fieldHiveType));
                }
                return typeFactory.createStructType((List)fieldRelDataTypeList, (List)fieldNames);
            }
            case UNION: {
                logger.warn("There is no UNION data type in SQL. Converting it to Sql type OTHER to avoid breaking INFORMATION_SCHEMA queries");
                return typeFactory.createSqlType(SqlTypeName.OTHER);
            }
        }
        this.throwUnsupportedHiveDataTypeError(typeInfo.getCategory().toString());
        return null;
    }

    private void throwUnsupportedHiveDataTypeError(String hiveType) {
        StringBuilder errMsg = new StringBuilder();
        errMsg.append(String.format("Unsupported Hive data type %s. ", hiveType));
        errMsg.append(System.getProperty("line.separator"));
        errMsg.append("Following Hive data types are supported in Drill INFORMATION_SCHEMA: ");
        errMsg.append("BOOLEAN, BYTE, SHORT, INT, LONG, FLOAT, DOUBLE, DATE, TIMESTAMP, BINARY, DECIMAL, STRING, VARCHAR, LIST, MAP, STRUCT and UNION");
        throw new RuntimeException(errMsg.toString());
    }
}

