/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.hive;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Order;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.SerDeInfo;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;

@JsonTypeName(value="table")
public class HiveTable {
    @JsonIgnore
    private Table table;
    @JsonProperty
    public String tableName;
    @JsonProperty
    public String dbName;
    @JsonProperty
    public String owner;
    @JsonProperty
    public int createTime;
    @JsonProperty
    public int lastAccessTime;
    @JsonProperty
    public int retention;
    @JsonProperty
    public StorageDescriptorWrapper sd;
    @JsonProperty
    public List<FieldSchemaWrapper> partitionKeys;
    @JsonProperty
    public Map<String, String> parameters;
    @JsonProperty
    public String viewOriginalText;
    @JsonProperty
    public String viewExpandedText;
    @JsonProperty
    public String tableType;

    @JsonCreator
    public HiveTable(@JsonProperty(value="tableName") String tableName, @JsonProperty(value="dbName") String dbName, @JsonProperty(value="owner") String owner, @JsonProperty(value="createTime") int createTime, @JsonProperty(value="lastAccessTime") int lastAccessTime, @JsonProperty(value="retention") int retention, @JsonProperty(value="sd") StorageDescriptorWrapper sd, @JsonProperty(value="partitionKeys") List<FieldSchemaWrapper> partitionKeys, @JsonProperty(value="parameters") Map<String, String> parameters, @JsonProperty(value="viewOriginalText") String viewOriginalText, @JsonProperty(value="viewExpandedText") String viewExpandedText, @JsonProperty(value="tableType") String tableType) {
        this.tableName = tableName;
        this.dbName = dbName;
        this.owner = owner;
        this.createTime = createTime;
        this.lastAccessTime = lastAccessTime;
        this.retention = retention;
        this.sd = sd;
        this.partitionKeys = partitionKeys;
        this.parameters = parameters;
        this.viewOriginalText = viewOriginalText;
        this.viewExpandedText = viewExpandedText;
        this.tableType = tableType;
        ArrayList partitionKeysUnwrapped = Lists.newArrayList();
        for (FieldSchemaWrapper w : partitionKeys) {
            partitionKeysUnwrapped.add(w.getFieldSchema());
        }
        StorageDescriptor sdUnwrapped = sd.getSd();
        this.table = new Table(tableName, dbName, owner, createTime, lastAccessTime, retention, sdUnwrapped, (List)partitionKeysUnwrapped, parameters, viewOriginalText, viewExpandedText, tableType);
    }

    public HiveTable(Table table) {
        if (table == null) {
            return;
        }
        this.table = table;
        this.tableName = table.getTableName();
        this.dbName = table.getDbName();
        this.owner = table.getOwner();
        this.createTime = table.getCreateTime();
        this.lastAccessTime = table.getLastAccessTime();
        this.retention = table.getRetention();
        this.sd = new StorageDescriptorWrapper(table.getSd());
        this.partitionKeys = Lists.newArrayList();
        for (FieldSchema f : table.getPartitionKeys()) {
            this.partitionKeys.add(new FieldSchemaWrapper(f));
        }
        this.parameters = table.getParameters();
        this.viewOriginalText = table.getViewOriginalText();
        this.viewExpandedText = table.getViewExpandedText();
        this.tableType = table.getTableType();
    }

    @JsonIgnore
    public Table getTable() {
        return this.table;
    }

    public static class OrderWrapper {
        @JsonIgnore
        private Order ord;
        @JsonProperty
        public String col;
        @JsonProperty
        public int order;

        @JsonCreator
        public OrderWrapper(@JsonProperty(value="col") String col, @JsonProperty(value="order") int order) {
            this.col = col;
            this.order = order;
        }

        public OrderWrapper(Order ord) {
            this.ord = ord;
            this.col = ord.getCol();
            this.order = ord.getOrder();
        }

        @JsonIgnore
        public Order getOrder() {
            return this.ord;
        }
    }

    public static class FieldSchemaWrapper {
        @JsonIgnore
        private FieldSchema fieldSchema;
        @JsonProperty
        public String name;
        @JsonProperty
        public String type;
        @JsonProperty
        public String comment;

        @JsonCreator
        public FieldSchemaWrapper(@JsonProperty(value="name") String name, @JsonProperty(value="type") String type, @JsonProperty(value="comment") String comment) {
            this.name = name;
            this.type = type;
            this.comment = comment;
            this.fieldSchema = new FieldSchema(name, type, comment);
        }

        public FieldSchemaWrapper(FieldSchema fieldSchema) {
            this.fieldSchema = fieldSchema;
            this.name = fieldSchema.getName();
            this.type = fieldSchema.getType();
            this.comment = fieldSchema.getComment();
        }

        @JsonIgnore
        public FieldSchema getFieldSchema() {
            return this.fieldSchema;
        }
    }

    public static class SerDeInfoWrapper {
        @JsonIgnore
        private SerDeInfo serDeInfo;
        @JsonProperty
        public String name;
        @JsonProperty
        public String serializationLib;
        @JsonProperty
        public Map<String, String> parameters;

        @JsonCreator
        public SerDeInfoWrapper(@JsonProperty(value="name") String name, @JsonProperty(value="serializationLib") String serializationLib, @JsonProperty(value="parameters") Map<String, String> parameters) {
            this.name = name;
            this.serializationLib = serializationLib;
            this.parameters = parameters;
            this.serDeInfo = new SerDeInfo(name, serializationLib, parameters);
        }

        public SerDeInfoWrapper(SerDeInfo serDeInfo) {
            this.serDeInfo = serDeInfo;
            this.name = serDeInfo.getName();
            this.serializationLib = serDeInfo.getSerializationLib();
            this.parameters = serDeInfo.getParameters();
        }

        @JsonIgnore
        public SerDeInfo getSerDeInfo() {
            return this.serDeInfo;
        }
    }

    public static class StorageDescriptorWrapper {
        @JsonIgnore
        private StorageDescriptor sd;
        @JsonProperty
        public List<FieldSchemaWrapper> cols;
        @JsonProperty
        public String location;
        @JsonProperty
        public String inputFormat;
        @JsonProperty
        public String outputFormat;
        @JsonProperty
        public boolean compressed;
        @JsonProperty
        public int numBuckets;
        @JsonProperty
        public SerDeInfoWrapper serDeInfo;
        @JsonProperty
        public List<OrderWrapper> sortCols;
        @JsonProperty
        public Map<String, String> parameters;

        @JsonCreator
        public StorageDescriptorWrapper(@JsonProperty(value="cols") List<FieldSchemaWrapper> cols, @JsonProperty(value="location") String location, @JsonProperty(value="inputFormat") String inputFormat, @JsonProperty(value="outputFormat") String outputFormat, @JsonProperty(value="compressed") boolean compressed, @JsonProperty(value="numBuckets") int numBuckets, @JsonProperty(value="serDeInfo") SerDeInfoWrapper serDeInfo, @JsonProperty(value="sortCols") List<OrderWrapper> sortCols, @JsonProperty(value="parameters") Map<String, String> parameters) {
            this.cols = cols;
            this.location = location;
            this.inputFormat = inputFormat;
            this.outputFormat = outputFormat;
            this.compressed = compressed;
            this.numBuckets = numBuckets;
            this.serDeInfo = serDeInfo;
            this.sortCols = sortCols;
            this.parameters = parameters;
            ArrayList colsUnwrapped = Lists.newArrayList();
            for (FieldSchemaWrapper w : cols) {
                colsUnwrapped.add(w.getFieldSchema());
            }
            SerDeInfo serDeInfoUnwrapped = serDeInfo.getSerDeInfo();
            ArrayList sortColsUnwrapped = Lists.newArrayList();
            for (OrderWrapper w : sortCols) {
                sortColsUnwrapped.add(w.getOrder());
            }
            this.sd = new StorageDescriptor((List)colsUnwrapped, location, inputFormat, outputFormat, compressed, numBuckets, serDeInfoUnwrapped, null, (List)sortColsUnwrapped, parameters);
        }

        public StorageDescriptorWrapper(StorageDescriptor sd) {
            this.sd = sd;
            this.cols = Lists.newArrayList();
            for (FieldSchema f : sd.getCols()) {
                this.cols.add(new FieldSchemaWrapper(f));
            }
            this.location = sd.getLocation();
            this.inputFormat = sd.getInputFormat();
            this.outputFormat = sd.getOutputFormat();
            this.compressed = sd.isCompressed();
            this.numBuckets = sd.getNumBuckets();
            this.serDeInfo = new SerDeInfoWrapper(sd.getSerdeInfo());
            this.sortCols = Lists.newArrayList();
            for (Order o : sd.getSortCols()) {
                this.sortCols.add(new OrderWrapper(o));
            }
            this.parameters = sd.getParameters();
        }

        @JsonIgnore
        public StorageDescriptor getSd() {
            return this.sd;
        }
    }

    public static class HivePartition {
        @JsonIgnore
        private Partition partition;
        @JsonProperty
        public List<String> values;
        @JsonProperty
        public String tableName;
        @JsonProperty
        public String dbName;
        @JsonProperty
        public int createTime;
        @JsonProperty
        public int lastAccessTime;
        @JsonProperty
        public StorageDescriptorWrapper sd;
        @JsonProperty
        public Map<String, String> parameters;

        @JsonCreator
        public HivePartition(@JsonProperty(value="values") List<String> values, @JsonProperty(value="tableName") String tableName, @JsonProperty(value="dbName") String dbName, @JsonProperty(value="createTime") int createTime, @JsonProperty(value="lastAccessTime") int lastAccessTime, @JsonProperty(value="sd") StorageDescriptorWrapper sd, @JsonProperty(value="parameters") Map<String, String> parameters) {
            this.values = values;
            this.tableName = tableName;
            this.dbName = dbName;
            this.createTime = createTime;
            this.lastAccessTime = lastAccessTime;
            this.sd = sd;
            this.parameters = parameters;
            StorageDescriptor sdUnwrapped = sd.getSd();
            this.partition = new Partition(values, tableName, dbName, createTime, lastAccessTime, sdUnwrapped, parameters);
        }

        public HivePartition(Partition partition) {
            if (partition == null) {
                return;
            }
            this.partition = partition;
            this.values = partition.getValues();
            this.tableName = partition.getTableName();
            this.dbName = partition.getDbName();
            this.createTime = partition.getCreateTime();
            this.lastAccessTime = partition.getLastAccessTime();
            this.sd = new StorageDescriptorWrapper(partition.getSd());
            this.parameters = partition.getParameters();
        }

        @JsonIgnore
        public Partition getPartition() {
            return this.partition;
        }
    }
}

