/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.hive;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.drill.common.exceptions.ExecutionSetupException;
import org.apache.drill.exec.ops.FragmentContext;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.impl.BatchCreator;
import org.apache.drill.exec.physical.impl.ScanBatch;
import org.apache.drill.exec.record.RecordBatch;
import org.apache.drill.exec.store.hive.HiveRecordReader;
import org.apache.drill.exec.store.hive.HiveSubScan;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.mapred.InputSplit;

public class HiveScanBatchCreator
implements BatchCreator<HiveSubScan> {
    public RecordBatch getBatch(FragmentContext context, HiveSubScan config, List<RecordBatch> children) throws ExecutionSetupException {
        ArrayList readers = Lists.newArrayList();
        Table table = config.getTable();
        List<InputSplit> splits = config.getInputSplits();
        List<Partition> partitions = config.getPartitions();
        boolean hasPartitions = partitions != null && partitions.size() > 0;
        int i = 0;
        for (InputSplit split : splits) {
            readers.add(new HiveRecordReader(table, hasPartitions ? partitions.get(i++) : null, split, config.getColumns(), context, config.getHiveReadEntry().hiveConfigOverride));
        }
        if (readers.size() == 0) {
            readers.add(new HiveRecordReader(table, null, null, config.getColumns(), context, config.getHiveReadEntry().hiveConfigOverride));
        }
        return new ScanBatch((PhysicalOperator)config, context, readers.iterator());
    }
}

