/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.hive;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.codec.binary.Base64;
import org.apache.drill.common.exceptions.DrillRuntimeException;
import org.apache.drill.common.exceptions.ExecutionSetupException;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.exec.physical.EndpointAffinity;
import org.apache.drill.exec.physical.base.AbstractGroupScan;
import org.apache.drill.exec.physical.base.GroupScan;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.base.ScanStats;
import org.apache.drill.exec.physical.base.SubScan;
import org.apache.drill.exec.proto.CoordinationProtos;
import org.apache.drill.exec.store.StoragePluginRegistry;
import org.apache.drill.exec.store.hive.HiveReadEntry;
import org.apache.drill.exec.store.hive.HiveStoragePlugin;
import org.apache.drill.exec.store.hive.HiveSubScan;
import org.apache.drill.exec.store.hive.HiveTable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.MetaStoreUtils;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeName(value="hive-scan")
public class HiveScan
extends AbstractGroupScan {
    static final Logger logger = LoggerFactory.getLogger(HiveScan.class);
    @JsonProperty(value="hive-table")
    public HiveReadEntry hiveReadEntry;
    @JsonIgnore
    private final Table table;
    @JsonIgnore
    private List<InputSplit> inputSplits = Lists.newArrayList();
    @JsonIgnore
    public HiveStoragePlugin storagePlugin;
    @JsonProperty(value="storage-plugin")
    public String storagePluginName;
    @JsonIgnore
    public List<Partition> partitions;
    @JsonIgnore
    private final Collection<CoordinationProtos.DrillbitEndpoint> endpoints;
    @JsonProperty(value="columns")
    public List<SchemaPath> columns;
    @JsonIgnore
    List<List<InputSplit>> mappings;
    @JsonIgnore
    Map<InputSplit, Partition> partitionMap = new HashMap<InputSplit, Partition>();

    @JsonCreator
    public HiveScan(@JsonProperty(value="hive-table") HiveReadEntry hiveReadEntry, @JsonProperty(value="storage-plugin") String storagePluginName, @JsonProperty(value="columns") List<SchemaPath> columns, @JacksonInject StoragePluginRegistry pluginRegistry) throws ExecutionSetupException {
        this.hiveReadEntry = hiveReadEntry;
        this.table = hiveReadEntry.getTable();
        this.storagePluginName = storagePluginName;
        this.storagePlugin = (HiveStoragePlugin)pluginRegistry.getPlugin(storagePluginName);
        this.columns = columns;
        this.partitions = hiveReadEntry.getPartitions();
        this.getSplits();
        this.endpoints = this.storagePlugin.getContext().getBits();
    }

    public HiveScan(HiveReadEntry hiveReadEntry, HiveStoragePlugin storagePlugin, List<SchemaPath> columns) throws ExecutionSetupException {
        this.table = hiveReadEntry.getTable();
        this.hiveReadEntry = hiveReadEntry;
        this.columns = columns;
        this.partitions = hiveReadEntry.getPartitions();
        this.getSplits();
        this.endpoints = storagePlugin.getContext().getBits();
        this.storagePluginName = storagePlugin.getName();
    }

    private HiveScan(HiveScan that) {
        this.columns = that.columns;
        this.endpoints = that.endpoints;
        this.hiveReadEntry = that.hiveReadEntry;
        this.inputSplits = that.inputSplits;
        this.mappings = that.mappings;
        this.partitionMap = that.partitionMap;
        this.partitions = that.partitions;
        this.storagePlugin = that.storagePlugin;
        this.storagePluginName = that.storagePluginName;
        this.table = that.table;
    }

    public List<SchemaPath> getColumns() {
        return this.columns;
    }

    private void getSplits() throws ExecutionSetupException {
        try {
            if (this.partitions == null || this.partitions.size() == 0) {
                Properties properties = MetaStoreUtils.getTableMetadata((Table)this.table);
                JobConf job = new JobConf();
                for (Object object : properties.keySet()) {
                    job.set((String)object, (String)properties.get(object));
                }
                for (Map.Entry entry : this.hiveReadEntry.hiveConfigOverride.entrySet()) {
                    job.set((String)entry.getKey(), (String)entry.getValue());
                }
                InputFormat format = (InputFormat)Class.forName(this.table.getSd().getInputFormat()).getConstructor(new Class[0]).newInstance(new Object[0]);
                job.setInputFormat(format.getClass());
                Path path = new Path(this.table.getSd().getLocation());
                FileSystem fs = FileSystem.get((Configuration)job);
                if (fs.exists(path)) {
                    FileInputFormat.addInputPath((JobConf)job, (Path)path);
                    format = job.getInputFormat();
                    for (InputSplit split : format.getSplits(job, 1)) {
                        this.inputSplits.add(split);
                    }
                }
                for (InputSplit split : this.inputSplits) {
                    this.partitionMap.put(split, null);
                }
            } else {
                for (Partition partition : this.partitions) {
                    InputSplit[] splits;
                    Properties properties = MetaStoreUtils.getPartitionMetadata((Partition)partition, (Table)this.table);
                    JobConf jobConf = new JobConf();
                    for (Object object : properties.keySet()) {
                        jobConf.set((String)object, (String)properties.get(object));
                    }
                    for (Map.Entry entry : this.hiveReadEntry.hiveConfigOverride.entrySet()) {
                        jobConf.set((String)entry.getKey(), (String)entry.getValue());
                    }
                    InputFormat format = (InputFormat)Class.forName(partition.getSd().getInputFormat()).getConstructor(new Class[0]).newInstance(new Object[0]);
                    jobConf.setInputFormat(format.getClass());
                    Path path = new Path(partition.getSd().getLocation());
                    FileSystem fs = FileSystem.get((Configuration)jobConf);
                    if (!fs.exists(path)) continue;
                    FileInputFormat.addInputPath((JobConf)jobConf, (Path)path);
                    format = jobConf.getInputFormat();
                    for (InputSplit split : splits = format.getSplits(jobConf, 1)) {
                        this.inputSplits.add(split);
                        this.partitionMap.put(split, partition);
                    }
                }
            }
        }
        catch (IOException | ReflectiveOperationException e) {
            throw new ExecutionSetupException((Throwable)e);
        }
    }

    public void applyAssignments(List<CoordinationProtos.DrillbitEndpoint> endpoints) {
        this.mappings = Lists.newArrayList();
        for (int i = 0; i < endpoints.size(); ++i) {
            this.mappings.add(new ArrayList());
        }
        int count = endpoints.size();
        for (int i = 0; i < this.inputSplits.size(); ++i) {
            this.mappings.get(i % count).add(this.inputSplits.get(i));
        }
    }

    public static String serializeInputSplit(InputSplit split) throws IOException {
        ByteArrayDataOutput byteArrayOutputStream = ByteStreams.newDataOutput();
        split.write((DataOutput)byteArrayOutputStream);
        String encoded = Base64.encodeBase64String((byte[])byteArrayOutputStream.toByteArray());
        logger.debug("Encoded split string for split {} : {}", (Object)split, (Object)encoded);
        return encoded;
    }

    public SubScan getSpecificScan(int minorFragmentId) throws ExecutionSetupException {
        try {
            List<InputSplit> splits = this.mappings.get(minorFragmentId);
            ArrayList parts = Lists.newArrayList();
            ArrayList encodedInputSplits = Lists.newArrayList();
            ArrayList splitTypes = Lists.newArrayList();
            for (InputSplit split : splits) {
                parts.add(new HiveTable.HivePartition(this.partitionMap.get(split)));
                encodedInputSplits.add(HiveScan.serializeInputSplit(split));
                splitTypes.add(split.getClass().getCanonicalName());
            }
            if (parts.contains(null)) {
                parts = null;
            }
            HiveReadEntry subEntry = new HiveReadEntry(this.hiveReadEntry.table, parts, this.hiveReadEntry.hiveConfigOverride);
            return new HiveSubScan(encodedInputSplits, subEntry, splitTypes, this.columns);
        }
        catch (IOException | ReflectiveOperationException e) {
            throw new ExecutionSetupException((Throwable)e);
        }
    }

    public int getMaxParallelizationWidth() {
        return this.inputSplits.size();
    }

    public List<EndpointAffinity> getOperatorAffinity() {
        HashMap<String, CoordinationProtos.DrillbitEndpoint> endpointMap = new HashMap<String, CoordinationProtos.DrillbitEndpoint>();
        for (CoordinationProtos.DrillbitEndpoint endpoint : this.endpoints) {
            endpointMap.put(endpoint.getAddress(), endpoint);
            logger.debug("endpoing address: {}", (Object)endpoint.getAddress());
        }
        HashMap<CoordinationProtos.DrillbitEndpoint, EndpointAffinity> affinityMap = new HashMap<CoordinationProtos.DrillbitEndpoint, EndpointAffinity>();
        try {
            long totalSize = 0L;
            for (InputSplit split : this.inputSplits) {
                totalSize += Math.max(1L, split.getLength());
            }
            for (InputSplit split : this.inputSplits) {
                float affinity = (float)Math.max(1L, split.getLength()) / (float)totalSize;
                for (String loc : split.getLocations()) {
                    logger.debug("split location: {}", (Object)loc);
                    CoordinationProtos.DrillbitEndpoint endpoint = (CoordinationProtos.DrillbitEndpoint)endpointMap.get(loc);
                    if (endpoint == null) continue;
                    if (affinityMap.containsKey(endpoint)) {
                        ((EndpointAffinity)affinityMap.get(endpoint)).addAffinity(affinity);
                        continue;
                    }
                    affinityMap.put(endpoint, new EndpointAffinity(endpoint, affinity));
                }
            }
        }
        catch (IOException e) {
            throw new DrillRuntimeException((Throwable)e);
        }
        for (CoordinationProtos.DrillbitEndpoint ep : affinityMap.keySet()) {
            Preconditions.checkNotNull((Object)ep);
        }
        for (EndpointAffinity a : affinityMap.values()) {
            Preconditions.checkNotNull((Object)a.getEndpoint());
        }
        return Lists.newArrayList(affinityMap.values());
    }

    public ScanStats getScanStats() {
        try {
            long data = 0L;
            for (InputSplit split : this.inputSplits) {
                data += split.getLength();
            }
            long estRowCount = data / 1024L;
            return new ScanStats(ScanStats.GroupScanProperty.NO_EXACT_ROW_COUNT, estRowCount, 1.0f, (float)data);
        }
        catch (IOException e) {
            throw new DrillRuntimeException((Throwable)e);
        }
    }

    public PhysicalOperator getNewWithChildren(List<PhysicalOperator> children) throws ExecutionSetupException {
        return new HiveScan(this);
    }

    public String getDigest() {
        return this.toString();
    }

    public String toString() {
        return "HiveScan [table=" + this.table + ", inputSplits=" + this.inputSplits + ", columns=" + this.columns + "]";
    }

    public GroupScan clone(List<SchemaPath> columns) {
        HiveScan newScan = new HiveScan(this);
        newScan.columns = columns;
        return newScan;
    }

    public boolean canPushdownProjects(List<SchemaPath> columns) {
        return true;
    }
}

