/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.hive;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.drill.common.exceptions.DrillRuntimeException;
import org.apache.drill.common.exceptions.ExecutionSetupException;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.common.types.Types;
import org.apache.drill.exec.exception.SchemaChangeException;
import org.apache.drill.exec.expr.TypeHelper;
import org.apache.drill.exec.ops.FragmentContext;
import org.apache.drill.exec.ops.OperatorContext;
import org.apache.drill.exec.physical.impl.OutputMutator;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.store.AbstractRecordReader;
import org.apache.drill.exec.store.hive.HiveFieldConverter;
import org.apache.drill.exec.vector.BigIntVector;
import org.apache.drill.exec.vector.BitVector;
import org.apache.drill.exec.vector.DateVector;
import org.apache.drill.exec.vector.Float4Vector;
import org.apache.drill.exec.vector.Float8Vector;
import org.apache.drill.exec.vector.IntVector;
import org.apache.drill.exec.vector.SmallIntVector;
import org.apache.drill.exec.vector.TimeStampVector;
import org.apache.drill.exec.vector.TinyIntVector;
import org.apache.drill.exec.vector.ValueVector;
import org.apache.drill.exec.vector.VarBinaryVector;
import org.apache.drill.exec.vector.VarCharVector;
import org.apache.drill.exec.vector.allocator.VectorAllocator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.metastore.MetaStoreUtils;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.serde2.ColumnProjectionUtils;
import org.apache.hadoop.hive.serde2.SerDe;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class HiveRecordReader
extends AbstractRecordReader {
    protected Table table;
    protected Partition partition;
    protected InputSplit inputSplit;
    protected FragmentContext context;
    protected List<String> selectedColumnNames;
    protected List<TypeInfo> selectedColumnTypes = Lists.newArrayList();
    protected List<ObjectInspector> selectedColumnObjInspectors = Lists.newArrayList();
    protected List<HiveFieldConverter> selectedColumnFieldConverters = Lists.newArrayList();
    protected List<String> selectedPartitionNames = Lists.newArrayList();
    protected List<TypeInfo> selectedPartitionTypes = Lists.newArrayList();
    protected List<Object> selectedPartitionValues = Lists.newArrayList();
    protected List<String> tableColumns;
    protected SerDe serde;
    protected StructObjectInspector sInspector;
    protected Object key;
    protected Object value;
    protected RecordReader reader;
    protected List<ValueVector> vectors = Lists.newArrayList();
    protected List<ValueVector> pVectors = Lists.newArrayList();
    protected Object redoRecord;
    protected boolean empty;
    private Map<String, String> hiveConfigOverride;
    private FragmentContext fragmentContext;
    private OperatorContext operatorContext;
    protected static final int TARGET_RECORD_COUNT = 4000;
    protected static final int FIELD_SIZE = 50;

    public HiveRecordReader(Table table, Partition partition, InputSplit inputSplit, List<SchemaPath> projectedColumns, FragmentContext context, Map<String, String> hiveConfigOverride) throws ExecutionSetupException {
        this.table = table;
        this.partition = partition;
        this.inputSplit = inputSplit;
        this.context = context;
        this.empty = inputSplit == null && partition == null;
        this.hiveConfigOverride = hiveConfigOverride;
        this.fragmentContext = context;
        this.setColumns(projectedColumns);
        this.init();
    }

    private void init() throws ExecutionSetupException {
        InputFormat format;
        Properties properties;
        JobConf job = new JobConf();
        if (this.partition != null) {
            properties = MetaStoreUtils.getPartitionMetadata((Partition)this.partition, (Table)this.table);
            for (Map.Entry entry : this.table.getParameters().entrySet()) {
                if (entry.getKey() == null || entry.getKey() == null) continue;
                properties.put(entry.getKey(), entry.getValue());
            }
        } else {
            properties = MetaStoreUtils.getTableMetadata((Table)this.table);
        }
        for (Object object : properties.keySet()) {
            job.set((String)object, (String)properties.get(object));
        }
        for (Map.Entry entry : this.hiveConfigOverride.entrySet()) {
            job.set((String)entry.getKey(), (String)entry.getValue());
        }
        String string = this.partition == null ? this.table.getSd().getSerdeInfo().getSerializationLib() : this.partition.getSd().getSerdeInfo().getSerializationLib();
        String inputFormatName = this.partition == null ? this.table.getSd().getInputFormat() : this.partition.getSd().getInputFormat();
        try {
            format = (InputFormat)Class.forName(inputFormatName).getConstructor(new Class[0]).newInstance(new Object[0]);
            Class<?> c = Class.forName(string);
            this.serde = (SerDe)c.getConstructor(new Class[0]).newInstance(new Object[0]);
            this.serde.initialize((Configuration)job, properties);
        }
        catch (ReflectiveOperationException | SerDeException e) {
            throw new ExecutionSetupException("Unable to instantiate InputFormat", e);
        }
        job.setInputFormat(format.getClass());
        List partitionKeys = this.table.getPartitionKeys();
        ArrayList partitionNames = Lists.newArrayList();
        for (FieldSchema field : partitionKeys) {
            partitionNames.add(field.getName());
        }
        try {
            ObjectInspector oi = this.serde.getObjectInspector();
            if (oi.getCategory() != ObjectInspector.Category.STRUCT) {
                throw new UnsupportedOperationException(String.format("%s category not supported", oi.getCategory()));
            }
            this.sInspector = (StructObjectInspector)oi;
            StructTypeInfo sTypeInfo = (StructTypeInfo)TypeInfoUtils.getTypeInfoFromObjectInspector((ObjectInspector)this.sInspector);
            if (this.isStarQuery()) {
                this.selectedColumnNames = sTypeInfo.getAllStructFieldNames();
                this.tableColumns = this.selectedColumnNames;
            } else {
                this.tableColumns = sTypeInfo.getAllStructFieldNames();
                ArrayList columnIds = Lists.newArrayList();
                this.selectedColumnNames = Lists.newArrayList();
                for (SchemaPath field : this.getColumns()) {
                    String columnName = field.getRootSegment().getPath();
                    if (!this.tableColumns.contains(columnName)) {
                        if (partitionNames.contains(columnName)) {
                            this.selectedPartitionNames.add(columnName);
                            continue;
                        }
                        throw new ExecutionSetupException(String.format("Column %s does not exist", columnName));
                    }
                    columnIds.add(this.tableColumns.indexOf(columnName));
                    this.selectedColumnNames.add(columnName);
                }
                ColumnProjectionUtils.appendReadColumnIDs((Configuration)job, (List)columnIds);
                ColumnProjectionUtils.appendReadColumnNames((Configuration)job, this.selectedColumnNames);
            }
            for (String columnName : this.selectedColumnNames) {
                ObjectInspector fieldOI = this.sInspector.getStructFieldRef(columnName).getFieldObjectInspector();
                TypeInfo typeInfo = TypeInfoUtils.getTypeInfoFromTypeString((String)fieldOI.getTypeName());
                this.selectedColumnObjInspectors.add(fieldOI);
                this.selectedColumnTypes.add(typeInfo);
                this.selectedColumnFieldConverters.add(HiveFieldConverter.create(typeInfo));
            }
            if (this.isStarQuery()) {
                this.selectedPartitionNames = partitionNames;
            }
            for (int i = 0; i < this.table.getPartitionKeys().size(); ++i) {
                FieldSchema field = (FieldSchema)this.table.getPartitionKeys().get(i);
                if (!this.selectedPartitionNames.contains(field.getName())) continue;
                TypeInfo pType = TypeInfoUtils.getTypeInfoFromTypeString((String)field.getType());
                this.selectedPartitionTypes.add(pType);
                if (this.partition == null) continue;
                this.selectedPartitionValues.add(this.convertPartitionType(pType, (String)this.partition.getValues().get(i)));
            }
        }
        catch (Exception e) {
            throw new ExecutionSetupException("Failure while initializing HiveRecordReader: " + e.getMessage(), (Throwable)e);
        }
        if (!this.empty) {
            try {
                this.reader = format.getRecordReader(this.inputSplit, job, Reporter.NULL);
            }
            catch (IOException e) {
                throw new ExecutionSetupException("Failed to get o.a.hadoop.mapred.RecordReader from Hive InputFormat", (Throwable)e);
            }
            this.key = this.reader.createKey();
            this.value = this.reader.createValue();
        }
    }

    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    public void setOperatorContext(OperatorContext operatorContext) {
        this.operatorContext = operatorContext;
    }

    public void setup(OutputMutator output) throws ExecutionSetupException {
        try {
            Class vvClass;
            MaterializedField field;
            TypeProtos.MajorType type;
            int i;
            for (i = 0; i < this.selectedColumnNames.size(); ++i) {
                type = Types.optional((TypeProtos.MinorType)HiveRecordReader.getMinorTypeFromHiveTypeInfo(this.selectedColumnTypes.get(i)));
                field = MaterializedField.create((SchemaPath)SchemaPath.getSimplePath((String)this.selectedColumnNames.get(i)), (TypeProtos.MajorType)type);
                vvClass = TypeHelper.getValueVectorClass((TypeProtos.MinorType)type.getMinorType(), (TypeProtos.DataMode)type.getMode());
                this.vectors.add(output.addField(field, vvClass));
            }
            for (i = 0; i < this.selectedPartitionNames.size(); ++i) {
                type = Types.required((TypeProtos.MinorType)HiveRecordReader.getMinorTypeFromHiveTypeInfo(this.selectedPartitionTypes.get(i)));
                field = MaterializedField.create((SchemaPath)SchemaPath.getSimplePath((String)this.selectedPartitionNames.get(i)), (TypeProtos.MajorType)type);
                vvClass = TypeHelper.getValueVectorClass((TypeProtos.MinorType)field.getType().getMinorType(), (TypeProtos.DataMode)field.getDataMode());
                this.pVectors.add(output.addField(field, vvClass));
            }
        }
        catch (SchemaChangeException e) {
            throw new ExecutionSetupException((Throwable)e);
        }
    }

    public int next() {
        for (ValueVector vv : this.vectors) {
            VectorAllocator.getAllocator((ValueVector)vv, (int)50).alloc(4000);
        }
        if (this.empty) {
            this.setValueCountAndPopulatePartitionVectors(0);
            return 0;
        }
        try {
            boolean status;
            Object deSerializedValue;
            int recordCount = 0;
            if (this.redoRecord != null) {
                deSerializedValue = this.serde.deserialize((Writable)this.redoRecord);
                status = this.readHiveRecordAndInsertIntoRecordBatch(deSerializedValue, recordCount);
                if (!status) {
                    throw new DrillRuntimeException("Current record is too big to fit into allocated ValueVector buffer");
                }
                this.redoRecord = null;
                ++recordCount;
            }
            while (recordCount < 4000 && this.reader.next(this.key, this.value)) {
                deSerializedValue = this.serde.deserialize((Writable)this.value);
                status = this.readHiveRecordAndInsertIntoRecordBatch(deSerializedValue, recordCount);
                if (!status) {
                    this.redoRecord = this.value;
                    this.setValueCountAndPopulatePartitionVectors(recordCount);
                    return recordCount;
                }
                ++recordCount;
            }
            this.setValueCountAndPopulatePartitionVectors(recordCount);
            return recordCount;
        }
        catch (IOException | SerDeException e) {
            throw new DrillRuntimeException(e);
        }
    }

    private boolean readHiveRecordAndInsertIntoRecordBatch(Object deSerializedValue, int outputRecordIndex) {
        for (int i = 0; i < this.selectedColumnNames.size(); ++i) {
            boolean success;
            String columnName = this.selectedColumnNames.get(i);
            Object hiveValue = this.sInspector.getStructFieldData(deSerializedValue, this.sInspector.getStructFieldRef(columnName));
            if (hiveValue == null || (success = this.selectedColumnFieldConverters.get(i).setSafeValue(this.selectedColumnObjInspectors.get(i), hiveValue, this.vectors.get(i), outputRecordIndex))) continue;
            return false;
        }
        return true;
    }

    private void setValueCountAndPopulatePartitionVectors(int recordCount) {
        for (ValueVector v : this.vectors) {
            v.getMutator().setValueCount(recordCount);
        }
        if (this.partition != null) {
            this.populatePartitionVectors(recordCount);
        }
    }

    public void cleanup() {
    }

    public static TypeProtos.MinorType getMinorTypeFromHivePrimitiveTypeInfo(PrimitiveTypeInfo primitiveTypeInfo) {
        switch (primitiveTypeInfo.getPrimitiveCategory()) {
            case BINARY: {
                return TypeProtos.MinorType.VARBINARY;
            }
            case BOOLEAN: {
                return TypeProtos.MinorType.BIT;
            }
            case BYTE: {
                return TypeProtos.MinorType.TINYINT;
            }
            case DECIMAL: {
                return TypeProtos.MinorType.VARCHAR;
            }
            case DOUBLE: {
                return TypeProtos.MinorType.FLOAT8;
            }
            case FLOAT: {
                return TypeProtos.MinorType.FLOAT4;
            }
            case INT: {
                return TypeProtos.MinorType.INT;
            }
            case LONG: {
                return TypeProtos.MinorType.BIGINT;
            }
            case SHORT: {
                return TypeProtos.MinorType.SMALLINT;
            }
            case STRING: 
            case VARCHAR: {
                return TypeProtos.MinorType.VARCHAR;
            }
            case TIMESTAMP: {
                return TypeProtos.MinorType.TIMESTAMP;
            }
            case DATE: {
                return TypeProtos.MinorType.DATE;
            }
        }
        HiveRecordReader.throwUnsupportedHiveDataTypeError(primitiveTypeInfo.getPrimitiveCategory().toString());
        return null;
    }

    public static TypeProtos.MinorType getMinorTypeFromHiveTypeInfo(TypeInfo typeInfo) {
        switch (typeInfo.getCategory()) {
            case PRIMITIVE: {
                return HiveRecordReader.getMinorTypeFromHivePrimitiveTypeInfo((PrimitiveTypeInfo)typeInfo);
            }
        }
        HiveRecordReader.throwUnsupportedHiveDataTypeError(typeInfo.getCategory().toString());
        return null;
    }

    protected void populatePartitionVectors(int recordCount) {
        for (int i = 0; i < this.pVectors.size(); ++i) {
            int size = 50;
            ValueVector vector = this.pVectors.get(i);
            Object val = this.selectedPartitionValues.get(i);
            PrimitiveObjectInspector.PrimitiveCategory pCat = ((PrimitiveTypeInfo)this.selectedPartitionTypes.get(i)).getPrimitiveCategory();
            if (pCat == PrimitiveObjectInspector.PrimitiveCategory.BINARY || pCat == PrimitiveObjectInspector.PrimitiveCategory.STRING || pCat == PrimitiveObjectInspector.PrimitiveCategory.VARCHAR) {
                size = ((byte[])this.selectedPartitionValues.get(i)).length;
            }
            VectorAllocator.getAllocator((ValueVector)vector, (int)size).alloc(recordCount);
            switch (pCat) {
                case BINARY: {
                    VarBinaryVector v = (VarBinaryVector)vector;
                    byte[] value = (byte[])val;
                    for (int j = 0; j < recordCount; ++j) {
                        v.getMutator().setSafe(j, value);
                    }
                    break;
                }
                case BOOLEAN: {
                    VarBinaryVector v = (BitVector)vector;
                    Boolean value = (Boolean)val;
                    for (int j = 0; j < recordCount; ++j) {
                        v.getMutator().set(j, value != false ? 1 : 0);
                    }
                    break;
                }
                case BYTE: {
                    VarBinaryVector v = (TinyIntVector)vector;
                    byte value = (Byte)val;
                    for (int j = 0; j < recordCount; ++j) {
                        v.getMutator().setSafe(j, (int)value);
                    }
                    break;
                }
                case DOUBLE: {
                    int j;
                    VarBinaryVector v = (Float8Vector)vector;
                    double value = (Double)val;
                    for (j = 0; j < recordCount; ++j) {
                        v.getMutator().setSafe(j, value);
                    }
                    break;
                }
                case FLOAT: {
                    VarBinaryVector v = (Float4Vector)vector;
                    float value = ((Float)val).floatValue();
                    for (int j = 0; j < recordCount; ++j) {
                        v.getMutator().setSafe(j, value);
                    }
                    break;
                }
                case INT: {
                    VarBinaryVector v = (IntVector)vector;
                    int value = (Integer)val;
                    for (int j = 0; j < recordCount; ++j) {
                        v.getMutator().setSafe(j, value);
                    }
                    break;
                }
                case LONG: {
                    int j;
                    VarBinaryVector v = (BigIntVector)vector;
                    long value = (Long)val;
                    for (j = 0; j < recordCount; ++j) {
                        v.getMutator().setSafe(j, value);
                    }
                    break;
                }
                case SHORT: {
                    VarBinaryVector v = (SmallIntVector)vector;
                    short value = (Short)val;
                    for (int j = 0; j < recordCount; ++j) {
                        v.getMutator().setSafe(j, (int)value);
                    }
                    break;
                }
                case STRING: 
                case VARCHAR: {
                    VarBinaryVector v = (VarCharVector)vector;
                    byte[] value = (byte[])val;
                    for (int j = 0; j < recordCount; ++j) {
                        v.getMutator().setSafe(j, value);
                    }
                    break;
                }
                case TIMESTAMP: {
                    int j;
                    VarBinaryVector v = (TimeStampVector)vector;
                    DateTime ts = new DateTime(((Timestamp)val).getTime()).withZoneRetainFields(DateTimeZone.UTC);
                    long value = ts.getMillis();
                    for (j = 0; j < recordCount; ++j) {
                        v.getMutator().setSafe(j, value);
                    }
                    break;
                }
                case DATE: {
                    int j;
                    VarBinaryVector v = (DateVector)vector;
                    DateTime date = new DateTime(((Date)val).getTime()).withZoneRetainFields(DateTimeZone.UTC);
                    long value = date.getMillis();
                    for (j = 0; j < recordCount; ++j) {
                        v.getMutator().setSafe(j, value);
                    }
                    break;
                }
                case DECIMAL: {
                    VarBinaryVector v = (VarCharVector)vector;
                    byte[] value = ((HiveDecimal)val).toString().getBytes();
                    for (int j = 0; j < recordCount; ++j) {
                        v.getMutator().setSafe(j, value);
                    }
                    break;
                }
                default: {
                    HiveRecordReader.throwUnsupportedHiveDataTypeError(pCat.toString());
                }
            }
            vector.getMutator().setValueCount(recordCount);
        }
    }

    private Object convertPartitionType(TypeInfo typeInfo, String value) {
        if (typeInfo.getCategory() != ObjectInspector.Category.PRIMITIVE) {
            throw new DrillRuntimeException("Non-Primitive types are not allowed as partition column type in Hive, but received one: " + typeInfo.getCategory());
        }
        PrimitiveObjectInspector.PrimitiveCategory pCat = ((PrimitiveTypeInfo)typeInfo).getPrimitiveCategory();
        switch (pCat) {
            case BINARY: {
                return value.getBytes();
            }
            case BOOLEAN: {
                return Boolean.parseBoolean(value);
            }
            case BYTE: {
                return Byte.parseByte(value);
            }
            case DECIMAL: {
                return new HiveDecimal(value);
            }
            case DOUBLE: {
                return Double.parseDouble(value);
            }
            case FLOAT: {
                return Float.valueOf(Float.parseFloat(value));
            }
            case INT: {
                return Integer.parseInt(value);
            }
            case LONG: {
                return Long.parseLong(value);
            }
            case SHORT: {
                return Short.parseShort(value);
            }
            case STRING: 
            case VARCHAR: {
                return value.getBytes();
            }
            case TIMESTAMP: {
                return Timestamp.valueOf(value);
            }
            case DATE: {
                return Date.valueOf(value);
            }
        }
        HiveRecordReader.throwUnsupportedHiveDataTypeError(pCat.toString());
        return null;
    }

    public static void throwUnsupportedHiveDataTypeError(String unsupportedType) {
        StringBuilder errMsg = new StringBuilder();
        errMsg.append(String.format("Unsupported Hive data type %s. ", unsupportedType));
        errMsg.append(System.getProperty("line.separator"));
        errMsg.append("Following Hive data types are supported in Drill for querying: ");
        errMsg.append("BOOLEAN, BYTE, SHORT, INT, LONG, FLOAT, DOUBLE, DATE, TIMESTAMP, BINARY, DECIMAL, STRING, and VARCHAR");
        throw new RuntimeException(errMsg.toString());
    }
}

