/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.impl.hive;

import io.netty.buffer.DrillBuf;
import org.apache.drill.exec.expr.fn.impl.StringFunctionHelpers;
import org.apache.drill.exec.expr.fn.impl.hive.AbstractDrillPrimitiveObjectInspector;
import org.apache.drill.exec.expr.holders.NullableVarCharHolder;
import org.apache.drill.exec.expr.holders.VarCharHolder;
import org.apache.hadoop.hive.common.type.HiveVarchar;
import org.apache.hadoop.hive.serde2.io.HiveVarcharWritable;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.HiveVarcharObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;

public abstract class DrillVarCharObjectInspector
extends AbstractDrillPrimitiveObjectInspector
implements HiveVarcharObjectInspector {
    public DrillVarCharObjectInspector() {
        super(PrimitiveObjectInspectorUtils.varcharTypeEntry);
    }

    public HiveVarcharWritable getPrimitiveWritableObject(Object o) {
        HiveVarcharWritable valW = new HiveVarcharWritable();
        valW.set(this.getPrimitiveJavaObject(o));
        return valW;
    }

    public static class Optional
    extends DrillVarCharObjectInspector {
        public HiveVarchar getPrimitiveJavaObject(Object o) {
            NullableVarCharHolder h = (NullableVarCharHolder)o;
            String s = h.isSet == 0 ? null : StringFunctionHelpers.toStringFromUTF8((int)h.start, (int)h.end, (DrillBuf)h.buffer);
            return new HiveVarchar(s, 65535);
        }
    }

    public static class Required
    extends DrillVarCharObjectInspector {
        public HiveVarchar getPrimitiveJavaObject(Object o) {
            VarCharHolder h = (VarCharHolder)o;
            String s = StringFunctionHelpers.toStringFromUTF8((int)h.start, (int)h.end, (DrillBuf)h.buffer);
            return new HiveVarchar(s, 65535);
        }
    }
}

