/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.jdbc;

import com.google.common.collect.Queues;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.TimeZone;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import net.hydromatic.avatica.AvaticaPrepareResult;
import net.hydromatic.avatica.AvaticaResultSet;
import net.hydromatic.avatica.AvaticaStatement;
import org.apache.drill.exec.client.DrillClient;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.record.RecordBatchLoader;
import org.apache.drill.exec.rpc.RpcException;
import org.apache.drill.exec.rpc.user.ConnectionThrottle;
import org.apache.drill.exec.rpc.user.QueryResultBatch;
import org.apache.drill.exec.rpc.user.UserResultsListener;
import org.apache.drill.jdbc.DrillConnection;
import org.apache.drill.jdbc.DrillConnectionImpl;
import org.apache.drill.jdbc.DrillCursor;
import org.apache.drill.jdbc.SchemaChangeListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DrillResultSet
extends AvaticaResultSet {
    static final Logger logger = LoggerFactory.getLogger(DrillResultSet.class);
    SchemaChangeListener changeListener;
    final Listener listener = new Listener();
    private volatile UserBitShared.QueryId queryId;
    private final DrillClient client;
    final RecordBatchLoader currentBatch;
    final DrillCursor cursor;

    public DrillResultSet(AvaticaStatement statement, AvaticaPrepareResult prepareResult, ResultSetMetaData resultSetMetaData, TimeZone timeZone) {
        super(statement, prepareResult, resultSetMetaData, timeZone);
        DrillConnection c = (DrillConnection)statement.getConnection();
        DrillClient client = c.getClient();
        this.currentBatch = new RecordBatchLoader(client.getAllocator());
        this.client = client;
        this.cursor = new DrillCursor(this);
    }

    protected void cancel() {
        this.cleanup();
        this.close();
    }

    synchronized void cleanup() {
        if (this.queryId != null && !this.listener.completed) {
            this.client.cancelQuery(this.queryId);
        }
        this.listener.close();
    }

    protected DrillResultSet execute() throws SQLException {
        DrillConnectionImpl connection = (DrillConnectionImpl)this.statement.getConnection();
        connection.getClient().runQuery(UserBitShared.QueryType.SQL, this.prepareResult.getSql(), (UserResultsListener)this.listener);
        connection.getDriver().handler.onStatementExecute(this.statement, null);
        super.execute();
        try {
            this.listener.latch.await();
            this.cursor.next();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return this;
    }

    class Listener
    implements UserResultsListener {
        private static final int MAX = 100;
        private volatile RpcException ex;
        volatile boolean completed = false;
        private volatile boolean autoread = true;
        private volatile ConnectionThrottle throttle;
        private volatile boolean closed = false;
        private CountDownLatch latch = new CountDownLatch(1);
        private AtomicBoolean receivedMessage = new AtomicBoolean(false);
        final LinkedBlockingDeque<QueryResultBatch> queue = Queues.newLinkedBlockingDeque();

        Listener() {
        }

        private boolean releaseIfFirst() {
            if (this.receivedMessage.compareAndSet(false, true)) {
                this.latch.countDown();
                return true;
            }
            return false;
        }

        public void submissionFailed(RpcException ex) {
            this.releaseIfFirst();
            this.ex = ex;
            this.completed = true;
            this.close();
            System.out.println("Query failed: " + ex.getMessage());
        }

        public void resultArrived(QueryResultBatch result, ConnectionThrottle throttle) {
            logger.debug("Result arrived {}", (Object)result);
            if (result.getHeader().hasQueryState() && result.getHeader().getQueryState() == UserBitShared.QueryResult.QueryState.COMPLETED && result.getHeader().getRowCount() == 0) {
                result.release();
                return;
            }
            if (this.closed) {
                result.release();
                this.completed = true;
                return;
            }
            this.queue.add(result);
            if (this.queue.size() >= 99) {
                throttle.setAutoRead(false);
                this.throttle = throttle;
                this.autoread = false;
            }
            if (result.getHeader().getIsLastChunk()) {
                this.completed = true;
            }
            if (result.getHeader().getErrorCount() > 0) {
                this.submissionFailed(new RpcException(String.format("%s", result.getHeader().getErrorList())));
            }
            this.releaseIfFirst();
        }

        public QueryResultBatch getNext() throws RpcException, InterruptedException {
            QueryResultBatch q;
            do {
                if (this.ex != null) {
                    throw this.ex;
                }
                if (!this.completed || !this.queue.isEmpty()) continue;
                return null;
            } while ((q = this.queue.poll(50L, TimeUnit.MILLISECONDS)) == null);
            if (!this.autoread && this.queue.size() < 50) {
                this.autoread = true;
                this.throttle.setAutoRead(true);
                this.throttle = null;
            }
            return q;
        }

        void close() {
            this.closed = true;
            while (!this.queue.isEmpty()) {
                QueryResultBatch qrb = this.queue.poll();
                if (qrb == null || qrb.getData() == null) continue;
                qrb.getData().release();
            }
            this.completed = true;
        }

        public void queryIdArrived(UserBitShared.QueryId queryId) {
            DrillResultSet.this.queryId = queryId;
        }
    }
}

