/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.jdbc;

import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Properties;
import java.util.TimeZone;
import net.hydromatic.avatica.AvaticaConnection;
import net.hydromatic.avatica.AvaticaFactory;
import net.hydromatic.avatica.AvaticaPrepareResult;
import net.hydromatic.avatica.Helper;
import net.hydromatic.avatica.Meta;
import net.hydromatic.avatica.UnregisteredDriver;
import org.apache.drill.common.config.DrillConfig;
import org.apache.drill.exec.client.DrillClient;
import org.apache.drill.exec.memory.BufferAllocator;
import org.apache.drill.exec.memory.TopLevelAllocator;
import org.apache.drill.exec.rpc.RpcException;
import org.apache.drill.exec.server.Drillbit;
import org.apache.drill.exec.server.RemoteServiceSet;
import org.apache.drill.jdbc.DrillConnection;
import org.apache.drill.jdbc.DrillConnectionConfig;
import org.apache.drill.jdbc.DrillPrepareResult;
import org.apache.drill.jdbc.DrillPreparedStatement;
import org.apache.drill.jdbc.DrillStatement;
import org.apache.drill.jdbc.DrillStatementRegistry;
import org.apache.drill.jdbc.Driver;
import org.apache.drill.jdbc.GlobalServiceSetReference;
import org.apache.drill.jdbc.MetaImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class DrillConnectionImpl
extends AvaticaConnection
implements DrillConnection {
    public final DrillStatementRegistry registry = new DrillStatementRegistry();
    final DrillConnectionConfig config;
    static final Logger logger = LoggerFactory.getLogger(DrillConnection.class);
    private final DrillClient client;
    private final BufferAllocator allocator;
    private Drillbit bit;
    private RemoteServiceSet serviceSet;

    protected DrillConnectionImpl(Driver driver, AvaticaFactory factory, String url, Properties info) throws SQLException {
        super((UnregisteredDriver)driver, factory, url, info);
        this.config = new DrillConnectionConfig(info);
        try {
            if (this.config.isLocal()) {
                DrillConfig dConfig = DrillConfig.create();
                this.allocator = new TopLevelAllocator(dConfig);
                RemoteServiceSet set = GlobalServiceSetReference.SETS.get();
                if (set == null) {
                    set = this.serviceSet = RemoteServiceSet.getLocalServiceSet();
                    try {
                        this.bit = new Drillbit(dConfig, this.serviceSet);
                        this.bit.run();
                    }
                    catch (Exception e) {
                        throw new SQLException("Failure while attempting to start Drillbit in embedded mode.", e);
                    }
                } else {
                    this.serviceSet = null;
                    this.bit = null;
                }
                this.client = new DrillClient(dConfig, set.getCoordinator());
                this.client.connect(null, info);
            } else {
                DrillConfig dConfig = DrillConfig.createClient();
                this.allocator = new TopLevelAllocator(dConfig);
                this.client = new DrillClient();
                this.client.connect(this.config.getZookeeperConnectionString(), info);
            }
        }
        catch (RpcException e) {
            throw new SQLException("Failure while attempting to connect to Drill.", e);
        }
    }

    @Override
    public DrillConnectionConfig config() {
        return this.config;
    }

    protected Meta createMeta() {
        return new MetaImpl(this);
    }

    MetaImpl meta() {
        return (MetaImpl)this.meta;
    }

    BufferAllocator getAllocator() {
        return this.allocator;
    }

    @Override
    public DrillClient getClient() {
        return this.client;
    }

    public DrillStatement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        DrillStatement statement = (DrillStatement)super.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
        this.registry.addStatement(statement);
        return statement;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        try {
            DrillPrepareResult prepareResult = new DrillPrepareResult(sql);
            DrillPreparedStatement statement = (DrillPreparedStatement)this.factory.newPreparedStatement((AvaticaConnection)this, (AvaticaPrepareResult)prepareResult, resultSetType, resultSetConcurrency, resultSetHoldability);
            this.registry.addStatement(statement);
            return statement;
        }
        catch (RuntimeException e) {
            throw Helper.INSTANCE.createException("Error while preparing statement [" + sql + "]", (Exception)e);
        }
        catch (Exception e) {
            throw Helper.INSTANCE.createException("Error while preparing statement [" + sql + "]", e);
        }
    }

    public TimeZone getTimeZone() {
        return this.config.getTimeZone();
    }

    UnregisteredDriver getDriver() {
        return this.driver;
    }

    AvaticaFactory getFactory() {
        return this.factory;
    }

    void cleanup() {
        this.client.close();
        this.allocator.close();
        if (this.bit != null) {
            this.bit.close();
        }
        if (this.serviceSet != null) {
            try {
                this.serviceSet.close();
            }
            catch (IOException e) {
                logger.warn("Exception while closing service set.", (Throwable)e);
            }
        }
    }
}

