/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.util;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.awt.Toolkit;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TimeZone;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.hydromatic.linq4j.Ord;
import org.eigenbase.util.CastingList;
import org.eigenbase.util.ControlFlowException;
import org.eigenbase.util.EigenbaseException;
import org.eigenbase.util.Filterator;
import org.eigenbase.util.SaffronProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Util {
    public static final String AWT_WORKAROUND_PROPERTY = "org.eigenbase.util.AWT_WORKAROUND";
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    public static final String FILE_SEPARATOR = System.getProperty("file.separator");
    public static final String FILE_TIMESTAMP_FORMAT = "yyyy-MM-dd_HH_mm_ss";
    private static boolean driversLoaded = false;
    private static final Pattern JAVA_ID_PATTERN = Pattern.compile("[a-zA-Z_$][a-zA-Z0-9$]*");
    private static Toolkit awtToolkit;
    private static final LoadingCache<Class, Map<String, Enum>> ENUM_CONSTANTS;

    private Util() {
    }

    public static void discard(Object o) {
    }

    public static void discard(int i) {
    }

    public static boolean discard(boolean b) {
        return b;
    }

    public static void discard(double d) {
    }

    public static void swallow(Throwable e, Logger logger) {
        if (logger != null) {
            logger.log(Level.FINER, "Discarding exception", e);
        }
    }

    public static boolean equal(Object s0, Object s1) {
        if (s0 == s1) {
            return true;
        }
        if (s0 == null) {
            return false;
        }
        return s0.equals(s1);
    }

    public static <T> boolean equalShallow(List<? extends T> list0, List<? extends T> list1) {
        if (list0.size() != list1.size()) {
            return false;
        }
        for (int i = 0; i < list0.size(); ++i) {
            if (list0.get(i) == list1.get(i)) continue;
            return false;
        }
        return true;
    }

    public static int hash(int i, int j) {
        return i << 4 ^ j;
    }

    public static int hash(int h, Object o) {
        int k = o == null ? 0 : o.hashCode();
        return (h << 4 | h) ^ k;
    }

    public static int hashArray(int h, Object[] a) {
        if (a == null) {
            return Util.hash(h, 19690429);
        }
        if (a.length == 0) {
            return Util.hash(h, 19690721);
        }
        for (int i = 0; i < a.length; ++i) {
            h = Util.hash(h, a[i]);
        }
        return h;
    }

    public static int hashV(Object ... a) {
        int h = 19690721;
        for (Object o : a) {
            h = Util.hash(h, o);
        }
        return h;
    }

    public static int hashCode(double v) {
        long bits = Double.doubleToLongBits(v);
        return (int)(bits ^ bits >>> 32);
    }

    public static <T> Set<T> minus(Set<T> set1, Set<T> set2) {
        if (set1.isEmpty()) {
            return set1;
        }
        if (set2.isEmpty()) {
            return set1;
        }
        HashSet<T> set = new HashSet<T>(set1);
        set.removeAll(set2);
        return set;
    }

    public static double nLogN(double d) {
        return d < Math.E ? d : d * Math.log(d);
    }

    public static void print(PrintWriter pw, Object o) {
        Util.print(pw, o, 0);
    }

    public static void print(PrintWriter pw, Object o, int indent) {
        if (o == null) {
            pw.print("null");
            return;
        }
        Class<?> clazz = o.getClass();
        if (o instanceof String) {
            Util.printJavaString(pw, (String)o, true);
        } else if (clazz == Integer.class || clazz == Boolean.class || clazz == Character.class || clazz == Byte.class || clazz == Short.class || clazz == Long.class || clazz == Float.class || clazz == Double.class || clazz == Void.class) {
            pw.print(o.toString());
        } else if (clazz.isArray()) {
            if (o instanceof Object[]) {
                Object[] a = (Object[])o;
                Util.discard(a);
            }
            int n = Array.getLength(o);
            pw.print("{");
            for (int i = 0; i < n; ++i) {
                if (i > 0) {
                    pw.println(",");
                } else {
                    pw.println();
                }
                for (int j = 0; j < indent; ++j) {
                    pw.print("\t");
                }
                Util.print(pw, Array.get(o, i), indent + 1);
            }
            pw.print("}");
        } else if (o instanceof Iterator) {
            pw.print(clazz.getName());
            Iterator iter = (Iterator)o;
            pw.print(" {");
            int i = 0;
            while (iter.hasNext()) {
                if (i++ > 0) {
                    pw.println(",");
                }
                Util.print(pw, iter.next(), indent + 1);
            }
            pw.print("}");
        } else if (o instanceof Enumeration) {
            pw.print(clazz.getName());
            Enumeration e = (Enumeration)o;
            pw.print(" {");
            int i = 0;
            while (e.hasMoreElements()) {
                if (i++ > 0) {
                    pw.println(",");
                }
                Util.print(pw, e.nextElement(), indent + 1);
            }
            pw.print("}");
        } else {
            pw.print(clazz.getName());
            pw.print(" {");
            Field[] fields = clazz.getFields();
            int printed = 0;
            for (Field field : fields) {
                Object val;
                if (Util.isStatic(field)) continue;
                if (printed++ > 0) {
                    pw.println(",");
                } else {
                    pw.println();
                }
                for (int j = 0; j < indent; ++j) {
                    pw.print("\t");
                }
                pw.print(field.getName());
                pw.print("=");
                try {
                    val = field.get(o);
                }
                catch (IllegalAccessException e) {
                    throw Util.newInternal(e);
                }
                Util.print(pw, val, indent + 1);
            }
            pw.print("}");
        }
    }

    public static void printJavaString(PrintWriter pw, String s, boolean nullMeansNull) {
        if (s == null) {
            if (nullMeansNull) {
                pw.print("null");
            }
        } else {
            String s1 = Util.replace(s, "\\", "\\\\");
            String s2 = Util.replace(s1, "\"", "\\\"");
            String s3 = Util.replace(s2, "\n\r", "\\n");
            String s4 = Util.replace(s3, "\n", "\\n");
            String s5 = Util.replace(s4, "\r", "\\r");
            pw.print("\"");
            pw.print(s5);
            pw.print("\"");
        }
    }

    public static void println(PrintWriter pw, Object o) {
        Util.print(pw, o, 0);
        pw.println();
    }

    public static String toScientificNotation(BigDecimal bd) {
        int truncateAt = 20;
        String unscaled = bd.unscaledValue().toString();
        if (bd.signum() < 0) {
            unscaled = unscaled.substring(1);
        }
        int len = unscaled.length();
        int scale = bd.scale();
        int e = len - scale - 1;
        StringBuilder ret = new StringBuilder();
        if (bd.signum() < 0) {
            ret.append('-');
        }
        unscaled = unscaled.substring(0, Math.min(20, len));
        ret.append(unscaled.charAt(0));
        if (scale == 0) {
            int i;
            for (i = unscaled.length(); i > 1 && unscaled.charAt(i - 1) == '0'; --i) {
            }
            unscaled = unscaled.substring(0, i);
        }
        if (unscaled.length() > 1) {
            ret.append(".");
            ret.append(unscaled.substring(1));
        }
        ret.append("E");
        ret.append(e);
        return ret.toString();
    }

    public static String replace(String s, String find, String replace) {
        int found = s.indexOf(find);
        if (found == -1) {
            return s;
        }
        StringBuilder sb = new StringBuilder(s.length());
        int start = 0;
        while (true) {
            if (start < found) {
                sb.append(s.charAt(start));
                ++start;
                continue;
            }
            if (found == s.length()) break;
            sb.append(replace);
            found = s.indexOf(find, start += find.length());
            if (found != -1) continue;
            found = s.length();
        }
        return sb.toString();
    }

    public static URL toURL(File file) throws MalformedURLException {
        String path = file.getAbsolutePath();
        String fs = System.getProperty("file.separator");
        if (fs.length() == 1) {
            char sep = fs.charAt(0);
            if (sep != '/') {
                path = path.replace(sep, '/');
            }
            if (path.charAt(0) != '/') {
                path = '/' + path;
            }
        }
        path = "file://" + path;
        return new URL(path);
    }

    public static String getFileTimestamp() {
        SimpleDateFormat sdf = new SimpleDateFormat(FILE_TIMESTAMP_FORMAT);
        return sdf.format(new Date());
    }

    public static String stripDoubleQuotes(String value) {
        assert (value.charAt(0) == '\"');
        assert (value.charAt(value.length() - 1) == '\"');
        String s5 = value.substring(1, value.length() - 1);
        String s4 = Util.replace(s5, "\\r", "\r");
        String s3 = Util.replace(s4, "\\n", "\n");
        String s2 = Util.replace(s3, "\\\"", "\"");
        String s1 = Util.replace(s2, "\\\\", "\\");
        return s1;
    }

    public static String toJavaId(String s, int ordinal) {
        if (JAVA_ID_PATTERN.matcher(s).matches()) {
            return "ID$" + ordinal + "$" + s;
        }
        StringBuilder buf = new StringBuilder(s.length() + 10);
        buf.append("ID$");
        buf.append(ordinal);
        buf.append("$");
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '_') {
                buf.append("__");
                continue;
            }
            if (c < '\u007f' && !Character.isISOControl(c) && (i == 0 ? Character.isJavaIdentifierStart(c) : Character.isJavaIdentifierPart(c))) {
                buf.append(c);
                continue;
            }
            buf.append("_");
            buf.append(Integer.toString(c, 16));
            buf.append("_");
        }
        return buf.toString();
    }

    public static String toLinux(String s) {
        return s.replaceAll("\r\n", "\n");
    }

    public static <T> List<T> toList(Iterator<T> iter) {
        ArrayList<T> list = new ArrayList<T>();
        while (iter.hasNext()) {
            list.add(iter.next());
        }
        return list;
    }

    static boolean isStatic(Member member) {
        int modifiers = member.getModifiers();
        return Modifier.isStatic(modifiers);
    }

    public static boolean isNullOrEmpty(String s) {
        return null == s || s.length() == 0;
    }

    public static <T> String commaList(List<T> list) {
        return Util.sepList(list, ", ");
    }

    public static <T> String sepList(List<T> list, String sep) {
        int max = list.size() - 1;
        switch (max) {
            case -1: {
                return "";
            }
            case 0: {
                return list.get(0).toString();
            }
        }
        StringBuilder buf = new StringBuilder();
        int i = 0;
        while (true) {
            buf.append(list.get(i));
            if (i == max) {
                return buf.toString();
            }
            buf.append(sep);
            ++i;
        }
    }

    public static Charset getDefaultCharset() {
        return Charset.forName(SaffronProperties.instance().defaultCharset.get());
    }

    public static Error newInternal() {
        return Util.newInternal("(unknown cause)");
    }

    public static Error newInternal(String s) {
        return new AssertionError((Object)("Internal error: " + s));
    }

    public static Error newInternal(Throwable e) {
        return Util.newInternal(e, "(unknown cause)");
    }

    public static Error newInternal(Throwable e, String s) {
        String message = "Internal error: " + s;
        AssertionError ae = new AssertionError((Object)message);
        ((Throwable)((Object)ae)).initCause(e);
        return ae;
    }

    public static String getMessages(Throwable t) {
        StringBuilder sb = new StringBuilder();
        for (Throwable curr = t; curr != null; curr = curr.getCause()) {
            String msg;
            String string = msg = curr instanceof EigenbaseException || curr instanceof SQLException ? curr.getMessage() : curr.toString();
            if (sb.length() > 0) {
                sb.append("\n");
            }
            sb.append(msg);
        }
        return sb.toString();
    }

    public static String getStackTrace(Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        pw.flush();
        return sw.toString();
    }

    public static void pre(boolean b, String description) {
        if (!b) {
            throw Util.newInternal("pre-condition failed: " + description);
        }
    }

    public static void post(boolean b, String description) {
        if (!b) {
            throw Util.newInternal("post-condition failed: " + description);
        }
    }

    public static void permAssert(boolean b, String description) {
        if (!b) {
            throw Util.newInternal("invariant violated: " + description);
        }
    }

    public static RuntimeException needToImplement(Object o) {
        String description = null;
        if (o != null) {
            description = o.getClass().toString() + ": " + o.toString();
        }
        throw new UnsupportedOperationException(description);
    }

    public static <T> T deprecated(T argument, boolean fail) {
        if (fail) {
            throw new UnsupportedOperationException();
        }
        return argument;
    }

    public static void loadLibrary(String libName) {
        String awtSetting = System.getProperty(AWT_WORKAROUND_PROPERTY, "on");
        if (awtToolkit == null && awtSetting.equalsIgnoreCase("on")) {
            try {
                awtToolkit = Toolkit.getDefaultToolkit();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        System.loadLibrary(libName);
    }

    public static boolean contains(String[] a, int length, String s) {
        for (int i = 0; i < length; ++i) {
            if (!a[i].equals(s)) continue;
            return true;
        }
        return false;
    }

    public static String readAllAsString(Reader reader) throws IOException {
        int n;
        StringBuilder sb = new StringBuilder();
        char[] buf = new char[4096];
        while ((n = reader.read(buf)) != -1) {
            sb.append(buf, 0, n);
        }
        return sb.toString();
    }

    public static void squelchJar(JarFile jar) {
        try {
            if (jar != null) {
                jar.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void squelchStream(InputStream stream) {
        try {
            if (stream != null) {
                stream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void squelchStream(OutputStream stream) {
        try {
            if (stream != null) {
                stream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void squelchReader(Reader reader) {
        try {
            if (reader != null) {
                reader.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void squelchWriter(Writer writer) {
        try {
            if (writer != null) {
                writer.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void squelchStmt(Statement stmt) {
        try {
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public static void squelchConnection(Connection connection) {
        try {
            if (connection != null) {
                connection.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public static String rtrim(String s) {
        int n = s.length() - 1;
        if (n >= 0) {
            if (s.charAt(n) != ' ') {
                return s;
            }
            while (--n >= 0) {
                if (s.charAt(n) == ' ') continue;
                return s.substring(0, n + 1);
            }
        }
        return "";
    }

    public static String rpad(String s, int len) {
        if (s.length() >= len) {
            return s;
        }
        StringBuilder sb = new StringBuilder(s);
        while (sb.length() < len) {
            sb.append(' ');
        }
        return sb.toString();
    }

    public static <T> String toString(Iterable<T> iterable, String start, String sep, String end) {
        StringBuilder buf = new StringBuilder();
        buf.append(start);
        for (Ord ord : Ord.zip(iterable)) {
            if (ord.i > 0) {
                buf.append(sep);
            }
            buf.append(ord.e);
        }
        buf.append(end);
        return buf.toString();
    }

    public static String toPosix(TimeZone tz, boolean verbose) {
        String tzString;
        String patternString;
        Pattern pattern;
        Matcher matcher;
        StringBuilder buf = new StringBuilder();
        buf.append(tz.getDisplayName(false, 0));
        Util.appendPosixTime(buf, tz.getRawOffset());
        int dstSavings = tz.getDSTSavings();
        if (dstSavings == 0) {
            return buf.toString();
        }
        buf.append(tz.getDisplayName(true, 0));
        if (verbose || dstSavings != 3600000) {
            Util.appendPosixTime(buf, dstSavings);
        }
        if (!(matcher = (pattern = Pattern.compile(patternString = ".*,startMode=([0-9]*),startMonth=([0-9]*),startDay=([-0-9]*),startDayOfWeek=([0-9]*),startTime=([0-9]*),startTimeMode=([0-9]*),endMode=([0-9]*),endMonth=([0-9]*),endDay=([-0-9]*),endDayOfWeek=([0-9]*),endTime=([0-9]*),endTimeMode=([0-9]*).*")).matcher(tzString = tz.toString())).matches()) {
            throw new AssertionError((Object)("tz.toString not of expected format: " + tzString));
        }
        int j = 0;
        int startMode = Integer.valueOf(matcher.group(++j));
        int startMonth = Integer.valueOf(matcher.group(++j));
        int startDay = Integer.valueOf(matcher.group(++j));
        int startDayOfWeek = Integer.valueOf(matcher.group(++j));
        int startTime = Integer.valueOf(matcher.group(++j));
        int startTimeMode = Integer.valueOf(matcher.group(++j));
        int endMode = Integer.valueOf(matcher.group(++j));
        int endMonth = Integer.valueOf(matcher.group(++j));
        int endDay = Integer.valueOf(matcher.group(++j));
        int endDayOfWeek = Integer.valueOf(matcher.group(++j));
        int endTime = Integer.valueOf(matcher.group(++j));
        int endTimeMode = Integer.valueOf(matcher.group(++j));
        Util.appendPosixDaylightTransition(tz, buf, startMode, startDay, startMonth, startDayOfWeek, startTime, startTimeMode, verbose, false);
        Util.appendPosixDaylightTransition(tz, buf, endMode, endDay, endMonth, endDayOfWeek, endTime, endTimeMode, verbose, true);
        return buf.toString();
    }

    private static void appendPosixDaylightTransition(TimeZone tz, StringBuilder buf, int mode, int day, int month, int dayOfWeek, int time, int timeMode, boolean verbose, boolean isEnd) {
        buf.append(',');
        int week = day;
        switch (mode) {
            case 1: {
                throw Util.needToImplement(0);
            }
            case 3: {
                switch (day) {
                    case 1: {
                        week = 1;
                        break;
                    }
                    case 8: {
                        week = 2;
                        break;
                    }
                    case 15: {
                        week = 3;
                        break;
                    }
                    case 22: {
                        week = 4;
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)("POSIX timezone format cannot represent " + tz));
                    }
                }
            }
            case 2: {
                buf.append('M');
                buf.append(month + 1);
                buf.append('.');
                if (week == -1) {
                    week = 5;
                }
                buf.append(week);
                buf.append('.');
                buf.append(dayOfWeek - 1);
                break;
            }
            case 4: {
                throw Util.needToImplement(0);
            }
            default: {
                throw new AssertionError((Object)("unexpected value: " + mode));
            }
        }
        switch (timeMode) {
            case 0: {
                break;
            }
            case 1: {
                if (!isEnd) break;
                time += tz.getDSTSavings();
                break;
            }
            case 2: {
                time += tz.getRawOffset();
                if (!isEnd) break;
                time += tz.getDSTSavings();
            }
        }
        if (verbose || time != 0x6DDD00) {
            buf.append('/');
            Util.appendPosixTime(buf, time);
        }
    }

    private static void appendPosixTime(StringBuilder buf, int millis) {
        if (millis < 0) {
            buf.append('-');
            millis = -millis;
        }
        int hours = millis / 3600000;
        buf.append(hours);
        if ((millis -= hours * 3600000) == 0) {
            return;
        }
        buf.append(':');
        int minutes = millis / 60000;
        if (minutes < 10) {
            buf.append('0');
        }
        buf.append(minutes);
        if ((millis -= minutes * 60000) == 0) {
            return;
        }
        buf.append(':');
        int seconds = millis / 1000;
        if (seconds < 10) {
            buf.append('0');
        }
        buf.append(seconds);
    }

    public static Locale parseLocale(String localeString) {
        String[] strings = localeString.split("_");
        switch (strings.length) {
            case 1: {
                return new Locale(strings[0]);
            }
            case 2: {
                return new Locale(strings[0], strings[1]);
            }
            case 3: {
                return new Locale(strings[0], strings[1], strings[2]);
            }
        }
        throw Util.newInternal("bad locale string '" + localeString + "'");
    }

    public static int runApplication(String[] cmdarray, Logger logger, Reader appInput, Writer appOutput) throws IOException, InterruptedException {
        return Util.runAppProcess(Util.newAppProcess(cmdarray), logger, appInput, appOutput);
    }

    public static ProcessBuilder newAppProcess(String[] cmdarray) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < cmdarray.length; ++i) {
            if (i > 0) {
                buf.append(" ");
            }
            buf.append('\"');
            buf.append(cmdarray[i]);
            buf.append('\"');
        }
        String fullcmd = buf.toString();
        buf.setLength(0);
        return new ProcessBuilder(cmdarray);
    }

    public static int runAppProcess(ProcessBuilder pb, Logger logger, Reader appInput, Writer appOutput) throws IOException, InterruptedException {
        int c;
        pb.redirectErrorStream(true);
        if (logger != null) {
            logger.info("start process: " + pb.command());
        }
        Process p = pb.start();
        if (appInput != null) {
            BufferedOutputStream out = new BufferedOutputStream(p.getOutputStream(), 102400);
            while ((c = appInput.read()) != -1) {
                ((OutputStream)out).write(c);
            }
            ((OutputStream)out).flush();
        }
        if (appOutput != null) {
            BufferedInputStream in = new BufferedInputStream(p.getInputStream(), 102400);
            while ((c = ((InputStream)in).read()) != -1) {
                appOutput.write(c);
            }
            appOutput.flush();
            ((InputStream)in).close();
        }
        p.waitFor();
        int status = p.exitValue();
        if (logger != null) {
            logger.info("exit status=" + status + " from " + pb.command());
        }
        return status;
    }

    public static <E> List<E> cast(List<? super E> list, Class<E> clazz) {
        return new CastingList<E>(list, clazz);
    }

    public static <E> Iterator<E> cast(final Iterator<?> iter, final Class<E> clazz) {
        return new Iterator<E>(){

            @Override
            public boolean hasNext() {
                return iter.hasNext();
            }

            @Override
            public E next() {
                return clazz.cast(iter.next());
            }

            @Override
            public void remove() {
                iter.remove();
            }
        };
    }

    public static <E> Iterable<E> cast(final Iterable<? super E> iterable, final Class<E> clazz) {
        return new Iterable<E>(){

            @Override
            public Iterator<E> iterator() {
                return Util.cast(iterable.iterator(), clazz);
            }
        };
    }

    public static <E> Iterable<E> filter(final Iterable<? extends Object> iterable, final Class<E> includeFilter) {
        return new Iterable<E>(){

            @Override
            public Iterator<E> iterator() {
                return new Filterator(iterable.iterator(), includeFilter);
            }
        };
    }

    public static <E> Collection<E> filter(final Collection<?> collection, final Class<E> includeFilter) {
        return new AbstractCollection<E>(){
            private int size = -1;

            @Override
            public Iterator<E> iterator() {
                return new Filterator(collection.iterator(), includeFilter);
            }

            @Override
            public int size() {
                if (this.size == -1) {
                    int s = 0;
                    Iterator iter = this.iterator();
                    while (iter.hasNext()) {
                        iter.next();
                        ++s;
                    }
                    this.size = s;
                }
                return this.size;
            }
        };
    }

    public static <E> List<E> filter(List<?> list, Class<E> includeFilter) {
        ArrayList<E> result = new ArrayList<E>();
        for (Object o : list) {
            if (!includeFilter.isInstance(o)) continue;
            result.add(includeFilter.cast(o));
        }
        return result;
    }

    public static Map<String, String> toMap(Properties properties) {
        return properties;
    }

    public static <K, V> Map<K, V> mapOf(K key, V value, Object ... keyValues) {
        LinkedHashMap<Object, Object> map = new LinkedHashMap<Object, Object>(1 + keyValues.length);
        map.put(key, value);
        int i = 0;
        while (i < keyValues.length) {
            map.put(keyValues[i++], keyValues[i++]);
        }
        return map;
    }

    public static <E extends Enum<E>> Error unexpected(E value) {
        return new AssertionError((Object)("Was not expecting value '" + value + "' for enumeration '" + value.getDeclaringClass().getName() + "' in this context"));
    }

    public static <T extends Enum<T>> Map<String, T> enumConstants(Class<T> clazz) {
        Enum[] ts = (Enum[])clazz.getEnumConstants();
        if (ts == null) {
            return null;
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Enum t : ts) {
            builder.put((Object)t.name(), (Object)t);
        }
        return builder.build();
    }

    public static synchronized <T extends Enum<T>> T enumVal(Class<T> clazz, String name) {
        return (T)((Enum)((Map)ENUM_CONSTANTS.getUnchecked(clazz)).get(name));
    }

    public static <E> List<E> quotientList(final List<E> list, final int n, final int k) {
        if (n <= 0 || k < 0 || k >= n) {
            throw new IllegalArgumentException("n must be positive; k must be between 0 and n - 1");
        }
        final int size = (list.size() + n - k - 1) / n;
        return new AbstractList<E>(){

            @Override
            public E get(int index) {
                return list.get(index * n + k);
            }

            @Override
            public int size() {
                return size;
            }
        };
    }

    public static <T> T first(T t0, T t1) {
        return t0 != null ? t0 : t1;
    }

    public static <T> Iterable<T> orEmpty(Iterable<T> t0) {
        return t0 != null ? t0 : ImmutableList.of();
    }

    public static <E> E last(List<E> list) {
        return list.get(list.size() - 1);
    }

    public static <E> List<E> skipLast(List<E> list) {
        return Util.skipLast(list, 1);
    }

    public static <E> List<E> skipLast(List<E> list, int n) {
        return list.subList(0, list.size() - n);
    }

    public static <E> List<E> last(List<E> list, int n) {
        return list.subList(list.size() - n, list.size());
    }

    public static <E> List<E> skip(List<E> list) {
        return Util.skip(list, 1);
    }

    public static <E> List<E> skip(List<E> list, int fromIndex) {
        return list.subList(fromIndex, list.size());
    }

    public static List<Integer> range(final int start, final int end) {
        return new AbstractList<Integer>(){

            @Override
            public int size() {
                return end - start;
            }

            @Override
            public Integer get(int index) {
                return start + index;
            }
        };
    }

    public static String toCamelCase(String name) {
        StringBuilder buf = new StringBuilder();
        int nextUpper = -1;
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (c == '_') {
                nextUpper = i + 1;
                continue;
            }
            c = nextUpper == i ? Character.toUpperCase(c) : Character.toLowerCase(c);
            buf.append(c);
        }
        return buf.toString();
    }

    public static String camelToUpper(String name) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (Character.isUpperCase(c)) {
                buf.append('_');
            } else {
                c = Character.toUpperCase(c);
            }
            buf.append(c);
        }
        return buf.toString();
    }

    public static <E> boolean isDistinct(List<E> list) {
        return Util.firstDuplicate(list) < 0;
    }

    public static <E> int firstDuplicate(List<E> list) {
        int size = list.size();
        if (size < 2) {
            return -1;
        }
        if (size < 15) {
            for (int i = 1; i < size; ++i) {
                E e = list.get(i);
                for (int j = i - 1; j >= 0; --j) {
                    E e1 = list.get(j);
                    if (!Util.equal(e, e1)) continue;
                    return i;
                }
            }
            return -1;
        }
        HashMap<E, String> set = new HashMap<E, String>(size);
        for (E e : list) {
            if (set.put(e, "") == null) continue;
            return set.size();
        }
        return -1;
    }

    public static int match2(List<String> strings, String name, boolean caseSensitive1) {
        if (caseSensitive1) {
            return strings.indexOf(name);
        }
        for (int i = 0; i < strings.size(); ++i) {
            String s = strings.get(i);
            if (!s.equalsIgnoreCase(name)) continue;
            return i;
        }
        return -1;
    }

    public static boolean match(boolean caseSensitive, String name1, String name0) {
        return caseSensitive ? name0.equals(name1) : name0.equalsIgnoreCase(name1);
    }

    public static <E> boolean startsWith(List<E> list0, List<E> list1) {
        return list0.equals(list1) || list0.size() > list1.size() && list0.subList(0, list1.size()).equals(list1);
    }

    static {
        ENUM_CONSTANTS = CacheBuilder.newBuilder().weakKeys().build((CacheLoader)new CacheLoader<Class, Map<String, Enum>>(){

            public Map<String, Enum> load(Class clazz) {
                return Util.enumConstants(clazz);
            }
        });
    }

    public static class FoundOne
    extends ControlFlowException {
        private final Object node;
        public static final FoundOne NULL = new FoundOne((Object)null);

        public FoundOne(Object node) {
            this.node = node;
        }

        public Object getNode() {
            return this.node;
        }
    }
}

