/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.sql.validate;

import org.eigenbase.reltype.RelDataType;
import org.eigenbase.reltype.RelDataTypeFactory;
import org.eigenbase.reltype.RelDataTypeField;
import org.eigenbase.sql.SqlIdentifier;
import org.eigenbase.sql.SqlNode;
import org.eigenbase.sql.SqlWithItem;
import org.eigenbase.sql.validate.AbstractNamespace;
import org.eigenbase.sql.validate.SqlValidatorImpl;
import org.eigenbase.sql.validate.SqlValidatorNamespace;
import org.eigenbase.util.Pair;

class WithItemNamespace
extends AbstractNamespace {
    private final SqlWithItem withItem;

    WithItemNamespace(SqlValidatorImpl validator, SqlWithItem withItem, SqlNode enclosingNode) {
        super(validator, enclosingNode);
        this.withItem = withItem;
    }

    protected RelDataType validateImpl() {
        SqlValidatorNamespace childNs = this.validator.getNamespace(this.withItem.query);
        RelDataType rowType = childNs.getRowTypeSansSystemColumns();
        if (this.withItem.columnList == null) {
            return rowType;
        }
        RelDataTypeFactory.FieldInfoBuilder builder = this.validator.getTypeFactory().builder();
        for (Pair<SqlNode, RelDataTypeField> pair : Pair.zip(this.withItem.columnList, rowType.getFieldList())) {
            builder.add(((SqlIdentifier)pair.left).getSimple(), ((RelDataTypeField)pair.right).getType());
        }
        return builder.build();
    }

    public SqlNode getNode() {
        return this.withItem;
    }

    public String translate(String name) {
        if (this.withItem.columnList == null) {
            return name;
        }
        RelDataType underlyingRowType = this.validator.getValidatedNodeType(this.withItem.query);
        int i = 0;
        for (RelDataTypeField field : this.rowType.getFieldList()) {
            if (field.getName().equals(name)) {
                return underlyingRowType.getFieldList().get(i).getName();
            }
            ++i;
        }
        throw new AssertionError((Object)("unknown field '" + name + "' in rowtype " + underlyingRowType));
    }
}

