/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.sql.type;

import com.google.common.collect.ImmutableList;
import java.util.AbstractList;
import java.util.List;
import net.hydromatic.linq4j.Ord;
import org.eigenbase.sql.SqlCallBinding;
import org.eigenbase.sql.SqlNode;
import org.eigenbase.sql.SqlOperandCountRange;
import org.eigenbase.sql.SqlOperator;
import org.eigenbase.sql.type.SqlOperandCountRanges;
import org.eigenbase.sql.type.SqlOperandTypeChecker;
import org.eigenbase.sql.type.SqlSingleOperandTypeChecker;
import org.eigenbase.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeOperandTypeChecker
implements SqlSingleOperandTypeChecker {
    private final ImmutableList<SqlSingleOperandTypeChecker> allowedRules;
    private final Composition composition;

    CompositeOperandTypeChecker(Composition composition, ImmutableList<SqlSingleOperandTypeChecker> allowedRules) {
        assert (null != allowedRules);
        assert (allowedRules.size() > 1);
        this.allowedRules = allowedRules;
        this.composition = composition;
    }

    public ImmutableList<SqlSingleOperandTypeChecker> getRules() {
        return this.allowedRules;
    }

    @Override
    public String getAllowedSignatures(SqlOperator op, String opName) {
        if (this.composition == Composition.SEQUENCE) {
            throw Util.needToImplement("must override getAllowedSignatures");
        }
        StringBuilder ret = new StringBuilder();
        for (Ord ord : Ord.zip(this.allowedRules)) {
            if (ord.i > 0) {
                ret.append(SqlOperator.NL);
            }
            ret.append(((SqlSingleOperandTypeChecker)ord.e).getAllowedSignatures(op, opName));
            if (this.composition != Composition.AND) continue;
            break;
        }
        return ret.toString();
    }

    @Override
    public SqlOperandCountRange getOperandCountRange() {
        switch (this.composition) {
            case SEQUENCE: {
                return SqlOperandCountRanges.of(this.allowedRules.size());
            }
        }
        final AbstractList<SqlOperandCountRange> ranges = new AbstractList<SqlOperandCountRange>(){

            @Override
            public SqlOperandCountRange get(int index) {
                return ((SqlSingleOperandTypeChecker)CompositeOperandTypeChecker.this.allowedRules.get(index)).getOperandCountRange();
            }

            @Override
            public int size() {
                return CompositeOperandTypeChecker.this.allowedRules.size();
            }
        };
        final int min = this.minMin((List<SqlOperandCountRange>)ranges);
        final int max = this.maxMax((List<SqlOperandCountRange>)ranges);
        SqlOperandCountRange composite = new SqlOperandCountRange(){

            public boolean isValidCount(int count) {
                switch (CompositeOperandTypeChecker.this.composition) {
                    case AND: {
                        for (SqlOperandCountRange range : ranges) {
                            if (range.isValidCount(count)) continue;
                            return false;
                        }
                        return true;
                    }
                }
                for (SqlOperandCountRange range : ranges) {
                    if (!range.isValidCount(count)) continue;
                    return true;
                }
                return false;
            }

            public int getMin() {
                return min;
            }

            public int getMax() {
                return max;
            }
        };
        if (max >= 0) {
            for (int i = min; i <= max; ++i) {
                if (composite.isValidCount(i)) continue;
                return composite;
            }
        }
        return SqlOperandCountRanges.between(min, max);
    }

    private int minMin(List<SqlOperandCountRange> ranges) {
        int min = Integer.MAX_VALUE;
        for (SqlOperandCountRange range : ranges) {
            min = Math.min(min, range.getMax());
        }
        return min;
    }

    private int maxMax(List<SqlOperandCountRange> ranges) {
        int max = Integer.MAX_VALUE;
        for (SqlOperandCountRange range : ranges) {
            if (range.getMax() < 0) {
                if (this.composition != Composition.OR) continue;
                return -1;
            }
            max = Math.max(max, range.getMax());
        }
        return max;
    }

    @Override
    public boolean checkSingleOperandType(SqlCallBinding callBinding, SqlNode node, int iFormalOperand, boolean throwOnFailure) {
        boolean ret;
        assert (this.allowedRules.size() >= 1);
        if (this.composition == Composition.SEQUENCE) {
            return ((SqlSingleOperandTypeChecker)this.allowedRules.get(iFormalOperand)).checkSingleOperandType(callBinding, node, 0, throwOnFailure);
        }
        int typeErrorCount = 0;
        boolean throwOnAndFailure = this.composition == Composition.AND && throwOnFailure;
        for (SqlSingleOperandTypeChecker rule : this.allowedRules) {
            if (rule.checkSingleOperandType(callBinding, node, iFormalOperand, throwOnAndFailure)) continue;
            ++typeErrorCount;
        }
        switch (this.composition) {
            case AND: {
                ret = typeErrorCount == 0;
                break;
            }
            case OR: {
                ret = typeErrorCount < this.allowedRules.size();
                break;
            }
            default: {
                throw Util.unexpected(this.composition);
            }
        }
        if (!ret && throwOnFailure) {
            for (SqlSingleOperandTypeChecker rule : this.allowedRules) {
                rule.checkSingleOperandType(callBinding, node, iFormalOperand, true);
            }
            throw callBinding.newValidationSignatureError();
        }
        return ret;
    }

    @Override
    public boolean checkOperandTypes(SqlCallBinding callBinding, boolean throwOnFailure) {
        boolean failed;
        int typeErrorCount = 0;
        block7: for (Ord ord : Ord.zip(this.allowedRules)) {
            SqlSingleOperandTypeChecker rule = (SqlSingleOperandTypeChecker)ord.e;
            switch (this.composition) {
                case SEQUENCE: {
                    if (ord.i >= callBinding.getOperandCount()) break block7;
                    if (rule.checkSingleOperandType(callBinding, (SqlNode)callBinding.getCall().operand(ord.i), 0, false)) continue block7;
                    ++typeErrorCount;
                    continue block7;
                }
                default: {
                    if (!rule.checkOperandTypes(callBinding, false)) {
                        ++typeErrorCount;
                        if (this.composition != Composition.AND) continue block7;
                        break block7;
                    }
                    if (this.composition != Composition.OR) continue block7;
                    break block7;
                }
            }
        }
        switch (this.composition) {
            case AND: 
            case SEQUENCE: {
                failed = typeErrorCount > 0;
                break;
            }
            case OR: {
                failed = typeErrorCount == this.allowedRules.size();
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        if (failed) {
            if (throwOnFailure) {
                if (this.composition == Composition.OR) {
                    for (SqlOperandTypeChecker allowedRule : this.allowedRules) {
                        allowedRule.checkOperandTypes(callBinding, true);
                    }
                }
                throw callBinding.newValidationSignatureError();
            }
            return false;
        }
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Composition {
        AND,
        OR,
        SEQUENCE;

    }
}

