/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.sarg;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.eigenbase.relopt.RelOptUtil;
import org.eigenbase.rex.RexCall;
import org.eigenbase.rex.RexCorrelVariable;
import org.eigenbase.rex.RexDynamicParam;
import org.eigenbase.rex.RexFieldAccess;
import org.eigenbase.rex.RexInputRef;
import org.eigenbase.rex.RexLiteral;
import org.eigenbase.rex.RexNode;
import org.eigenbase.rex.RexOver;
import org.eigenbase.rex.RexRangeRef;
import org.eigenbase.rex.RexVisitorImpl;
import org.eigenbase.sarg.SargBinding;
import org.eigenbase.sarg.SargBoundType;
import org.eigenbase.sarg.SargExpr;
import org.eigenbase.sarg.SargFactory;
import org.eigenbase.sarg.SargIntervalExpr;
import org.eigenbase.sarg.SargIntervalSequence;
import org.eigenbase.sarg.SargSetExpr;
import org.eigenbase.sarg.SargSetOperator;
import org.eigenbase.sarg.SargStrictness;
import org.eigenbase.sql.SqlOperator;
import org.eigenbase.sql.fun.SqlStdOperatorTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SargRexAnalyzer {
    private final SargFactory factory;
    private final boolean simpleMode;
    private final Map<SqlOperator, CallConvertlet> convertletMap;
    private boolean failed;
    private RexInputRef boundInputRef;
    private RexNode coordinate;
    private boolean variableSeen;
    private boolean reverse;
    private List<SargExpr> exprStack;
    private List<RexNode> nonSargFilterList;
    private List<SargBinding> sargBindingList;
    private Map<SargExpr, RexNode> sarg2RexMap;
    private int lowerRexInputIdx;
    private int upperRexInputIdx;

    SargRexAnalyzer(SargFactory factory, boolean simpleMode) {
        this(factory, simpleMode, -1, -1);
    }

    SargRexAnalyzer(SargFactory factory, boolean simpleMode, int lowerRexInputRef, int upperRexInputRef) {
        this.factory = factory;
        this.simpleMode = simpleMode;
        this.lowerRexInputIdx = lowerRexInputRef;
        this.upperRexInputIdx = upperRexInputRef;
        assert (this.lowerRexInputIdx < 0 && this.upperRexInputIdx < 0 || this.lowerRexInputIdx >= 0 && this.upperRexInputIdx >= 0);
        this.convertletMap = new HashMap<SqlOperator, CallConvertlet>();
        this.registerConvertlet(SqlStdOperatorTable.EQUALS, new ComparisonConvertlet(null, SargStrictness.CLOSED));
        this.registerConvertlet(SqlStdOperatorTable.IS_NULL, new ComparisonConvertlet(null, SargStrictness.CLOSED));
        this.registerConvertlet(SqlStdOperatorTable.IS_TRUE, new ComparisonConvertlet(null, SargStrictness.CLOSED));
        this.registerConvertlet(SqlStdOperatorTable.IS_FALSE, new ComparisonConvertlet(null, SargStrictness.CLOSED));
        this.registerConvertlet(SqlStdOperatorTable.IS_UNKNOWN, new ComparisonConvertlet(null, SargStrictness.CLOSED));
        this.registerConvertlet(SqlStdOperatorTable.LESS_THAN, new ComparisonConvertlet(SargBoundType.UPPER, SargStrictness.OPEN));
        this.registerConvertlet(SqlStdOperatorTable.LESS_THAN_OR_EQUAL, new ComparisonConvertlet(SargBoundType.UPPER, SargStrictness.CLOSED));
        this.registerConvertlet(SqlStdOperatorTable.GREATER_THAN, new ComparisonConvertlet(SargBoundType.LOWER, SargStrictness.OPEN));
        this.registerConvertlet(SqlStdOperatorTable.GREATER_THAN_OR_EQUAL, new ComparisonConvertlet(SargBoundType.LOWER, SargStrictness.CLOSED));
        this.registerConvertlet(SqlStdOperatorTable.AND, new BooleanConvertlet(SargSetOperator.INTERSECTION));
        if (!simpleMode) {
            this.registerConvertlet(SqlStdOperatorTable.OR, new BooleanConvertlet(SargSetOperator.UNION));
        }
        this.registerConvertlet(SqlStdOperatorTable.NOT, new BooleanConvertlet(SargSetOperator.COMPLEMENT));
    }

    private void registerConvertlet(SqlOperator op, CallConvertlet convertlet) {
        this.convertletMap.put(op, convertlet);
    }

    private void recomposeConjunction() {
        for (int i = 0; i < this.sargBindingList.size(); ++i) {
            SargBinding currBinding = this.sargBindingList.get(i);
            RexInputRef currRef = currBinding.getInputRef();
            SargExpr currSargExpr = currBinding.getExpr();
            RexNode currAndNode = this.sarg2RexMap.get(currSargExpr);
            this.sarg2RexMap.remove(currSargExpr);
            boolean recomp = false;
            ListIterator<SargBinding> iter = this.sargBindingList.listIterator(i + 1);
            while (iter.hasNext()) {
                SargBinding nextBinding = iter.next();
                RexInputRef nextRef = nextBinding.getInputRef();
                SargExpr nextSargExpr = nextBinding.getExpr();
                if (nextRef.getIndex() != currRef.getIndex()) continue;
                SargSetExpr expr = this.factory.newSetExpr(currSargExpr.getDataType(), SargSetOperator.INTERSECTION);
                expr.addChild(currSargExpr);
                expr.addChild(nextSargExpr);
                currAndNode = this.factory.getRexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.AND, currAndNode, this.sarg2RexMap.get(nextSargExpr));
                currSargExpr = expr;
                this.sarg2RexMap.remove(nextSargExpr);
                iter.remove();
                recomp = true;
            }
            if (recomp) {
                assert (!this.simpleMode);
                if (!this.testDynamicParamSupport(currSargExpr)) {
                    this.nonSargFilterList.add(currAndNode);
                    this.sargBindingList.remove(i);
                    continue;
                }
            }
            if (recomp) {
                SargBinding newBinding = new SargBinding(currSargExpr, currRef);
                this.sargBindingList.remove(i);
                this.sargBindingList.add(i, newBinding);
            }
            this.sarg2RexMap.put(currSargExpr, currAndNode);
        }
    }

    public List<SargBinding> analyzeAll(RexNode rexPredicate) {
        this.sargBindingList = new ArrayList<SargBinding>();
        this.sarg2RexMap = new HashMap<SargExpr, RexNode>();
        this.nonSargFilterList = new ArrayList<RexNode>();
        List<RexNode> rexCFList = RelOptUtil.conjunctions(rexPredicate);
        ArrayList<Integer> boundRefList = new ArrayList<Integer>();
        boolean rangeFound = false;
        for (RexNode rexPred : rexCFList) {
            SargBinding sargBinding = this.analyze(rexPred);
            if (sargBinding != null) {
                if (this.simpleMode) {
                    RexInputRef inputRef = sargBinding.getInputRef();
                    if (boundRefList.contains(inputRef.getIndex())) {
                        this.nonSargFilterList.add(rexPred);
                        continue;
                    }
                    boundRefList.add(inputRef.getIndex());
                    SargIntervalSequence sargSeq = sargBinding.getExpr().evaluate();
                    if (sargSeq.isRange()) {
                        if (rangeFound) {
                            this.nonSargFilterList.add(rexPred);
                            continue;
                        }
                        rangeFound = true;
                    }
                }
                this.sargBindingList.add(sargBinding);
                this.sarg2RexMap.put(sargBinding.getExpr(), rexPred);
                continue;
            }
            this.nonSargFilterList.add(rexPred);
        }
        this.failed = false;
        this.boundInputRef = null;
        this.clearLeaf();
        this.recomposeConjunction();
        return this.sargBindingList;
    }

    private boolean testDynamicParamSupport(SargExpr sargExpr) {
        HashSet<RexDynamicParam> dynamicParams = new HashSet<RexDynamicParam>();
        sargExpr.collectDynamicParams(dynamicParams);
        if (dynamicParams.isEmpty()) {
            return true;
        }
        return sargExpr instanceof SargIntervalExpr;
    }

    public RexNode getNonSargFilterRexNode() {
        if (this.nonSargFilterList.isEmpty()) {
            return null;
        }
        RexNode newAndNode = this.nonSargFilterList.get(0);
        for (int i = 1; i < this.nonSargFilterList.size(); ++i) {
            newAndNode = this.factory.getRexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.AND, newAndNode, this.nonSargFilterList.get(i));
        }
        return newAndNode;
    }

    public RexNode getPostFilterRexNode() {
        return this.getNonSargFilterRexNode();
    }

    public RexNode getSargBindingListToRexNode(List<SargBinding> sargBindingList) {
        if (sargBindingList.isEmpty()) {
            return null;
        }
        RexNode newAndNode = this.sarg2RexMap.get(sargBindingList.get(0).getExpr());
        for (int i = 1; i < sargBindingList.size(); ++i) {
            RexNode nextNode = this.sarg2RexMap.get(sargBindingList.get(i).getExpr());
            newAndNode = this.factory.getRexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.AND, newAndNode, nextNode);
        }
        return newAndNode;
    }

    public RexNode getResidualSargRexNode(List<SargBinding> residualSargList) {
        return this.getSargBindingListToRexNode(residualSargList);
    }

    public SargBinding analyze(RexNode rexPredicate) {
        NodeVisitor visitor = new NodeVisitor();
        this.exprStack = new ArrayList<SargExpr>();
        this.failed = false;
        this.boundInputRef = null;
        this.clearLeaf();
        rexPredicate.accept(visitor);
        if (this.boundInputRef == null) {
            this.failed = true;
        }
        if (this.exprStack.isEmpty()) {
            this.failed = true;
        }
        if (this.failed) {
            return null;
        }
        assert (this.exprStack.size() == 1);
        SargExpr expr = this.exprStack.get(0);
        if (!this.testDynamicParamSupport(expr)) {
            this.failed = true;
            return null;
        }
        return new SargBinding(expr, this.boundInputRef);
    }

    private void clearLeaf() {
        this.coordinate = null;
        this.variableSeen = false;
        this.reverse = false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class NodeVisitor
    extends RexVisitorImpl<Void> {
        NodeVisitor() {
            super(true);
        }

        @Override
        public Void visitInputRef(RexInputRef inputRef) {
            boolean coordinate;
            boolean bl = coordinate = !this.isRealRexInputRef(inputRef);
            if (coordinate) {
                this.visitCoordinate(inputRef);
                return null;
            }
            SargRexAnalyzer.this.variableSeen = true;
            if (SargRexAnalyzer.this.boundInputRef == null) {
                SargRexAnalyzer.this.boundInputRef = inputRef;
                return null;
            }
            if (inputRef.getIndex() != SargRexAnalyzer.this.boundInputRef.getIndex()) {
                SargRexAnalyzer.this.failed = true;
                return null;
            }
            return null;
        }

        private boolean isRealRexInputRef(RexInputRef inputRef) {
            if (SargRexAnalyzer.this.lowerRexInputIdx < 0 && SargRexAnalyzer.this.upperRexInputIdx < 0) {
                return true;
            }
            int idx = inputRef.getIndex();
            return idx < SargRexAnalyzer.this.lowerRexInputIdx || idx >= SargRexAnalyzer.this.upperRexInputIdx;
        }

        @Override
        public Void visitLiteral(RexLiteral literal) {
            this.visitCoordinate(literal);
            return null;
        }

        @Override
        public Void visitOver(RexOver over) {
            SargRexAnalyzer.this.failed = true;
            return null;
        }

        @Override
        public Void visitCorrelVariable(RexCorrelVariable correlVariable) {
            SargRexAnalyzer.this.failed = true;
            return null;
        }

        @Override
        public Void visitCall(RexCall call) {
            CallConvertlet convertlet = (CallConvertlet)SargRexAnalyzer.this.convertletMap.get(call.getOperator());
            if (convertlet == null) {
                SargRexAnalyzer.this.failed = true;
                return null;
            }
            super.visitCall(call);
            convertlet.convert(call);
            return null;
        }

        @Override
        public Void visitDynamicParam(RexDynamicParam dynamicParam) {
            if (SargRexAnalyzer.this.simpleMode) {
                SargRexAnalyzer.this.failed = true;
            } else {
                this.visitCoordinate(dynamicParam);
            }
            return null;
        }

        private void visitCoordinate(RexNode node) {
            if (!SargRexAnalyzer.this.variableSeen) {
                SargRexAnalyzer.this.reverse = true;
            }
            if (SargRexAnalyzer.this.coordinate != null) {
                SargRexAnalyzer.this.failed = true;
                return;
            }
            SargRexAnalyzer.this.coordinate = node;
        }

        @Override
        public Void visitRangeRef(RexRangeRef rangeRef) {
            SargRexAnalyzer.this.failed = true;
            return null;
        }

        @Override
        public Void visitFieldAccess(RexFieldAccess fieldAccess) {
            SargRexAnalyzer.this.failed = true;
            return null;
        }
    }

    private class BooleanConvertlet
    extends CallConvertlet {
        private final SargSetOperator setOp;

        BooleanConvertlet(SargSetOperator setOp) {
            this.setOp = setOp;
        }

        public void convert(RexCall call) {
            if (SargRexAnalyzer.this.variableSeen || SargRexAnalyzer.this.coordinate != null) {
                SargRexAnalyzer.this.failed = true;
            }
            if (SargRexAnalyzer.this.failed) {
                return;
            }
            int nOperands = call.getOperands().size();
            assert (SargRexAnalyzer.this.exprStack.size() >= nOperands);
            SargSetExpr expr = SargRexAnalyzer.this.factory.newSetExpr(SargRexAnalyzer.this.boundInputRef.getType(), this.setOp);
            ListIterator iter = SargRexAnalyzer.this.exprStack.listIterator(SargRexAnalyzer.this.exprStack.size() - nOperands);
            while (iter.hasNext()) {
                expr.addChild((SargExpr)iter.next());
                iter.remove();
            }
            SargRexAnalyzer.this.exprStack.add(expr);
        }
    }

    private class ComparisonConvertlet
    extends CallConvertlet {
        private final SargBoundType boundType;
        private final SargStrictness strictness;

        ComparisonConvertlet(SargBoundType boundType, SargStrictness strictness) {
            this.boundType = boundType;
            this.strictness = strictness;
        }

        public void convert(RexCall call) {
            if (!SargRexAnalyzer.this.variableSeen) {
                SargRexAnalyzer.this.failed = true;
            }
            SqlOperator op = call.getOperator();
            switch (op.getKind()) {
                case IS_NULL: {
                    SargRexAnalyzer.this.coordinate = SargRexAnalyzer.this.factory.getRexBuilder().constantNull();
                    break;
                }
                case IS_TRUE: {
                    SargRexAnalyzer.this.coordinate = SargRexAnalyzer.this.factory.getRexBuilder().makeLiteral(true);
                    break;
                }
                case IS_FALSE: {
                    SargRexAnalyzer.this.coordinate = SargRexAnalyzer.this.factory.getRexBuilder().makeLiteral(false);
                    break;
                }
                default: {
                    if (SargRexAnalyzer.this.coordinate != null) break;
                    SargRexAnalyzer.this.failed = true;
                }
            }
            if (SargRexAnalyzer.this.failed) {
                return;
            }
            SargIntervalExpr expr = SargRexAnalyzer.this.factory.newIntervalExpr(SargRexAnalyzer.this.boundInputRef.getType());
            if (this.boundType == null) {
                expr.setPoint(SargRexAnalyzer.this.coordinate);
            } else {
                SargBoundType actualBound = this.boundType;
                if (SargRexAnalyzer.this.reverse) {
                    actualBound = actualBound == SargBoundType.LOWER ? SargBoundType.UPPER : SargBoundType.LOWER;
                }
                if (actualBound == SargBoundType.LOWER) {
                    expr.setLower(SargRexAnalyzer.this.coordinate, this.strictness);
                } else {
                    expr.setUpper(SargRexAnalyzer.this.coordinate, this.strictness);
                }
            }
            SargRexAnalyzer.this.exprStack.add(expr);
            SargRexAnalyzer.this.clearLeaf();
        }
    }

    private abstract class CallConvertlet {
        private CallConvertlet() {
        }

        public abstract void convert(RexCall var1);
    }
}

