/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.rel.rules;

import java.util.ArrayList;
import org.eigenbase.rel.JoinRelBase;
import org.eigenbase.rel.ProjectRel;
import org.eigenbase.rel.RelNode;
import org.eigenbase.rel.rules.PushProjector;
import org.eigenbase.relopt.RelOptRule;
import org.eigenbase.relopt.RelOptRuleCall;
import org.eigenbase.relopt.RelOptRuleOperand;
import org.eigenbase.reltype.RelDataTypeField;
import org.eigenbase.rex.RexNode;

public class PushProjectPastJoinRule
extends RelOptRule {
    public static final PushProjectPastJoinRule INSTANCE = new PushProjectPastJoinRule(PushProjector.ExprCondition.FALSE);
    private final PushProjector.ExprCondition preserveExprCondition;

    private PushProjectPastJoinRule(PushProjector.ExprCondition preserveExprCondition) {
        super(PushProjectPastJoinRule.operand(ProjectRel.class, PushProjectPastJoinRule.operand(JoinRelBase.class, PushProjectPastJoinRule.any()), new RelOptRuleOperand[0]));
        this.preserveExprCondition = preserveExprCondition;
    }

    public void onMatch(RelOptRuleCall call) {
        JoinRelBase join;
        ProjectRel origProj = (ProjectRel)call.rel(0);
        PushProjector pushProject = new PushProjector(origProj, (join = (JoinRelBase)call.rel(1)).getCondition(), join, this.preserveExprCondition);
        if (pushProject.locateAllRefs()) {
            return;
        }
        ProjectRel leftProjRel = pushProject.createProjectRefsAndExprs(join.getLeft(), true, false);
        ProjectRel rightProjRel = pushProject.createProjectRefsAndExprs(join.getRight(), true, true);
        RexNode newJoinFilter = null;
        int[] adjustments = pushProject.getAdjustments();
        if (join.getCondition() != null) {
            ArrayList<RelDataTypeField> projJoinFieldList = new ArrayList<RelDataTypeField>();
            projJoinFieldList.addAll(join.getSystemFieldList());
            projJoinFieldList.addAll(leftProjRel.getRowType().getFieldList());
            projJoinFieldList.addAll(rightProjRel.getRowType().getFieldList());
            newJoinFilter = pushProject.convertRefsAndExprs(join.getCondition(), projJoinFieldList, adjustments);
        }
        JoinRelBase newJoinRel = join.copy(join.getTraitSet(), newJoinFilter, leftProjRel, rightProjRel, join.getJoinType(), join.isSemiJoinDone());
        RelNode topProject = pushProject.createNewProject(newJoinRel, adjustments);
        call.transformTo(topProject);
    }
}

