/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.rel.rules;

import java.util.List;
import org.eigenbase.rel.JoinRelBase;
import org.eigenbase.rel.RelNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoptJoinTree {
    private BinaryTree factorTree;
    private RelNode joinTree;
    private boolean removableSelfJoin;

    public LoptJoinTree(RelNode joinTree, int factorId) {
        this.joinTree = joinTree;
        this.factorTree = new BinaryTree(factorId, this);
        this.removableSelfJoin = false;
    }

    public LoptJoinTree(RelNode joinTree, BinaryTree factorTree, boolean removableSelfJoin) {
        this.joinTree = joinTree;
        this.factorTree = factorTree;
        this.removableSelfJoin = removableSelfJoin;
    }

    public LoptJoinTree(RelNode joinTree, BinaryTree leftFactorTree, BinaryTree rightFactorTree) {
        this(joinTree, leftFactorTree, rightFactorTree, false);
    }

    public LoptJoinTree(RelNode joinTree, BinaryTree leftFactorTree, BinaryTree rightFactorTree, boolean removableSelfJoin) {
        this.factorTree = new BinaryTree(leftFactorTree, rightFactorTree, this);
        this.joinTree = joinTree;
        this.removableSelfJoin = removableSelfJoin;
    }

    public RelNode getJoinTree() {
        return this.joinTree;
    }

    public LoptJoinTree getLeft() {
        return new LoptJoinTree(((JoinRelBase)this.joinTree).getLeft(), this.factorTree.getLeft(), this.factorTree.getLeft().getParent().isRemovableSelfJoin());
    }

    public LoptJoinTree getRight() {
        return new LoptJoinTree(((JoinRelBase)this.joinTree).getRight(), this.factorTree.getRight(), this.factorTree.getRight().getParent().isRemovableSelfJoin());
    }

    public BinaryTree getFactorTree() {
        return this.factorTree;
    }

    public void getTreeOrder(List<Integer> treeOrder) {
        this.factorTree.getTreeOrder(treeOrder);
    }

    public boolean isRemovableSelfJoin() {
        return this.removableSelfJoin;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class BinaryTree {
        private int id;
        private BinaryTree left;
        private BinaryTree right;
        private LoptJoinTree parent;

        public BinaryTree(int rootId, LoptJoinTree parent) {
            this.id = rootId;
            this.left = null;
            this.right = null;
            this.parent = parent;
        }

        public BinaryTree(BinaryTree left, BinaryTree right, LoptJoinTree parent) {
            this.left = left;
            this.right = right;
            this.parent = parent;
        }

        public BinaryTree getLeft() {
            return this.left;
        }

        public BinaryTree getRight() {
            return this.right;
        }

        public LoptJoinTree getParent() {
            return this.parent;
        }

        public int getId() {
            assert (this.left == null && this.right == null);
            return this.id;
        }

        public void getTreeOrder(List<Integer> treeOrder) {
            if (this.left == null || this.right == null) {
                treeOrder.add(this.id);
            } else {
                this.left.getTreeOrder(treeOrder);
                this.right.getTreeOrder(treeOrder);
            }
        }
    }
}

