/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.rel;

import java.util.ArrayList;
import java.util.List;
import net.hydromatic.linq4j.Ord;
import org.eigenbase.rel.AggregateRel;
import org.eigenbase.rel.FilterRel;
import org.eigenbase.rel.IntersectRel;
import org.eigenbase.rel.JoinRel;
import org.eigenbase.rel.MinusRel;
import org.eigenbase.rel.ProjectRel;
import org.eigenbase.rel.RelNode;
import org.eigenbase.rel.RelShuttle;
import org.eigenbase.rel.SortRel;
import org.eigenbase.rel.TableAccessRelBase;
import org.eigenbase.rel.TableFunctionRelBase;
import org.eigenbase.rel.UnionRel;
import org.eigenbase.rel.ValuesRel;
import org.eigenbase.util.Stacks;

public class RelShuttleImpl
implements RelShuttle {
    protected final List<RelNode> stack = new ArrayList<RelNode>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RelNode visitChild(RelNode parent, int i, RelNode child) {
        Stacks.push(this.stack, parent);
        try {
            RelNode child2 = child.accept(this);
            if (child2 != child) {
                ArrayList<RelNode> newInputs = new ArrayList<RelNode>(parent.getInputs());
                newInputs.set(i, child2);
                RelNode relNode = parent.copy(parent.getTraitSet(), newInputs);
                return relNode;
            }
            RelNode relNode = parent;
            return relNode;
        }
        finally {
            Stacks.pop(this.stack, parent);
        }
    }

    protected RelNode visitChildren(RelNode rel) {
        for (Ord input : Ord.zip(rel.getInputs())) {
            rel = this.visitChild(rel, input.i, (RelNode)input.e);
        }
        return rel;
    }

    public RelNode visit(AggregateRel aggregate) {
        return this.visitChild(aggregate, 0, aggregate.getChild());
    }

    public RelNode visit(TableAccessRelBase scan) {
        return scan;
    }

    public RelNode visit(TableFunctionRelBase scan) {
        return this.visitChildren(scan);
    }

    public RelNode visit(ValuesRel values) {
        return values;
    }

    public RelNode visit(FilterRel filter) {
        return this.visitChild(filter, 0, filter.getChild());
    }

    public RelNode visit(ProjectRel project) {
        return this.visitChild(project, 0, project.getChild());
    }

    public RelNode visit(JoinRel join) {
        return this.visitChildren(join);
    }

    public RelNode visit(UnionRel union) {
        return this.visitChildren(union);
    }

    public RelNode visit(IntersectRel intersect) {
        return this.visitChildren(intersect);
    }

    public RelNode visit(MinusRel minus) {
        return this.visitChildren(minus);
    }

    public RelNode visit(SortRel sort) {
        return this.visitChildren(sort);
    }

    public RelNode visit(RelNode other) {
        return this.visitChildren(other);
    }
}

