/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.optiq.tools;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.hydromatic.optiq.tools.Program;
import net.hydromatic.optiq.tools.RuleSet;
import net.hydromatic.optiq.tools.RuleSets;
import org.eigenbase.rel.RelNode;
import org.eigenbase.rel.metadata.ChainedRelMetadataProvider;
import org.eigenbase.rel.metadata.RelMetadataProvider;
import org.eigenbase.rel.rules.ConvertMultiJoinRule;
import org.eigenbase.rel.rules.LoptOptimizeJoinRule;
import org.eigenbase.rel.rules.PushFilterPastJoinRule;
import org.eigenbase.rel.rules.PushJoinThroughJoinRule;
import org.eigenbase.rel.rules.SwapJoinRule;
import org.eigenbase.relopt.RelOptCostImpl;
import org.eigenbase.relopt.RelOptPlanner;
import org.eigenbase.relopt.RelOptRule;
import org.eigenbase.relopt.RelOptUtil;
import org.eigenbase.relopt.RelTraitSet;
import org.eigenbase.relopt.hep.HepMatchOrder;
import org.eigenbase.relopt.hep.HepPlanner;
import org.eigenbase.relopt.hep.HepProgram;
import org.eigenbase.relopt.hep.HepProgramBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Programs {
    private static final Function<RuleSet, Program> RULE_SET_TO_PROGRAM = new Function<RuleSet, Program>(){

        public Program apply(RuleSet ruleSet) {
            return Programs.of(ruleSet);
        }
    };

    private Programs() {
    }

    public static Program of(RuleSet ruleSet) {
        return new RuleSetProgram(ruleSet);
    }

    public static List<Program> listOf(RuleSet ... ruleSets) {
        return Lists.transform(Arrays.asList(ruleSets), RULE_SET_TO_PROGRAM);
    }

    public static Program ofRules(RelOptRule ... rules) {
        return Programs.of(RuleSets.ofList(rules));
    }

    public static Program ofRules(Collection<RelOptRule> rules) {
        return Programs.of(RuleSets.ofList(rules));
    }

    public static Program sequence(Program ... programs) {
        return new SequenceProgram((ImmutableList<Program>)ImmutableList.copyOf((Object[])programs));
    }

    public static Program hep(ImmutableList<RelOptRule> rules, boolean noDag, RelMetadataProvider metadataProvider) {
        HepProgramBuilder builder = HepProgram.builder();
        for (RelOptRule rule : rules) {
            builder.addRuleInstance(rule);
        }
        return Programs.of(builder.build(), noDag, metadataProvider);
    }

    public static Program of(final HepProgram hepProgram, final boolean noDag, final RelMetadataProvider metadataProvider) {
        return new Program(){

            public RelNode run(RelOptPlanner planner, RelNode rel, RelTraitSet requiredOutputTraits) {
                HepPlanner hepPlanner = new HepPlanner(hepProgram, null, noDag, null, RelOptCostImpl.FACTORY);
                if (metadataProvider != null) {
                    ArrayList list = Lists.newArrayList();
                    list.add(metadataProvider);
                    hepPlanner.registerMetadataProviders(list);
                    RelMetadataProvider plannerChain = ChainedRelMetadataProvider.of(list);
                    rel.getCluster().setMetadataProvider(plannerChain);
                }
                hepPlanner.setRoot(rel);
                return hepPlanner.findBestExp();
            }
        };
    }

    public static Program heuristicJoinOrder(final Collection<RelOptRule> rules) {
        return new Program(){

            public RelNode run(RelOptPlanner planner, RelNode rel, RelTraitSet requiredOutputTraits) {
                Program program;
                int joinCount = RelOptUtil.countJoins(rel);
                if (joinCount < 6) {
                    program = Programs.ofRules(rules);
                } else {
                    HepProgram hep = new HepProgramBuilder().addRuleInstance(PushFilterPastJoinRule.FILTER_ON_JOIN).addMatchOrder(HepMatchOrder.BOTTOM_UP).addRuleInstance(ConvertMultiJoinRule.INSTANCE).build();
                    Program program1 = Programs.of(hep, false, null);
                    ArrayList<RelOptRule> list = new ArrayList<RelOptRule>(rules);
                    list.removeAll((Collection<?>)ImmutableList.of((Object)SwapJoinRule.INSTANCE, (Object)PushJoinThroughJoinRule.LEFT, (Object)PushJoinThroughJoinRule.RIGHT));
                    list.add(LoptOptimizeJoinRule.INSTANCE);
                    Program program2 = Programs.ofRules(list);
                    program = Programs.sequence(program1, program2);
                }
                return program.run(planner, rel, requiredOutputTraits);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SequenceProgram
    implements Program {
        private final ImmutableList<Program> programs;

        SequenceProgram(ImmutableList<Program> programs) {
            this.programs = programs;
        }

        @Override
        public RelNode run(RelOptPlanner planner, RelNode rel, RelTraitSet requiredOutputTraits) {
            for (Program program : this.programs) {
                rel = program.run(planner, rel, requiredOutputTraits);
            }
            return rel;
        }
    }

    static class RuleSetProgram
    implements Program {
        final RuleSet ruleSet;

        private RuleSetProgram(RuleSet ruleSet) {
            this.ruleSet = ruleSet;
        }

        public RelNode run(RelOptPlanner planner, RelNode rel, RelTraitSet requiredOutputTraits) {
            planner.clear();
            for (RelOptRule rule : this.ruleSet) {
                planner.addRule(rule);
            }
            if (!rel.getTraitSet().equals(requiredOutputTraits)) {
                rel = planner.changeTraits(rel, requiredOutputTraits);
            }
            planner.setRoot(rel);
            return planner.findBestExp();
        }
    }
}

