/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.optiq.materialize;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.hydromatic.avatica.ColumnMetaData;
import net.hydromatic.linq4j.AbstractQueryable;
import net.hydromatic.linq4j.Enumerator;
import net.hydromatic.linq4j.QueryProvider;
import net.hydromatic.linq4j.expressions.Expression;
import net.hydromatic.linq4j.function.Function1;
import net.hydromatic.linq4j.function.Functions;
import net.hydromatic.optiq.DataContext;
import net.hydromatic.optiq.Schemas;
import net.hydromatic.optiq.Table;
import net.hydromatic.optiq.impl.clone.CloneSchema;
import net.hydromatic.optiq.impl.java.JavaTypeFactory;
import net.hydromatic.optiq.jdbc.MetaImpl;
import net.hydromatic.optiq.jdbc.OptiqConnection;
import net.hydromatic.optiq.jdbc.OptiqPrepare;
import net.hydromatic.optiq.jdbc.OptiqSchema;
import net.hydromatic.optiq.materialize.MaterializationActor;
import net.hydromatic.optiq.materialize.MaterializationKey;
import net.hydromatic.optiq.prepare.Prepare;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.reltype.RelDataTypeImpl;
import org.eigenbase.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MaterializationService {
    private static final MaterializationService INSTANCE = new MaterializationService();
    private static final ThreadLocal<MaterializationService> THREAD_INSTANCE = new ThreadLocal<MaterializationService>(){

        @Override
        protected MaterializationService initialValue() {
            return new MaterializationService();
        }
    };
    private final MaterializationActor actor = new MaterializationActor();

    private MaterializationService() {
    }

    public MaterializationKey defineMaterialization(OptiqSchema schema, String viewSql, List<String> viewSchemaPath, String tableName) {
        OptiqSchema.TableEntry tableEntry;
        final OptiqConnection connection = MetaImpl.connect(schema.root(), null);
        MaterializationKey key = new MaterializationKey();
        RelDataType rowType = null;
        if (tableName != null) {
            Table materializedTable;
            Pair<String, Table> pair = schema.getTable(tableName, true);
            Table table = materializedTable = pair == null ? null : (Table)pair.right;
            if (materializedTable == null) {
                final OptiqPrepare.PrepareResult<Object> prepareResult = Schemas.prepare(connection, schema, viewSchemaPath, viewSql);
                rowType = prepareResult.rowType;
                JavaTypeFactory typeFactory = connection.getTypeFactory();
                materializedTable = CloneSchema.createCloneTable(typeFactory, RelDataTypeImpl.proto(prepareResult.rowType), Functions.adapt((List)prepareResult.structType.columns, (Function1)new Function1<ColumnMetaData, ColumnMetaData.Rep>(){

                    public ColumnMetaData.Rep apply(ColumnMetaData column) {
                        return column.type.representation;
                    }
                }), new AbstractQueryable<Object>(){

                    public Enumerator<Object> enumerator() {
                        DataContext dataContext = Schemas.createDataContext(connection);
                        return prepareResult.enumerator(dataContext);
                    }

                    public Type getElementType() {
                        return Object.class;
                    }

                    public Expression getExpression() {
                        throw new UnsupportedOperationException();
                    }

                    public QueryProvider getProvider() {
                        return connection;
                    }

                    public Iterator<Object> iterator() {
                        DataContext dataContext = Schemas.createDataContext(connection);
                        return prepareResult.iterator(dataContext);
                    }
                });
                schema.add(tableName, materializedTable);
            }
            tableEntry = schema.add(tableName, materializedTable);
        } else {
            tableEntry = null;
        }
        if (rowType == null) {
            OptiqPrepare.ParseResult parse = Schemas.parse(connection, schema, viewSchemaPath, viewSql);
            rowType = parse.rowType;
        }
        MaterializationActor.Materialization materialization = new MaterializationActor.Materialization(key, schema.root(), tableEntry, viewSql, rowType);
        this.actor.keyMap.put(materialization.key, materialization);
        return key;
    }

    public OptiqSchema.TableEntry checkValid(MaterializationKey key) {
        MaterializationActor.Materialization materialization = this.actor.keyMap.get(key);
        if (materialization != null) {
            return materialization.materializedTable;
        }
        return null;
    }

    public List<Prepare.Materialization> query(OptiqSchema rootSchema) {
        ArrayList<Prepare.Materialization> list = new ArrayList<Prepare.Materialization>();
        for (MaterializationActor.Materialization materialization : this.actor.keyMap.values()) {
            if (materialization.rootSchema != rootSchema || materialization.materializedTable == null) continue;
            list.add(new Prepare.Materialization(materialization.materializedTable, materialization.sql));
        }
        return list;
    }

    public void clear() {
        this.actor.keyMap.clear();
    }

    public static void setThreadLocal() {
        THREAD_INSTANCE.set(new MaterializationService());
    }

    public static MaterializationService instance() {
        MaterializationService materializationService = THREAD_INSTANCE.get();
        if (materializationService != null) {
            return materializationService;
        }
        return INSTANCE;
    }
}

