/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.optiq.impl;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import net.hydromatic.linq4j.expressions.Expression;
import net.hydromatic.linq4j.expressions.Expressions;
import net.hydromatic.linq4j.expressions.MethodCallExpression;
import net.hydromatic.optiq.BuiltinMethod;
import net.hydromatic.optiq.DataContext;
import net.hydromatic.optiq.ImplementableFunction;
import net.hydromatic.optiq.QueryableTable;
import net.hydromatic.optiq.SchemaPlus;
import net.hydromatic.optiq.TableFunction;
import net.hydromatic.optiq.impl.ReflectiveFunctionBase;
import net.hydromatic.optiq.rules.java.CallImplementor;
import net.hydromatic.optiq.rules.java.NullPolicy;
import net.hydromatic.optiq.rules.java.ReflectiveCallNotNullImplementor;
import net.hydromatic.optiq.rules.java.RexImpTable;
import net.hydromatic.optiq.rules.java.RexToLixTranslator;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.reltype.RelDataTypeFactory;
import org.eigenbase.rex.RexCall;
import org.eigenbase.util.EigenbaseException;
import org.eigenbase.util.Static;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableFunctionImpl
extends ReflectiveFunctionBase
implements TableFunction,
ImplementableFunction {
    private final CallImplementor implementor;

    private TableFunctionImpl(Method method, CallImplementor implementor) {
        super(method);
        this.implementor = implementor;
    }

    public static TableFunction create(Class<?> clazz) {
        Method method = TableFunctionImpl.findMethod(clazz, "eval");
        if (method == null) {
            return null;
        }
        return TableFunctionImpl.create(method);
    }

    public static TableFunction create(Method method) {
        Class<?> clazz;
        if (!Modifier.isStatic(method.getModifiers()) && !TableFunctionImpl.classHasPublicZeroArgsConstructor(clazz = method.getDeclaringClass())) {
            throw Static.RESOURCE.requireDefaultConstructor(clazz.getName()).ex();
        }
        Class<?> returnType = method.getReturnType();
        if (!QueryableTable.class.isAssignableFrom(returnType)) {
            return null;
        }
        CallImplementor implementor = TableFunctionImpl.createImplementor(method);
        return new TableFunctionImpl(method, implementor);
    }

    @Override
    public RelDataType getRowType(RelDataTypeFactory typeFactory, List<Object> arguments) {
        return this.apply(arguments).getRowType(typeFactory);
    }

    @Override
    public Type getElementType(List<Object> arguments) {
        return this.apply(arguments).getElementType();
    }

    @Override
    public CallImplementor getImplementor() {
        return this.implementor;
    }

    private static CallImplementor createImplementor(Method method) {
        return RexImpTable.createImplementor(new ReflectiveCallNotNullImplementor(method){

            @Override
            public Expression implement(RexToLixTranslator translator, RexCall call, List<Expression> translatedOperands) {
                Expression expr = super.implement(translator, call, translatedOperands);
                MethodCallExpression queryable = Expressions.call((Expression)Expressions.convert_((Expression)expr, QueryableTable.class), (Method)BuiltinMethod.QUERYABLE_TABLE_AS_QUERYABLE.method, (Expression[])new Expression[]{Expressions.call((Expression)DataContext.ROOT, (Method)BuiltinMethod.DATA_CONTEXT_GET_QUERY_PROVIDER.method, (Expression[])new Expression[0]), Expressions.constant(null, SchemaPlus.class), Expressions.constant((Object)call.getOperator().getName(), String.class)});
                expr = Expressions.call((Expression)queryable, (Method)BuiltinMethod.QUERYABLE_AS_ENUMERABLE.method, (Expression[])new Expression[0]);
                return expr;
            }
        }, NullPolicy.ANY, false);
    }

    private QueryableTable apply(List<Object> arguments) {
        try {
            Object o = null;
            if (!Modifier.isStatic(this.method.getModifiers())) {
                o = this.method.getDeclaringClass().newInstance();
            }
            Object table = this.method.invoke(o, arguments.toArray());
            return (QueryableTable)table;
        }
        catch (IllegalArgumentException e) {
            throw (EigenbaseException)Static.RESOURCE.illegalArgumentForTableFunctionCall(this.method.toString(), Arrays.toString(this.method.getParameterTypes()), arguments.toString()).ex(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
    }
}

