/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.optiq;

import com.google.common.collect.ImmutableMap;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.TimeZone;
import net.hydromatic.linq4j.QueryProvider;
import net.hydromatic.linq4j.Queryable;
import net.hydromatic.linq4j.expressions.Expression;
import net.hydromatic.linq4j.expressions.Expressions;
import net.hydromatic.linq4j.expressions.MethodCallExpression;
import net.hydromatic.linq4j.expressions.Types;
import net.hydromatic.optiq.BuiltinMethod;
import net.hydromatic.optiq.DataContext;
import net.hydromatic.optiq.Function;
import net.hydromatic.optiq.FunctionParameter;
import net.hydromatic.optiq.QueryableTable;
import net.hydromatic.optiq.ScalarFunction;
import net.hydromatic.optiq.SchemaPlus;
import net.hydromatic.optiq.Table;
import net.hydromatic.optiq.config.OptiqConnectionConfig;
import net.hydromatic.optiq.impl.java.JavaTypeFactory;
import net.hydromatic.optiq.jdbc.OptiqConnection;
import net.hydromatic.optiq.jdbc.OptiqPrepare;
import net.hydromatic.optiq.jdbc.OptiqSchema;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.reltype.RelDataTypeFactory;
import org.eigenbase.reltype.RelProtoDataType;
import org.eigenbase.sql.type.SqlTypeUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Schemas {
    private Schemas() {
        throw new AssertionError((Object)"no instances!");
    }

    public static OptiqSchema.FunctionEntry resolve(RelDataTypeFactory typeFactory, String name, Collection<OptiqSchema.FunctionEntry> functionEntries, List<RelDataType> argumentTypes) {
        ArrayList<OptiqSchema.FunctionEntry> matches = new ArrayList<OptiqSchema.FunctionEntry>();
        for (OptiqSchema.FunctionEntry entry : functionEntries) {
            if (!Schemas.matches(typeFactory, entry.getFunction(), argumentTypes)) continue;
            matches.add(entry);
        }
        switch (matches.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return (OptiqSchema.FunctionEntry)matches.get(0);
            }
        }
        throw new RuntimeException("More than one match for " + name + " with arguments " + argumentTypes);
    }

    private static boolean matches(RelDataTypeFactory typeFactory, Function member, List<RelDataType> argumentTypes) {
        List<FunctionParameter> parameters = member.getParameters();
        if (parameters.size() != argumentTypes.size()) {
            return false;
        }
        for (int i = 0; i < argumentTypes.size(); ++i) {
            FunctionParameter parameter;
            RelDataType argumentType = argumentTypes.get(i);
            if (Schemas.canConvert(argumentType, (parameter = parameters.get(i)).getType(typeFactory))) continue;
            return false;
        }
        return true;
    }

    private static boolean canConvert(RelDataType fromType, RelDataType toType) {
        return SqlTypeUtil.canAssignFrom(toType, fromType);
    }

    public static Expression expression(SchemaPlus schema) {
        return schema.getExpression(schema.getParentSchema(), schema.getName());
    }

    public static Expression subSchemaExpression(SchemaPlus schema, String name, Class type) {
        Expression schemaExpression = Schemas.expression(schema);
        MethodCallExpression call = Expressions.call((Expression)schemaExpression, (Method)BuiltinMethod.SCHEMA_GET_SUB_SCHEMA.method, (Expression[])new Expression[]{Expressions.constant((Object)name)});
        return call;
    }

    public static Expression unwrap(Expression call, Class type) {
        return Expressions.convert_((Expression)Expressions.call((Expression)call, (Method)BuiltinMethod.SCHEMA_PLUS_UNWRAP.method, (Expression[])new Expression[]{Expressions.constant((Object)type)}), (Type)type);
    }

    public static Expression tableExpression(SchemaPlus schema, Type elementType, String tableName, Class clazz) {
        MethodCallExpression expression = Table.class.isAssignableFrom(clazz) ? Expressions.call((Expression)Schemas.expression(schema), (Method)BuiltinMethod.SCHEMA_GET_TABLE.method, (Expression[])new Expression[]{Expressions.constant((Object)tableName)}) : Expressions.call((Method)BuiltinMethod.SCHEMAS_QUERYABLE.method, (Expression[])new Expression[]{DataContext.ROOT, Schemas.expression(schema), Expressions.constant((Object)elementType), Expressions.constant((Object)tableName)});
        return Types.castIfNecessary((Type)clazz, (Expression)expression);
    }

    public static DataContext createDataContext(Connection connection) {
        return new DummyDataContext((OptiqConnection)connection);
    }

    public static <E> Queryable<E> queryable(DataContext root, Class<E> clazz, String ... names) {
        SchemaPlus schema = root.getRootSchema();
        for (int i = 0; i < names.length - 1; ++i) {
            String name = names[i];
            schema = schema.getSubSchema(name);
        }
        String tableName = names[names.length - 1];
        return Schemas.queryable(root, schema, clazz, tableName);
    }

    public static <E> Queryable<E> queryable(DataContext root, SchemaPlus schema, Class<E> clazz, String tableName) {
        QueryableTable table = (QueryableTable)schema.getTable(tableName);
        return table.asQueryable(root.getQueryProvider(), schema, tableName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OptiqPrepare.ParseResult parse(OptiqConnection connection, OptiqSchema schema, List<String> schemaPath, String sql) {
        OptiqPrepare prepare = (OptiqPrepare)OptiqPrepare.DEFAULT_FACTORY.apply();
        OptiqPrepare.Context context = Schemas.makeContext(connection, schema, schemaPath);
        OptiqPrepare.Dummy.push(context);
        try {
            OptiqPrepare.ParseResult parseResult = prepare.parse(context, sql);
            return parseResult;
        }
        finally {
            OptiqPrepare.Dummy.pop(context);
        }
    }

    public static OptiqPrepare.PrepareResult<Object> prepare(OptiqConnection connection, OptiqSchema schema, List<String> schemaPath, String sql) {
        OptiqPrepare prepare = (OptiqPrepare)OptiqPrepare.DEFAULT_FACTORY.apply();
        return prepare.prepareSql(Schemas.makeContext(connection, schema, schemaPath), sql, null, (Type)((Object)Object[].class), -1);
    }

    private static OptiqPrepare.Context makeContext(OptiqConnection connection, OptiqSchema schema, List<String> schemaPath) {
        if (connection == null) {
            OptiqPrepare.Context context0 = OptiqPrepare.Dummy.peek();
            return Schemas.makeContext(context0.config(), context0.getTypeFactory(), context0.getDataContext(), schema, schemaPath);
        }
        return Schemas.makeContext(connection.config(), connection.getTypeFactory(), Schemas.createDataContext(connection), schema, schemaPath);
    }

    private static OptiqPrepare.Context makeContext(final OptiqConnectionConfig connectionConfig, final JavaTypeFactory typeFactory, final DataContext dataContext, final OptiqSchema schema, final List<String> schemaPath) {
        return new OptiqPrepare.Context(){

            @Override
            public JavaTypeFactory getTypeFactory() {
                return typeFactory;
            }

            @Override
            public OptiqSchema getRootSchema() {
                return schema.root();
            }

            @Override
            public List<String> getDefaultSchemaPath() {
                if (schemaPath == null) {
                    return schema.path(null);
                }
                return schemaPath;
            }

            @Override
            public OptiqConnectionConfig config() {
                return connectionConfig;
            }

            @Override
            public DataContext getDataContext() {
                return dataContext;
            }

            @Override
            public OptiqPrepare.SparkHandler spark() {
                boolean enable = this.config().spark();
                return OptiqPrepare.Dummy.getSparkHandler(enable);
            }
        };
    }

    public static RelProtoDataType proto(final Table table) {
        return new RelProtoDataType(){

            public RelDataType apply(RelDataTypeFactory typeFactory) {
                return table.getRowType(typeFactory);
            }
        };
    }

    public static RelProtoDataType proto(final ScalarFunction function) {
        return new RelProtoDataType(){

            public RelDataType apply(RelDataTypeFactory typeFactory) {
                return function.getReturnType(typeFactory);
            }
        };
    }

    private static class DummyDataContext
    implements DataContext {
        private final OptiqConnection connection;
        private final ImmutableMap<String, Object> map;

        public DummyDataContext(OptiqConnection connection) {
            this.connection = connection;
            this.map = ImmutableMap.of((Object)"timeZone", (Object)TimeZone.getDefault());
        }

        public SchemaPlus getRootSchema() {
            return this.connection.getRootSchema();
        }

        public JavaTypeFactory getTypeFactory() {
            return this.connection.getTypeFactory();
        }

        public QueryProvider getQueryProvider() {
            return this.connection;
        }

        public Object get(String name) {
            return this.map.get((Object)name);
        }
    }
}

