/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.multimap.operations;

import com.hazelcast.core.EntryEventType;
import com.hazelcast.multimap.MultiMapRecord;
import com.hazelcast.multimap.operations.MultiMapBackupAwareOperation;
import com.hazelcast.multimap.operations.MultiMapResponse;
import com.hazelcast.multimap.operations.RemoveAllBackupOperation;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.Operation;
import com.hazelcast.util.Clock;
import java.util.Collection;

public class RemoveAllOperation
extends MultiMapBackupAwareOperation {
    transient Collection<MultiMapRecord> coll;
    transient long begin = -1L;

    public RemoveAllOperation() {
    }

    public RemoveAllOperation(String name, Data dataKey, int threadId) {
        super(name, dataKey, threadId);
    }

    @Override
    public void run() throws Exception {
        this.begin = Clock.currentTimeMillis();
        this.coll = this.remove();
        this.response = new MultiMapResponse(this.coll);
    }

    @Override
    public void afterRun() throws Exception {
        long elapsed = Math.max(0L, Clock.currentTimeMillis() - this.begin);
        if (this.coll != null) {
            this.getOrCreateContainer().update();
            for (MultiMapRecord record : this.coll) {
                this.publishEvent(EntryEventType.REMOVED, this.dataKey, record.getObject());
            }
        }
    }

    @Override
    public boolean shouldBackup() {
        return this.coll != null;
    }

    @Override
    public Operation getBackupOperation() {
        return new RemoveAllBackupOperation(this.name, this.dataKey);
    }

    @Override
    public void onWaitExpire() {
        this.getResponseHandler().sendResponse(new MultiMapResponse(null));
    }

    @Override
    public int getId() {
        return 18;
    }
}

