/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.util.concurrent.atomic.AtomicLong;

public class SizeBasedThrottler {
    private final long threshold;
    private final AtomicLong currentSize;

    public SizeBasedThrottler(long threshold) {
        if (threshold <= 0L) {
            throw new IllegalArgumentException("Treshold must be greater than 0");
        }
        this.threshold = threshold;
        this.currentSize = new AtomicLong(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized long increase(long delta) throws InterruptedException {
        if (this.currentSize.get() >= this.threshold) {
            SizeBasedThrottler sizeBasedThrottler = this;
            synchronized (sizeBasedThrottler) {
                while (this.currentSize.get() >= this.threshold) {
                    this.wait();
                }
            }
        }
        return this.currentSize.addAndGet(delta);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized long decrease(long delta) {
        long newSize = this.currentSize.addAndGet(-delta);
        if (newSize < this.threshold && newSize + delta >= this.threshold) {
            SizeBasedThrottler sizeBasedThrottler = this;
            synchronized (sizeBasedThrottler) {
                this.notifyAll();
            }
        }
        return newSize;
    }

    public synchronized long getCurrentValue() {
        return this.currentSize.get();
    }

    public long getThreshold() {
        return this.threshold;
    }
}

